*# // read transport temperature
*#If(oMaxIndexElemGroups<oMaxReinfGroups)
*#Set Var oMaxIndexElemGroups=oMaxReinfGroups
*#EndIf
*#
Load CASE ID *Operation(IntervalIndex*IncrTemperatureLC+StepNumberI) NAME "Transport Load Case *IntvData(LOAD_NAME)"
*If(IntvData(Apply_temperature_to_reinforcement,Int)==1)
Load TEMPERATURE  HISTORY IMPORT
*Else
*If(oMinIndexElemGroups<oMaxIndexElemGroups)
Load TEMPERATURE GROUP *oMinIndexElemGroups TO *oMaxIndexElemGroups  HISTORY IMPORT
*Else
Load TEMPERATURE GROUP *OneGroupID  HISTORY IMPORT
*EndIf
*EndIf
*#
*#
*#
*Set var soucthis = 1.0
*If(strcmp(Units(TIME),"day")==0)
*Set var soucthis = 86400.0
*ElseIf(strcmp(Units(TIME),"hour")==0))
*Set var soucthis = 3600.0
*ElseIf(strcmp(Units(TIME),"sec")==0))
*Set var soucthis = 1.0
*EndIf
*#
*Set var souctransport = 1.0
*If(strcmp(GenData(TIME_UNIT_IN_TRANSPORT),"day")==0)
*Set var souctransport = 86400.0
*ElseIf(strcmp(GenData(TIME_UNIT_IN_TRANSPORT),"hour")==0))
*Set var souctransport = 3600.0
*ElseIf(strcmp(GenData(TIME_UNIT_IN_TRANSPORT),"sec")==0))
*Set var souctransport = 1.0
*EndIf
*#
*Set var souc = 1.0
*Set var souc = operation(soucthis/souctransport)

// this problemtype time unit = *Units(TIME) 
// unit in transport problemtype = *GenData(TIME_UNIT_IN_TRANSPORT) 
// coeff = *soucthis / *souctransport = *souc

*#
		GEOMETRY "*GenData(IMPORT_FROM_GEOMETRY)"
		RESULTS  "*GenData(IMPORT_FROM_RESULTS)" TIME REFERENCE *Operation(StartTIME*souc) TARGET *Operation(TargetTIME*souc)
*#
*#EndIf
