*# // begin block of Spring
*Set Var ioSpring=-1
*Set Var LastCurrentType=-1
*Set Var CurrentType=0
*Set Var index=InitElemSpringID
*Intformat "%10i"
*#
*loop Intervals
*#
*Set Cond Spring_for_Surface *elems   *CanRepeat
*#
*If(CondNumEntities(Int)>0)
*WarningBox Info: You can only define Springs in the first Interval
// selection has *CondNumEntities entities
*loop elems *OnlyInCond
*# vyhozeno issue 1347
*#If(ElemsNnode!=20 || ElemsNnode!=8)
*#WarningBox Info: Elemental springs are programmed experimentaly For Linear or Quadratic brick(Shell). Check it For other element types.
*#EndIf
*#
*If(strcmp(Cond(Geometrical_Non-Linearity),"LINEAR")==0)
*# ElemsNnodeFace je 1 a proto ...
*Set Var CurrentType=1
*#// *\*WarningBox Warning: Element type1 *Cond(Geometrical_Non-Linearity), *AddingNonLinElemID
*Else
*Set Var CurrentType=Operation(AddingNonLinElemID+1)
*#// *\*WarningBox Warning: Element type2 *Cond(Geometrical_Non-Linearity), *AddingNonLinElemID
*EndIf
*#
*include ..\include.src.bas\SpringNumbering.bas
*#
*If(CurrentType==1)
	ELEMENT TYPE ID *index /** 1**/ NAME "Element type #*CurrentType for Linear Material" TYPE "CCPlaneSpring" LINEAR ;
*ElseIf(CurrentType==31)
	ELEMENT TYPE ID *index /** 31**/ NAME "Element type #*CurrentType for NonLin Material" TYPE "CCPlaneSpring" NONLINEAR ;
*EndIf
  ;
*If(strcmp(Cond(Spring_Non-Linearity),"NONLINEAR")==0)
FUNCTION ID *index
  NAME "Function for Spring condition"
  TYPE "CCMultiLinearFunction" REMOVE_ALL 
  xvalues *\
*for(i=2;i<=Cond(F_of_Eps_diagram,Int);i=i+2)
  *Cond(F_of_Eps_diagram,*i) *\
*End

  yvalues *\
*for(i=1;i<=Cond(F_of_Eps_diagram,Int);i=i+2)
  *Cond(F_of_Eps_diagram,*i) *\
*End
 ;
*EndIf
*#

MATERIAL ID *index
  NAME "Material Spring as Cond"
  TYPE "*Cond(Material_Prototype)"
*If(strcmp(Cond(Spring_Non-Linearity),"LINEAR")==0)
  K *Cond(Initial_stiffness-K)
*Else
  FUNCTION *index
*EndIf

*If(strcmp(GenData(Calculation_Analysis),"Dynamic")==0)
*If(Cond(Activate_Particular_Damping,Int)==1)
  DAMPING_MASS *Cond(DAMPING_MASS_COEFFICIENT,Real)
  DAMPING_STIFF *Cond(DAMPING_STIFFNESS_COEFFICIENT,Real)  
*EndIf
*EndIf

 ;
 GEOMETRY ID *index 
  NAME "Geometry for Spring" 
  TYPE *\ 
*If(strcmp(Cond(Coordinate_System),"GLOBAL")==0)
    "Spring" 
  DIRECTION *Cond(Dir_X,Real) *Cond(Dir_Y,Real) *\
*if(ndime==3)
    *Cond(Dir_Z,Real)
*EndIf
*ElseIf(strcmp(Cond(Coordinate_System),"NORMAL_OF_SURFACE")==0)
*include ..\include.src.bas\NormalVector_ElementalSurface.bas
*Set Var dln=Operation(sqrt(nx*nx+ny*ny+nz*nz))
*#
*# *ElemsNnode x1 *ElemsNnodeFace x2
*Set Var length=Cond(Spring_Length,Real)
    "Spring" 
    DIRECTION *Operation(nx/dln*length) *Operation(ny/dln*length) *\
*if(ndime==3)
    *Operation(nz/dln*length)
*EndIf    
*ElseIf(strcmp(Cond(Coordinate_System),"TANGENT_OF_SURFACE")==0)
*include ..\include.src.bas\NormalVector_ElementalSurface.bas
*Set Var dln=Operation(sqrt(nx*nx+ny*ny+nz*nz))
*Set Var vx=Cond(Vx,Real)
*Set Var vy=Cond(Vy,Real)
*Set Var vz=Cond(Vz,Real)
*Set Var T2x=Operation(ny*vz-nz*vy)
*Set Var T2y=Operation(nz*vx-nx*vz)
*Set Var T2z=Operation(nx*vy-ny*vx)
*Set Var T1x=Operation(T2y*nz-T2z*ny)
*Set Var T1y=Operation(T2z*nx-T2x*nz)
*Set Var T1z=Operation(T2x*ny-T2y*nx)
*If(strcmp(Cond(Direction),"T1")==0)
*Set Var vx=Operation(1.0*T1x)
*Set Var vy=Operation(1.0*T1y)
*Set Var vz=Operation(1.0*T1z)
*Else
*Set Var vx=Operation(1.0*T2x)
*Set Var vy=Operation(1.0*T2y)
*Set Var vz=Operation(1.0*T2z)
*EndIf
*Set Var dln=Operation(sqrt(vx*vx+vy*vy+vz*vz))
*#
*# *ElemsNnode x1 *ElemsNnodeFace x2
*Set Var length=Cond(Spring_Length,Real)
    "Spring" direction *Operation(vx/dln*length) *Operation(vy/dln*length) *\
*if(ndime==3)
    *Operation(vz/dln*length)    
*EndIf
*EndIf
*# // center of face of element *elemsnum
*# JOINT COORDINATES
*# *Set Var findef=index
*#   *findex *fx *fy *fz
*tcl(TK_Check_Warning_Spring_Beam_Shell *ElemsMatProp(0) *index)
 ELEMENT GROUP ID *index TYPE *index /** *ElemsMatProp(0) - *CurrentType **/ MATERIAL *index GEOMETRY  *index
 ELEMENT INCIDENCES
*# // *ElemsMatProp(0) *ElemsMatProp(1)
/** original 3d element id *elemsnum **/ 
*include ..\include.src.bas\Spring_Element_Conectivity.bas

*#Set Var ioSpring=Operation(ioSpring+1)
*Set Var LastCurrentType=CurrentType
*#
*End elems
*EndIf
*#
// *\
*break
*End interval
