proc TK_GenerateVariable_3D_print_MasterFlow_3D { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
   
    # set oBaseMaterial [GiD_AccessValue get materials $QUESTION]
  	set BaseMaterial [DWLocalGetValue $GDN $STRUCT $QUESTION]
  	set Generate [DWLocalGetValue $GDN $STRUCT 3D_print_MasterFlow_3D_Generate_Material]
 if { $Generate == "No" } {
 } else {
 
# WarnWinText $BaseMaterial  	
 WarnWinText "Material parameters MasterFlow 3D:"

  set FunctionE "#N# 48 0	0 1800	264 3600	523 7200	733 10800	782 14400	1087 18000	2326 21600	5651 28800	16495 36000	21648 43200	24104 64800	27459 86400	29061 129600	30807 172800	31820 259200	33038 345600	33787 432000	34312 518400	34707 604800	35020 864000	35668 1209600	36184 1814400	36680 2419200	36947"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_E_ $FunctionE]
    WarnWinText "Function_for_E_ generated"
    
  set FunctionFC "#N# 48 0 0 1800	-0.00255 3600	-0.01001 7200	-0.01966 10800	-0.02237 14400	-0.04328 18000	-0.19812 21600	-1.1699 28800	-9.9667 36000	-17.167 43200	-21.282 64800	-27.619 86400	-30.934 129600	-34.763 172800	-37.089 259200	-39.982 345600	-41.813 432000	-43.123 518400	-44.124 604800	-44.923 864000	-46.599 1209600	-47.958 1814400	-49.282 2419200	-50.000"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_FC $FunctionFC]
    WarnWinText "Function_for_FC generated"
    
  set FunctionFT "#N# 48 0	0 1800	0.00161 3600	0.00634 7200	0.01245 10800	0.01417 14400	0.02741 18000	0.10196 21600	0.33309 28800	1.38938 36000	1.99638 43200	2.304 64800	2.741 86400	2.956 129600	3.195 172800	3.336 259200	3.508 345600	3.614 432000	3.689 518400	3.746 604800	3.791 864000	3.885 1209600	3.96 1814400	4.033 2419200	4.072"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_FT $FunctionFT]
    WarnWinText "Function_for_FT generated"

  set FunctionGF "#N# 48 0	0.00000000 1800	0.00002491 3600	0.00003187 7200	0.00003599 10800	0.00003684 14400	0.00004148 18000	0.00005455 21600	0.00007509 28800	0.00011042 36000	0.00012178 43200	0.00012658 64800	0.00013266 86400	0.00013539 129600	0.00013827 172800	0.00013989 259200	0.00014179 345600	0.00014294 432000	0.00014374 518400	0.00014433 604800	0.00014480 864000	0.00014576 1209600	0.00014651 1814400	0.00014723 2419200	0.00014762"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_GF $FunctionGF]
    WarnWinText "Function_for_GF generated"        
  
  set FunctionFC0 "#N# 48 0	0 1800	-0.0017 3600	-0.00667 7200	-0.01311 10800	-0.01492 14400	-0.02885 18000	-0.13208 21600	-0.7799 28800	-6.6444 36000	-11.444 43200	-14.188 64800	-18.412 86400	-20.623 129600	-23.176 172800	-24.726 259200	-26.654 345600	-27.876 432000	-28.749 518400	-29.416 604800	-29.948 864000	-31.066 1209600	-31.972 1814400	-32.855 2419200	-33.334"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_Fc0 $FunctionFC0]
    WarnWinText "Function_for_Fc0 generated"
  
  set on [DWLocalSetValue $GDN $STRUCT Activate_Function_for_EPS_CP 1]
  set FunctionEPS "#N# 48 0	0.000000000 1800	-0.000000069 3600	-0.000000271 7200	-0.000000532 10800	-0.000000606 14400	-0.000001171 18000	-0.000005362 21600	-0.000031670 28800	-0.000269760 36000	-0.000464600 43200	-0.000576000 64800	-0.000747500 86400	-0.000837300 129600	-0.000940900 172800	-0.001003900 259200	-0.001082200 345600	-0.001131700 432000	-0.001167200 518400	-0.001194300 604800	-0.001215900 864000	-0.001261300 1209600	-0.001298000 1814400	-0.001333900 2419200	-0.001353300"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_EPS_CP $FunctionEPS]
    WarnWinText "Function_for_EPS_CP generated"  
       
  set on [DWLocalSetValue $GDN $STRUCT Critical_Comp_Disp-WD -0.0005m] 
    WarnWinText "Critical_Comp_Disp-WD = -0.0005m"
		      
  set on [DWLocalSetValue $GDN $STRUCT Activate_Aggregate_Interlock 1]
  set on [DWLocalSetValue $GDN $STRUCT Agg_Size 0.001m]
    WarnWinText "Agg_Size = 0.001m"    
  set on [DWLocalSetValue $GDN $STRUCT Excentricity-EXC 0.52] 
    WarnWinText "Excentricity-EXC = 0.52"
  set on [DWLocalSetValue $GDN $STRUCT Dir_of_pl_Flow-BETA 0.0] 
    WarnWinText "Dir_of_pl_Flow-BETA = 0.0"
  set on [DWLocalSetValue $GDN $STRUCT Poisson_s_Ratio 0.2] 
    WarnWinText "Poisson_s_Ratio = 0.2"    
  set on [DWLocalSetValue $GDN $STRUCT Rho-Density 0.0023kton/m^3] 
    WarnWinText "Rho-Density = 0.0023kton/m^3"
  set on [DWLocalSetValue $GDN $STRUCT Thermal_Expansion-Alpha 0.000012C^-1] 
    WarnWinText "Thermal_Expansion-Alpha = 0.000012"
  set on [DWLocalSetValue $GDN $STRUCT Fixed_Crack 1] 
    WarnWinText "Fixed_Crack = 1"
  
  WarnWinText "Parameters of concerete were updated"
  WarnWinText "------------------------------------"
      set on [DWLocalSetValue $GDN $STRUCT 3D_print_MasterFlow_3D_Generate_Material No]

  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}


proc TK_GenerateVariable_3D_print_Sikacrete7100_3D { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
   
    # set oBaseMaterial [GiD_AccessValue get materials $QUESTION]
  	set BaseMaterial [DWLocalGetValue $GDN $STRUCT $QUESTION]
  	set Generate [DWLocalGetValue $GDN $STRUCT 3D_print_Sikacrete7100_3D_Generate_Material]
 if { $Generate == "No" } {
 } else {
 
# WarnWinText $BaseMaterial  	
 WarnWinText "Material parameters Sikacrete7100 3D:"


 

  set FunctionE "#N# 48 0	0 1800	384 3600	616 7200	772 10800	831 14400	959 18000	1218 21600	1684 28800	3665 36000	7817 43200	13578 64800	23729 86400	27441 129600	30796 172800	32536 259200	34511 345600	35691 432000	36514 518400	37137 604800	37634 864000	38689 1209600	39580 1814400	40529 2419200	41122"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_E_ $FunctionE]
    WarnWinText "Function_for_E_ generated"
    
  set FunctionFC "#N# 48 0	0 1800	-0.00609 3600	-0.01573 7200	-0.02468 10800	-0.02856 14400	-0.03809 18000	-0.06137 21600	-0.1173 28800	-0.5559 36000	-2.53 43200	-7.632 64800	-23.309 86400	-31.171 129600	-39.258 172800	-43.822 259200	-49.303 345600	-52.73 432000	-55.191 518400	-57.091 604800	-58.629 864000	-61.964 1209600	-64.848 1814400	-67.995 2419200	-70.000"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_FC $FunctionFC]
    WarnWinText "Function_for_FC generated"
    
  set FunctionFT "#N# 48 0	0 1800	0.00386 3600	0.00996 7200	0.01563 10800	0.01809 14400	0.02412 18000	0.03887 21600	0.0719 28800	0.20283 36000	0.55697 43200	1.163 64800	2.448 86400	2.971 129600	3.465 172800	3.729 259200	4.034 345600	4.219 432000	4.349 518400	4.448 604800	4.528 864000	4.698 1209600	4.842 1814400	4.998 2419200	5.096"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_FT $FunctionFT]
    WarnWinText "Function_for_FT generated"

  set FunctionGF "#N# 48 0	0 1800	0.00002914 3600	0.00003457 7200	0.00003749 10800	0.00003849 14400	0.00004054 18000	0.00004417 21600	0.00004964 28800	0.00006568 36000	0.00008627 43200	0.00010524 64800	0.00012867 86400	0.00013558 129600	0.00014133 172800	0.00014415 259200	0.00014724 345600	0.00014904 432000	0.00015027 518400	0.00015118 604800	0.00015191 864000	0.00015343 1209600	0.00015469 1814400	0.00015602 2419200	0.00015683"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_GF $FunctionGF]
    WarnWinText "Function_for_GF generated"        
  
  set FunctionFC0 "#N# 48 0	0 1800	-0.00406 3600	-0.01049 7200	-0.01645 10800	-0.01904 14400	-0.02539 18000	-0.04092 21600	-0.0782 28800	-0.3706 36000	-1.686 43200	-5.088 64800	-15.539 86400	-20.781 129600	-26.172 172800	-29.215 259200	-32.869 345600	-35.153 432000	-36.794 518400	-38.06 604800	-39.086 864000	-41.309 1209600	-43.232 1814400	-45.33 2419200	-46.668"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_Fc0 $FunctionFC0]
    WarnWinText "Function_for_Fc0 generated"
  
  set on [DWLocalSetValue $GDN $STRUCT Activate_Function_for_EPS_CP 1]
  set FunctionEPS "#N# 48 0	0 1800	-0.000000148 3600	-0.000000383 7200	-0.000000600 10800	-0.000000695 14400	-0.000000926 18000	-0.000001492 21600	-0.000002850 28800	-0.000013520 36000	-0.000061500 43200	-0.000185600 64800	-0.000566800 86400	-0.000758000 129600	-0.000954700 172800	-0.001065700 259200	-0.001198900 345600	-0.001282300 432000	-0.001342100 518400	-0.001388300 604800	-0.001425700 864000	-0.001506800 1209600	-0.001577000 1814400	-0.001653500 2419200	-0.001702300"
  set on [DWLocalSetValue $GDN $STRUCT Function_for_EPS_CP $FunctionEPS]
    WarnWinText "Function_for_EPS_CP generated"  
       
  set on [DWLocalSetValue $GDN $STRUCT Critical_Comp_Disp-WD -0.0005m] 
    WarnWinText "Critical_Comp_Disp-WD = -0.0005m"
		      
  set on [DWLocalSetValue $GDN $STRUCT Activate_Aggregate_Interlock 1]
  set on [DWLocalSetValue $GDN $STRUCT Agg_Size 0.001m]
    WarnWinText "Agg_Size = 0.001m"    
  set on [DWLocalSetValue $GDN $STRUCT Excentricity-EXC 0.52] 
    WarnWinText "Excentricity-EXC = 0.52"
  set on [DWLocalSetValue $GDN $STRUCT Dir_of_pl_Flow-BETA 0.0] 
    WarnWinText "Dir_of_pl_Flow-BETA = 0.0"
  set on [DWLocalSetValue $GDN $STRUCT Poisson_s_Ratio 0.2] 
    WarnWinText "Poisson_s_Ratio = 0.2"    
  set on [DWLocalSetValue $GDN $STRUCT Rho-Density 0.0023kton/m^3] 
    WarnWinText "Rho-Density = 0.0023kton/m^3"
  set on [DWLocalSetValue $GDN $STRUCT Thermal_Expansion-Alpha 0.000012C^-1] 
    WarnWinText "Thermal_Expansion-Alpha = 0.000012"
  set on [DWLocalSetValue $GDN $STRUCT Fixed_Crack 1] 
    WarnWinText "Fixed_Crack = 1"
  
  WarnWinText "Parameters of concerete were updated"
  WarnWinText "------------------------------------"
      set on [DWLocalSetValue $GDN $STRUCT 3D_print_Sikacrete7100_3D_Generate_Material No]

  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}


proc TK_GenerateVariable_3D_print_fc_generate { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
   
    # set oBaseMaterial [GiD_AccessValue get materials $QUESTION]
  	set BaseMaterial [DWLocalGetValue $GDN $STRUCT $QUESTION]
  	set Generate [DWLocalGetValue $GDN $STRUCT 3D_print_fc_generate_Generate_Material]
    
   	set fc_generate_fc28_Value [DWLocalGetValue $GDN $STRUCT fc_generate_fc28_Value]
    
   
    set n1 [GidConvertValueUnit $fc_generate_fc28_Value]
    set n1 [ParserNumberUnit $n1 fc_generate_fc28_Value fc_generate_fc28_ValueUnit]
    
    #WarnWinText $fc_generate_fc28_Value
    #WarnWinText $fc_generate_fc28_ValueUnit
    set factor [GidTclGetUnitFactor "MPa"]
    #WarnWinText $factor 
    
    set fc_generate_fc28_Value [expr $fc_generate_fc28_Value/$factor]
    #WarnWinText $fc_generate_fc28_Value
    set fc_generate_fc28_Value [expr double(round(1000*$fc_generate_fc28_Value))/1000]
    #WarnWinText $StrengthValue    
    set fc_generate_fc28_Value_possitive $fc_generate_fc28_Value
    if { $fc_generate_fc28_Value <0 } {
      set fc_generate_fc28_Value_possitive [expr -1.0 * $fc_generate_fc28_Value]
    } 
    set fc_generate_fc28_Value_negative [expr -1.0 * $fc_generate_fc28_Value_possitive]    
    
    
 if { $Generate == "No" } {
 } else {
 
# WarnWinText $BaseMaterial  	
 WarnWinText "Material parameters fc_generate for fc28 = $fc_generate_fc28_Value MPa:"


  set index_question [LabelField $GDN $STRUCT fc_generate_Strength_Value_Function]

  set value [Field2String $GDN $STRUCT $index_question]

  #set value [DWLocalGetValue $GDN $STRUCT fc_generate_Strength_Value_Function]
  set on [lindex $value 1]
  set FunctionE "#N# 0"
  set FunctionFC "#N# 0"
  set FunctionFT "#N# 0"
  set FunctionGF "#N# 0"
  set FunctionFC0 "#N# 0"
  set FunctionEPS "#N# 0"
  
  
  WarnWinText "input fc_generate_Strength_Value_Function: $value"
  #WarnWinText "FunctionE: $FunctionE"
  
#  WarnWinText "fc_generate_fc28_Value_possitive: $fc_generate_fc28_Value_possitive"
  set fc_generate_e28_ValuePred [expr (6000 + (15.5 * $fc_generate_fc28_Value_negative))] 
  set fc_generate_e28_ValueOdm [expr pow($fc_generate_fc28_Value_possitive,[expr 1.0/2.0])]
  set fc_generate_e28_Value [expr $fc_generate_e28_ValuePred * $fc_generate_e28_ValueOdm]

	for {set i 2 } { $i <= $on } { set i [expr $i + 2] } {
	  set array_time [lindex $value $i]
	  set array_value [lindex $value [expr $i+1]]
      if { $array_value >0 } {
      set array_value [expr -1.0 * $array_value]
      } 
      set array_value_possitive [expr -1.0 * $array_value]
      
      #WarnWinText "fc_value: $array_value"
      
#      WarnWinText "fc_generate_fc28_Value_negative: $fc_generate_fc28_Value_negative"
      set valueEpred [expr (6000 + (15.5 * $fc_generate_fc28_Value_negative))]
      #set valueOdmE [expr ($array_value_possitive)^(0.5)]
      set valueOdmE [expr 1.0*pow($array_value_possitive,[expr 1.0/2.0])] 
      set valueE [expr $valueEpred * $valueOdmE]
      set valueE [format %10.5g $valueE]
	  set FunctionE [AddItem2Array $FunctionE $array_time]
	  set FunctionE [AddItem2Array $FunctionE $valueE ]

      # WarnWinText "FunctionE: $valueEpred * $valueOdmE = $valueE"

	  set FunctionFC [AddItem2Array $FunctionFC $array_time]
	  set FunctionFC [AddItem2Array $FunctionFC $array_value ]      

      set valueFC0 [expr 2.0*$array_value/3.0]
      set valueFC0 [format %10.5g $valueFC0]
	  set FunctionFC0 [AddItem2Array $FunctionFC0 $array_time]
	  set FunctionFC0 [AddItem2Array $FunctionFC0 $valueFC0 ]

      set valueFT [expr 0.3*pow($array_value_possitive,[expr 2.0/3.0])]

      #* if tensile strength (f_t) is greater or equal than -0.95*f_c0, calculate f_t=-0.95*f_c0
      set valueFT2 [expr -0.95*$valueFC0]
      if { $valueFT > $valueFT2 } {
        set valueFT  [expr 1.0*$valueFT2]
      }
      set valueFT [format %10.5g $valueFT] 
      set FunctionFT [AddItem2Array $FunctionFT $array_time]
	  set FunctionFT [AddItem2Array $FunctionFT $valueFT ]       

      set valueGF [expr 73.0*[tcl::mathfunc::pow $array_value_possitive 0.18]/1000000]
      set valueGF [format %10.5g $valueGF]
	  set FunctionGF [AddItem2Array $FunctionGF $array_time]
	  set FunctionGF [AddItem2Array $FunctionGF $valueGF ]
       

      
      set valueEPS [expr 1.0*$array_value/$fc_generate_e28_Value]
      set valueEPS [format %10.5g $valueEPS]
	  set FunctionEPS [AddItem2Array $FunctionEPS $array_time]
	  set FunctionEPS [AddItem2Array $FunctionEPS $valueEPS ]      
      
      
      
	  }

  set on [DWLocalSetValue $GDN $STRUCT Function_for_E_ $FunctionE]
    WarnWinText "Function_for_E_ generated"
    WarnWinText "$FunctionE"
    
  set on [DWLocalSetValue $GDN $STRUCT Function_for_FC $FunctionFC]
    WarnWinText "Function_for_FC generated"
    WarnWinText "$FunctionFC"
    
  set on [DWLocalSetValue $GDN $STRUCT Function_for_FT $FunctionFT]
    WarnWinText "Function_for_FT generated"
    WarnWinText "$FunctionFT"

  set on [DWLocalSetValue $GDN $STRUCT Function_for_GF $FunctionGF]
    WarnWinText "Function_for_GF generated"
    WarnWinText "$FunctionGF"        
  
  set on [DWLocalSetValue $GDN $STRUCT Function_for_Fc0 $FunctionFC0]
    WarnWinText "Function_for_Fc0 generated"
    WarnWinText "$FunctionFC0"
  
  set on [DWLocalSetValue $GDN $STRUCT Activate_Function_for_EPS_CP 1]
  set on [DWLocalSetValue $GDN $STRUCT Function_for_EPS_CP $FunctionEPS]
    WarnWinText "Function_for_EPS_CP generated"
    WarnWinText "$FunctionEPS"  
  
  set on [DWLocalSetValue $GDN $STRUCT Activate_Function_for_Wd 0]     
  set on [DWLocalSetValue $GDN $STRUCT Critical_Comp_Disp-WD -0.0005m] 
    WarnWinText "Critical_Comp_Disp-WD = -0.0005m"
		      
  set on [DWLocalSetValue $GDN $STRUCT Activate_Aggregate_Interlock 1]
  set on [DWLocalSetValue $GDN $STRUCT Agg_Size 0.001m]
    WarnWinText "Agg_Size = 0.001m"    
  set on [DWLocalSetValue $GDN $STRUCT Excentricity-EXC 0.52] 
    WarnWinText "Excentricity-EXC = 0.52"
  set on [DWLocalSetValue $GDN $STRUCT Dir_of_pl_Flow-BETA 0.0] 
    WarnWinText "Dir_of_pl_Flow-BETA = 0.0"
  set on [DWLocalSetValue $GDN $STRUCT Poisson_s_Ratio 0.2] 
    WarnWinText "Poisson_s_Ratio = 0.2"    
  set on [DWLocalSetValue $GDN $STRUCT Rho-Density 0.0023kton/m^3] 
    WarnWinText "Rho-Density = 0.0023kton/m^3"
  set on [DWLocalSetValue $GDN $STRUCT Thermal_Expansion-Alpha 0.000012C^-1] 
    WarnWinText "Thermal_Expansion-Alpha = 0.000012"
  set on [DWLocalSetValue $GDN $STRUCT Fixed_Crack 1] 
    WarnWinText "Fixed_Crack = 1"
  
  WarnWinText "Parameters of concerete were updated"
  WarnWinText "------------------------------------"
      set on [DWLocalSetValue $GDN $STRUCT 3D_print_fc_generate_Generate_Material No]
      
      set fc_generate_fc28_last [format %g%s $fc_generate_fc28_Value "MPa"]
      set on [DWLocalSetValue $GDN $STRUCT fc_generate_Last_Generation_was_fc28_Value_ $fc_generate_fc28_last]
      #set on [DWLocalSetValue $GDN $STRUCT fc_generate_Last_Generation_was_Strength_Value_Function $value]
      

  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}


proc ZJ_Interpolate { findX arrayX arrayY } {

  if { $findX <= [lindex $arrayX 0] } {
          return [lindex $arrayY 0]   
     }
  if { $findX >= [lindex $arrayX [llength $arrayX]-1] } {
          return [lindex $arrayY [llength $arrayY]-1]
     }   
  for { set i 0}  {$i < [llength $arrayX]-1} {incr i} {
     if { [lindex $arrayX $i] < $findX && $findX <= [lindex $arrayX $i+1] } {
          set x_min [lindex $arrayX $i]
          set x_max [lindex $arrayX $i+1]
          set y_min [lindex $arrayY $i]
          set y_max [lindex $arrayY $i+1]
          #WarnWinText "findX: $findX"
          #WarnWinText "x_min: $x_min" 
          #WarnWinText "x_max: $x_max" 
          #WarnWinText "y_min: $y_min" 
          #WarnWinText "y_max: $y_max"          
          set x_rel [expr ($findX - $x_min) / ($x_max - $x_min) ] 
          #WarnWinText "x_rel: $x_rel"  
          set y_rel [expr ($y_max - $y_min) * $x_rel ] 
          set y [expr $y_rel + $y_min ]
          set y [expr double(round(1000000000000.0*$y))/1000000000000.0]
          return $y
     }
  }
  return "unknown"
}


proc ZJ_Interpolate_gid_row { findX arrayXY } {

  set velikostPole [lindex $arrayXY 1]
  #WarnWinText "velikostPole: $velikostPole"

	for {set i 2 } { $i <= $velikostPole } { set i [expr $i + 2] } {
	  lappend arrayX [lindex $arrayXY $i]
	  lappend arrayY [lindex $arrayXY [expr $i+1]]
      } 
      
      #WarnWinText "arrayX: $arrayX"
      #WarnWinText "arrayY: $arrayY"
      
   set y [ZJ_Interpolate  $findX $arrayX $arrayY ]  
   set y [expr double(round(1000000000000.0*$y))/1000000000000.0] 
   return $y
}


proc TK_GenerateVariable_3D_print_DoH-based { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
   
    # set oBaseMaterial [GiD_AccessValue get materials $QUESTION]
  	set BaseMaterial [DWLocalGetValue $GDN $STRUCT $QUESTION]
  	set Generate [DWLocalGetValue $GDN $STRUCT 3D_print_DoH-based_Generate_Material]
 if { $Generate == "No" } {
 } else {
 
   set FunctionE "#N# 0"
  set FunctionFC "#N# 0"
  set FunctionFT "#N# 0"
  set FunctionGF "#N# 0"
  set FunctionFC0 "#N# 0"
  set FunctionEPS "#N# 0"
 
    set fc_given [DWLocalGetValue $GDN $STRUCT DoH-based_fc28_given]
    set n1 [GidConvertValueUnit $fc_given]
    set n1 [ParserNumberUnit $n1 fc_given fc_given_valueUnit]
    if { $fc_given >0 } {
      set fc_given [expr -1.0 * $fc_given]
    } 
            
    #set time_fc_given [DWLocalGetValue $GDN $STRUCT DoH-based_time_fc_given]
    #set n1 [GidConvertValueUnit $time_fc_given]
    #set n1 [ParserNumberUnit $n1 time_fc_given time_fc_given_ValueUnit]
    
    set Relative_Strength_Function [DWLocalGetValue $GDN $STRUCT  DoH-based_Relative_Strength_Function]
    set on [lindex $Relative_Strength_Function 1]
	for {set i 2 } { $i <= $on } { set i [expr $i + 2] } {
	  set array_x [lindex $Relative_Strength_Function $i]
	  set array_y [lindex $Relative_Strength_Function [expr $i+1]]
      lappend DoH4fc_fnc $array_x
      lappend fc_rel_fnc $array_y
     }
     #WarnWinText "DoH4fc_fnc: $DoH4fc_fnc"
     #WarnWinText "fc_rel_fnc: $fc_rel_fnc"
    
    set Temperature_Adjusment [DWLocalGetValue $GDN $STRUCT  DoH-based_Temperature_Adjusment]
    set reference_temperature [DWLocalGetValue $GDN $STRUCT  DoH-based_reference_temperature]
        set n1 [GidConvertValueUnit $reference_temperature]
        set n1 [ParserNumberUnit $n1 reference_temperature reference_temperatureUnit]    
    set temperature_during_printing [DWLocalGetValue $GDN $STRUCT  DoH-based_temperature_during_printing]
        set n1 [GidConvertValueUnit $temperature_during_printing]
        set n1 [ParserNumberUnit $n1 temperature_during_printing temperature_during_printingUnit]    
    set activation_energy [DWLocalGetValue $GDN $STRUCT  DoH-based_activation_energy]
        set n1 [GidConvertValueUnit $activation_energy]
        set n1 [ParserNumberUnit $n1 activation_energy activation_energyUnit]    
    
    set Is_analyticalDoH [DWLocalGetValue $GDN $STRUCT  DoH-based_Is_analyticalDoH]
    set time4DoH_fnc [DWLocalGetValue $GDN $STRUCT  DoH-based_time4DoH_fnc]
    set based_B1 [DWLocalGetValue $GDN $STRUCT  DoH-based_B1]
        set n1 [GidConvertValueUnit $based_B1]
        set n1 [ParserNumberUnit $n1 based_B1 based_B1Unit]    
    set based_B2 [DWLocalGetValue $GDN $STRUCT  DoH-based_B2 ]
    set based_ETA [DWLocalGetValue $GDN $STRUCT  DoH-based_ETA ]
    set based_alpha_inf [DWLocalGetValue $GDN $STRUCT  DoH-based_alpha_inf ]
    
    set r_universal_gas_const 8.31446261815324      
    set time_step  60                        
    set step_increment_factor 0.005
    

    set target_times_list [list 0 1800 3600 5400 7200 9000 10800 12600 14400 16200 18000 19800 21600 23400 25200 27000 28800 30600 32400 34200 36000 37800 39600 41400 43200 46800 50400 54000 57600 61200 64800 68400 72000 75600 79200 82800 86400 100800 115200 129600 144000 158400 172800 194400 216000 237600 259200 302400 345600 388800 432000 475200 518400 561600 604800 734400 864000 993600 1123200 1252800 1382400 1512000 1641600 1771200 1900800 2030400 2160000 2289600 2419200]
    #set target_times_list [list 0 1800 3600 5400 7200 9000]
    #set dt_explicit [list]
    
for { set i 0}  {$i < [llength $target_times_list]-1} {incr i} {
    set delta_a [lindex $target_times_list $i+1]
    set delta_b [lindex $target_times_list $i]
    set delta [expr $delta_a - $delta_b]
    #WarnWinText $delta_a
    #WarnWinText $delta_b
    #WarnWinText $delta
    lappend dt_explicit $delta
}
    #WarnWinText $dt_explicit

# VARIABLE INITIALISATION
    set alpha_now 0 
    set time_now 0
    set dt 0
    set dalpha 0 
    set beta 1   
    set fc_rel_28 0
    set fc_rel 0
    set fc 0
    set fc0 0
    set E 0
    set ft 0
    set eps_cp 0
    set Gf 0
    set w_d 0.0
    set time_max 2419200
    set i 0
    set time_28day 2419200  
    
# OUTPUT LIST INITIALISATION
#time_list=[]        #[s]
#alpha_list=[]       #DoH [-]
#fc_list=[]          #compressive strength [MPa]
#E_list=[]           #Young's modulus [MPa]
#ft_list=[]          #tensile strength [MPa]
#Gf_list=[]          #fracture energy [MN/m]
#w_d_list=[]         #critical compressive displacement [m]
#fc0_list=[]         #onset of crushing [MPa]
#eps_cp_list=[]      #strain at compession peak [-]    
 
 
  
 
 
# CALCULATION BASED ON THE AFFINITY HYDRATION MODEL
if {$Is_analyticalDoH == 0 } {


#STORE VALUES AT ZERO TIME
    #time_list.append(time_now)
    lappend time_list $time_now 
    # alpha_list.append(alpha_now)
    lappend alpha_list $alpha_now   
    
  
for { set i 0}  {$i < [llength $target_times_list]-1} {incr i} {
   if {$time_now < 43200 } {
       set dt 1800
   } elseif {$time_now < 86400 } {       
     #   elif time_now<24*3600:
       set dt 3600
   } elseif {$time_now < 172800 } {
     #   elif time_now<48*3600:
       set dt 14400
   } elseif {$time_now < 259200 } {
      #  elif time_now<72*3600:
       set dt 21600
   } elseif {$time_now < 604800 } {
      #  elif time_now<168*3600:
       set dt 43200
   } else  {
       set dt 129600   
   }
    #WarnWinText "--------------"
    #WarnWinText "time_now: $time_now"

    
        
        #dalpha=B1*(B2/alpha_inf+alpha_now) * (alpha_inf-alpha_now)*math.exp((-ETA*alpha_now/alpha_inf))
        #WarnWinText "b1: $based_B1, b2: $based_B2, based_alpha_inf: $based_alpha_inf, alpha_now: $alpha_now, based_ETA: $based_ETA"
    set dalpha1 [expr $based_B2 / $based_alpha_inf + $alpha_now ]
    set dalpha2 [expr $based_alpha_inf - $alpha_now ]
    set dalpha3 [expr exp(-1.0 * $based_ETA * $alpha_now /$based_alpha_inf) ]  
    set dalpha [expr $based_B1 * $dalpha1 * $dalpha2 * $dalpha3 ]
    #WarnWinText "dalpha1: $dalpha1"
    #WarnWinText "dalpha2: $dalpha2"
    #WarnWinText "dalpha3: $dalpha3"
    #WarnWinText "dalpha: $dalpha"
        #beta=math.exp(   EA / R * (    1 / (273.15+T_ref) -  1 /  (273.15+T_print)  )    )
    if {$Temperature_Adjusment == 0} {
        set beta 1
        #WarnWinText "beta: $beta"
    } else {
        set beta [expr exp( $activation_energy *1000000 / $r_universal_gas_const * [expr [expr (1.0 / (273.15 + $reference_temperature ))] - [expr (1.0 / (273.15 + $temperature_during_printing ) )] ]  )]
        #WarnWinText "activation_energy: $activation_energy"
        #WarnWinText "r_universal_gas_const: $r_universal_gas_const"
        #WarnWinText "reference_temperature: $reference_temperature"
        #WarnWinText "temperature_during_printing: $temperature_during_printing"
        #WarnWinText "beta: $beta"    
    }
        #dalpha=dalpha*beta
    set dalpha [expr $dalpha * $beta]
    #WarnWinText "dalpha: $dalpha"    
        #alpha_now=alpha_now+dt*dalpha
    set alpha_now [expr $alpha_now + $dt*$dalpha]
    #WarnWinText "alpha_now: $alpha_now"
    
    # UPDATE TIME
        #time_now=time_now+dt
    set time_now [expr $time_now + $dt]
            

    
    # STORE THE RESULTS
        #time_list.append(time_now)
    lappend time_list $time_now
        #alpha_list.append(alpha_now)
    lappend alpha_list $alpha_now 


} 

#   set arrX {0.1 0.3 0.4 0.8  1.0}
#   set arrY {1.0 2.1 2.2 4.11 4.12}
#   foreach x {0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0} {
#      WarnWinText "$x: [ZJ_Interpolate $x $arrX  $arrY ]"
#   }      
 
 #WarnWinText "--------------------------------------------"
   set alpha_list_minus_one [lindex $alpha_list [llength $alpha_list]-1]
#    fc_28_rel=np.interp(alpha_list[-1], DoH4fc_fnc, fc_rel_fnc)
   set fc_28_rel [ZJ_Interpolate $alpha_list_minus_one $DoH4fc_fnc  $fc_rel_fnc ]
   #WarnWinText "alpha_list_minus_one: $alpha_list_minus_one"
   #WarnWinText "DoH4fc_fnc: $DoH4fc_fnc"
   #WarnWinText "fc_rel_fnc: $fc_rel_fnc"
   #WarnWinText "fc_28_rel: $fc_28_rel"
#    fc_28=fc_28_rel*fc_28/fc_given_rel
   set fc_28 [expr $fc_28_rel * $fc_given / $fc_28_rel ]
   #WarnWinText "fc_28: $fc_28"  

  set fc_generate_e28_ValuePred [expr (6000 + (15.5 * $fc_28))] 
  set fc_generate_e28_ValueOdm [expr pow([expr -1.0 * $fc_28],[expr 1.0/2.0])]
  set fc_generate_e28_Value [expr $fc_generate_e28_ValuePred * $fc_generate_e28_ValueOdm]

        
#    for i in range(len(alpha_list)):
   for { set i 0}  {$i <= [llength $alpha_list]-1} {incr i} {
   #WarnWinText "--------------------"
        # CALCULATE EACH MATERIAL MODEL PARAMETER
#        fc_rel=np.interp(alpha_list[i], DoH4fc_fnc, fc_rel_fnc)
         set time_now [lindex $time_list $i]
         set alpha_list_i [lindex $alpha_list $i]
         set fc_rel [ZJ_Interpolate $alpha_list_i $DoH4fc_fnc  $fc_rel_fnc ]
         #WarnWinText "time_now: $time_now"
         #WarnWinText "alpha_list_i: $alpha_list_i"
         #WarnWinText "fc_rel: $fc_rel"
         #WarnWinText "fc_given: $fc_given" 
         #W#arnWinText "fc_28_rel: $fc_28_rel"          
#        fc=fc_rel*fc_28/fc_28_rel
         set fc [expr $fc_rel * $fc_given / $fc_28_rel]
         #WarnWinText "fc: $fc"
#        [E, ft, Gf, w_d, fc0, eps_cp] = CalculateParameters(fc, fc_28)
         set fc_positive [expr -1.0 * $fc]
         set fc_28_negative $fc_28
         
          #WarnWinText "fc_positive: $fc_positive"
          #WarnWinText "fc_28_negative: $fc_28_negative"
          set valueEpred [expr (6000 + (15.5 * $fc_28_negative))]
          #set valueOdmE [expr ($fc)^(0.5)]
          set valueOdmE [expr 1.0*pow($fc_positive,[expr 1.0/2.0])] 
          set valueE [expr $valueEpred * $valueOdmE]
          set valueE [format %10.5g $valueE]
    	  set FunctionE [AddItem2Array $FunctionE $time_now]
    	  set FunctionE [AddItem2Array $FunctionE $valueE ]
    
          #WarnWinText "FunctionE: $valueEpred * $valueOdmE = $valueE"
    
          set fc [format %10.5g $fc]
    	  set FunctionFC [AddItem2Array $FunctionFC $time_now]
    	  set FunctionFC [AddItem2Array $FunctionFC $fc ]      
    
          set valueFC0 [expr 2.0*$fc/3.0]
          set valueFC0 [format %10.5g $valueFC0]
    	  set FunctionFC0 [AddItem2Array $FunctionFC0 $time_now]
    	  set FunctionFC0 [AddItem2Array $FunctionFC0 $valueFC0 ]
    
          set valueFT [expr 0.3*pow($fc_positive,[expr 2.0/3.0])]
    
          #* if tensile strength (f_t) is greater or equal than -0.95*f_c0, calculate f_t=-0.95*f_c0
          set valueFT2 [expr -0.95*$valueFC0]
          if { $valueFT > $valueFT2 } {
            set valueFT  [expr 1.0*$valueFT2]
          }
          set valueFT [format %10.5g $valueFT] 
          set FunctionFT [AddItem2Array $FunctionFT $time_now]
    	  set FunctionFT [AddItem2Array $FunctionFT $valueFT ]       
    
          set valueGF [expr 73.0*[tcl::mathfunc::pow $fc_positive 0.18]/1000000]
          set valueGF [format %10.5g $valueGF]
    	  set FunctionGF [AddItem2Array $FunctionGF $time_now]
    	  set FunctionGF [AddItem2Array $FunctionGF $valueGF ]
           
    
          
          set valueEPS [expr 1.0*$fc/$fc_generate_e28_Value]
          set valueEPS [format %10.5g $valueEPS]
    	  set FunctionEPS [AddItem2Array $FunctionEPS $time_now]
    	  set FunctionEPS [AddItem2Array $FunctionEPS $valueEPS ]      

         
        # STORE THE RESULTS
 #       fc_list.append(fc)
 #       E_list.append(E)
 #       ft_list.append(ft)
 ##       Gf_list.append(Gf)
 #       w_d_list.append(w_d)
 #       fc0_list.append(fc0)
 #       eps_cp_list.append(eps_cp)
       }
 } else {
 #GENERATION BASED ON TABULATED DoH    
  
    #INITIALIZE LIST FOR TEMPERATURE-ADJUSTED DoH FUNCTION
    #DoH_TempAdjust_fnc=[]
    #DoH_TempAdjust_fnc.append(DoH_fnc[0])
    
    #WarnWinText "time4DoH_fnc: $time4DoH_fnc"
    set value_zero [ZJ_Interpolate_gid_row 0 $time4DoH_fnc ]
    lappend time_list 0
    lappend time_list_puvodni 0
    lappend DoH_fnc $value_zero
    lappend DoH_TempAdjust_fnc $value_zero
    #WarnWinText "value_zero: $value_zero"
    
    # CALCULATE TEMPERATURE-ADJUSTED KINETICS
    #beta=math.exp(EA/R*(1/(273.15+T_ref)-1/(273.15+T_print)))
    if {$Temperature_Adjusment == 0} {
        set beta 1
        #WarnWinText "beta: $beta"
    } else {
        set beta [expr exp( $activation_energy * 1000000 / $r_universal_gas_const * [expr [expr (1.0 / (273.15 + $reference_temperature ))] - [expr (1.0 / (273.15 + $temperature_during_printing ) )] ]  )]
        #WarnWinText "activation_energy: $activation_energy"
        #WarnWinText "r_universal_gas_const: $r_universal_gas_const"
        #WarnWinText "reference_temperature: $reference_temperature"
        #WarnWinText "temperature_during_printing: $temperature_during_printing"
        #WarnWinText "beta: $beta"     
    }
    
        
   #for i in range(len(DoH_fnc)-1):
    #    slope=(DoH_fnc[i+1]-DoH_fnc[i])/(time4DoH_fnc[i+1]-time4DoH_fnc[i])
    #    slope=slope*beta
    #    time4DoH_adjusted_fnc.append(time4DoH_adjusted_fnc[i]+(DoH_fnc[i+1]-DoH_fnc[i])/slope) 
                                              
       
      
      
    set velikostPole [lindex $time4DoH_fnc 1]    
    for {set i 2 } { $i <= $velikostPole -2 } { set i [expr $i + 2] } {
       #WarnWinText "-------------------i: $i"
       set xi  [lindex $time4DoH_fnc $i]
       set xii  [lindex $time4DoH_fnc $i+2]
       
       set yi [ZJ_Interpolate_gid_row $xi $time4DoH_fnc ]
       set yii [ZJ_Interpolate_gid_row $xii $time4DoH_fnc ] 
       
       #WarnWinText "xi: $xi"
       #WarnWinText "xii: $xii"
       #WarnWinText "yi: $yi"
       #WarnWinText "yii: $yii"
       set slope [expr ($yii-$yi) / ($xii - $xi)]
       #WarnWinText "slope: $slope"
       set slope [expr $slope * $beta]
       #WarnWinText "slope: $slope"
       #time4DoH_adjusted_fnc.append(time4DoH_adjusted_fnc[i]+(DoH_fnc[i+1]-DoH_fnc[i])/slope)
       set value [expr $value_zero + ($yii - $yi)/$slope ]
       #WarnWinText "value: $value"
       set value_zero $value
       lappend time_list $value
       lappend time_list_puvodni $xii
       lappend DoH_fnc $yii
    }    
      #WarnWinText "time_list: $time_list"
      #WarnWinText "DoH_fnc: $DoH_fnc"
     # DoH_TempAdjust_fnc=[]
     # for i in range(len(time4DoH_fnc)):
      # DoH_TempAdjust_fnc.append(np.interp(time4DoH_fnc[i], time4DoH_adjusted_fnc, DoH_fnc))    
    

    for {set i 1 } { $i <= [llength $time_list_puvodni] -1 } { set i [expr $i + 1] } {
       #WarnWinText "-------------------i: $i"
       set xi  [lindex $time_list_puvodni $i]
       #WarnWinText "xi: $xi"
       
       set value [ZJ_Interpolate $xi $time_list $DoH_fnc ]
       #WarnWinText "value: $value"
       lappend DoH_TempAdjust_fnc $value
       #WarnWinText "DoH_TempAdjust_fnc: $DoH_TempAdjust_fnc"
    } 

    #fc_28_rel=np.interp(DoH_TempAdjust_fnc[ -1], DoH4fc_fnc, fc_rel_fnc)
    #fc_28=fc_28_rel*fc_28/fc_given_rel    
    # CALCULATE MATERIAL PARAMETERS FOR EACH INPUTTED DoH
    #for i in range(len(time4DoH_fnc)):
    #    # RELATE HYDRATION CURVE AND RELATIVE COMPRESSIVE STRENGTH
    #    fc_rel=np.interp(DoH_TempAdjust_fnc[i], DoH4fc_fnc, fc_rel_fnc)
    #    # CALCULATE EACH MATERIAL MODEL PARAMETER
    #    fc=fc_rel*fc_28/fc_given_rel
    #    [E, ft, Gf, w_d, fc0, eps_cp] = CalculateParameters(fc, fc_28)           
    #    # STORE THE RESUTLS
    #    time_list.append(time4DoH_fnc[i])
    #    alpha_list.append(DoH_TempAdjust_fnc[i])
    #    fc_list.append(fc)
    #    E_list.append(E)
    #    ft_list.append(ft)
    #    Gf_list.append(Gf)
    #    w_d_list.append(w_d)
    #    fc0_list.append(fc0)
    #    eps_cp_list.append(eps_cp)
        
        
 #WarnWinText "--------------------------------------------"
   set alpha_list_minus_one [lindex $DoH_TempAdjust_fnc [llength $DoH_TempAdjust_fnc]-1]
#    fc_28_rel=np.interp(alpha_list[-1], DoH4fc_fnc, fc_rel_fnc)
   set fc_28_rel [ZJ_Interpolate $alpha_list_minus_one $DoH4fc_fnc  $fc_rel_fnc ]
   #WarnWinText "alpha_list_minus_one: $alpha_list_minus_one"
   #WarnWinText "DoH4fc_fnc: $DoH4fc_fnc"
   #WarnWinText "fc_rel_fnc: $fc_rel_fnc"
   #WarnWinText "fc_28_rel: $fc_28_rel"
#    fc_28=fc_28_rel*fc_28/fc_given_rel
   set fc_28 [expr $fc_28_rel * $fc_given / $fc_28_rel ]
   #WarnWinText "fc_28: $fc_28"  

  set fc_generate_e28_ValuePred [expr (6000 + (15.5 * $fc_28))] 
  set fc_generate_e28_ValueOdm [expr pow([expr -1.0 * $fc_28],[expr 1.0/2.0])]
  set fc_generate_e28_Value [expr $fc_generate_e28_ValuePred * $fc_generate_e28_ValueOdm]

        
#    for i in range(len(alpha_list)):
   for { set i 0}  {$i <= [llength $DoH_TempAdjust_fnc]-1} {incr i} {
   #WarnWinText "--------------------"
        # CALCULATE EACH MATERIAL MODEL PARAMETER
#        fc_rel=np.interp(alpha_list[i], DoH4fc_fnc, fc_rel_fnc)
         set time_now [lindex $time_list_puvodni $i]
         set alpha_list_i [lindex $DoH_TempAdjust_fnc $i]
         set fc_rel [ZJ_Interpolate $alpha_list_i $DoH4fc_fnc  $fc_rel_fnc ]
         #WarnWinText "time_now: $time_now"
         #WarnWinText "alpha_list_i: $alpha_list_i"
         #WarnWinText "fc_rel: $fc_rel"
         #WarnWinText "fc_given: $fc_given" 
         #W#arnWinText "fc_28_rel: $fc_28_rel"          
#        fc=fc_rel*fc_28/fc_28_rel
         set fc [expr $fc_rel * $fc_given / $fc_28_rel]
         #WarnWinText "fc: $fc"
#        [E, ft, Gf, w_d, fc0, eps_cp] = CalculateParameters(fc, fc_28)
         set fc_positive [expr -1.0 * $fc]
         set fc_28_negative $fc_28
         
          #WarnWinText "fc_positive: $fc_positive"
          #WarnWinText "fc_28_negative: $fc_28_negative"
          set valueEpred [expr (6000 + (15.5 * $fc_28_negative))]
          #set valueOdmE [expr ($fc)^(0.5)]
          set valueOdmE [expr 1.0*pow($fc_positive,[expr 1.0/2.0])] 
          set valueE [expr $valueEpred * $valueOdmE]
          set valueE [format %10.5g $valueE]
    	  set FunctionE [AddItem2Array $FunctionE $time_now]
    	  set FunctionE [AddItem2Array $FunctionE $valueE ]
    
          #WarnWinText "FunctionE: $valueEpred * $valueOdmE = $valueE"
    
          set fc [format %10.5g $fc]
    	  set FunctionFC [AddItem2Array $FunctionFC $time_now]
    	  set FunctionFC [AddItem2Array $FunctionFC $fc ]      
    
          set valueFC0 [expr 2.0*$fc/3.0]
          set valueFC0 [format %10.5g $valueFC0]
    	  set FunctionFC0 [AddItem2Array $FunctionFC0 $time_now]
    	  set FunctionFC0 [AddItem2Array $FunctionFC0 $valueFC0 ]
    
          set valueFT [expr 0.3*pow($fc_positive,[expr 2.0/3.0])]
    
          #* if tensile strength (f_t) is greater or equal than -0.95*f_c0, calculate f_t=-0.95*f_c0
          set valueFT2 [expr -0.95*$valueFC0]
          if { $valueFT > $valueFT2 } {
            set valueFT  [expr 1.0*$valueFT2]
          }
          set valueFT [format %10.5g $valueFT] 
          set FunctionFT [AddItem2Array $FunctionFT $time_now]
    	  set FunctionFT [AddItem2Array $FunctionFT $valueFT ]       
    
          set valueGF [expr 73.0*[tcl::mathfunc::pow $fc_positive 0.18]/1000000]
          set valueGF [format %10.5g $valueGF]
    	  set FunctionGF [AddItem2Array $FunctionGF $time_now]
    	  set FunctionGF [AddItem2Array $FunctionGF $valueGF ]
           
    
          
          set valueEPS [expr 1.0*$fc/$fc_generate_e28_Value]
          set valueEPS [format %10.5g $valueEPS]
    	  set FunctionEPS [AddItem2Array $FunctionEPS $time_now]
    	  set FunctionEPS [AddItem2Array $FunctionEPS $valueEPS ]      
        }   

}        
         
# WarnWinText $BaseMaterial  	
 WarnWinText "Material parameters DoH-based:"

  set on [DWLocalSetValue $GDN $STRUCT Function_for_E_ $FunctionE]
    WarnWinText "Function_for_E_ generated"
    
  set on [DWLocalSetValue $GDN $STRUCT Function_for_FC $FunctionFC]
    WarnWinText "Function_for_FC generated"
    
  set on [DWLocalSetValue $GDN $STRUCT Function_for_FT $FunctionFT]
    WarnWinText "Function_for_FT generated"

  set on [DWLocalSetValue $GDN $STRUCT Function_for_GF $FunctionGF]
    WarnWinText "Function_for_GF generated"        
  
  set on [DWLocalSetValue $GDN $STRUCT Function_for_Fc0 $FunctionFC0]
    WarnWinText "Function_for_Fc0 generated"
  
  set on [DWLocalSetValue $GDN $STRUCT Activate_Function_for_EPS_CP 1]
  set on [DWLocalSetValue $GDN $STRUCT Function_for_EPS_CP $FunctionEPS]
    WarnWinText "Function_for_EPS_CP generated"  
       
  set on [DWLocalSetValue $GDN $STRUCT Critical_Comp_Disp-WD -0.0005m] 
    WarnWinText "Critical_Comp_Disp-WD = -0.0005m"
		      
  set on [DWLocalSetValue $GDN $STRUCT Activate_Aggregate_Interlock 1]
  set on [DWLocalSetValue $GDN $STRUCT Agg_Size 0.001m]
    WarnWinText "Agg_Size = 0.001m"    
  set on [DWLocalSetValue $GDN $STRUCT Excentricity-EXC 0.52] 
    WarnWinText "Excentricity-EXC = 0.52"
  set on [DWLocalSetValue $GDN $STRUCT Dir_of_pl_Flow-BETA 0.0] 
    WarnWinText "Dir_of_pl_Flow-BETA = 0.0"
  set on [DWLocalSetValue $GDN $STRUCT Poisson_s_Ratio 0.2] 
    WarnWinText "Poisson_s_Ratio = 0.2"    
  set on [DWLocalSetValue $GDN $STRUCT Rho-Density 0.0023kton/m^3] 
    WarnWinText "Rho-Density = 0.0023kton/m^3"
  set on [DWLocalSetValue $GDN $STRUCT Thermal_Expansion-Alpha 0.000012C^-1] 
    WarnWinText "Thermal_Expansion-Alpha = 0.000012"
  set on [DWLocalSetValue $GDN $STRUCT Fixed_Crack 1] 
    WarnWinText "Fixed_Crack = 1"
  
  WarnWinText "Parameters of concerete were updated"
  WarnWinText "------------------------------------"
      set on [DWLocalSetValue $GDN $STRUCT 3D_print_DoH-based_Generate_Material No]

  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}
