

proc TK_GenerateTransportProperties { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]
   
    # set oBaseMaterial [GiD_AccessValue get materials $QUESTION]
    set Generate [DWLocalGetValue $GDN $STRUCT Generate_Material]
  	set Typeofmaterial [DWLocalGetValue $GDN $STRUCT Type_of_material]
   	set Typeofanalysis [DWLocalGetValue $GDN $STRUCT Type_of_analysis]
    set TypeofConductivity [DWLocalGetValue $GDN $STRUCT Type_of_conductivity]
    
    set Mean_Compressive_Strength [DWLocalGetValue $GDN $STRUCT Mean_Compressive_Strength]
    set n1 [GidConvertValueUnit $Mean_Compressive_Strength]
    set n1 [ParserNumberUnit $n1 Mean_Compressive_Strength Mean_Compressive_StrengthUnit]    
    
    set Starting_age [DWLocalGetValue $GDN $STRUCT Starting_age]
    set n1 [GidConvertValueUnit $Starting_age]
    set n1 [ParserNumberUnit $n1 Starting_age Starting_ageUnit] 
    set Starting_age [expr 1.0*$Starting_age/86400]
        
    set Cement_Type [DWLocalGetValue $GDN $STRUCT Cement_Type]
    set Mass_of_fibres [DWLocalGetValue $GDN $STRUCT Mass_of_fibres]
    set n1 [GidConvertValueUnit $Mass_of_fibres]
    set n1 [ParserNumberUnit $n1 Mass_of_fibres Mass_of_fibresUnit] 
    
    set Density_of_concrete_without_fibers [DWLocalGetValue $GDN $STRUCT Density_of_concrete_without_fibers]
    set n1 [GidConvertValueUnit $Density_of_concrete_without_fibers]
    set n1 [ParserNumberUnit $n1 Density_of_concrete_without_fibers Density_of_concrete_without_fibersUnit] 

    set Density_of_concrete [DWLocalGetValue $GDN $STRUCT Density_of_concrete]
    set n1 [GidConvertValueUnit $Density_of_concrete]
    set n1 [ParserNumberUnit $n1 Density_of_concrete Density_of_concreteUnit]     
        
    set WaterCement_Ratio [DWLocalGetValue $GDN $STRUCT Water/Cement_Ratio]
    set Mass_of_aggregate [DWLocalGetValue $GDN $STRUCT Mass_of_aggregate]
    set n1 [GidConvertValueUnit $Mass_of_aggregate]
    set n1 [ParserNumberUnit $n1 Mass_of_aggregate Mass_of_aggregateUnit]     

 if { $Generate == "No" } {
 } else {
 
  set on [DWLocalSetValue $GDN $STRUCT Activate_Concrete_Model_CERHYD 0]
  set on [DWLocalSetValue $GDN $STRUCT Activate_Temperature_Advanced 0] 
  set on [DWLocalSetValue $GDN $STRUCT Activate_Temperature_Variable_Values 0]
  set on [DWLocalSetValue $GDN $STRUCT K_TEMP_TEMP_FNC 0]
  set on [DWLocalSetValue $GDN $STRUCT Activate_K_TEMP_TEMP_FNC_TEMP 0]
  set on [DWLocalSetValue $GDN $STRUCT C_TEMP_TEMP_FNC 0]
  set on [DWLocalSetValue $GDN $STRUCT Activate_C_TEMP_TEMP_FNC_TEMP 0]  
  set on [DWLocalSetValue $GDN $STRUCT Activate_Moisture_Advanced 0] 
  set on [DWLocalSetValue $GDN $STRUCT Activate_Moisture_Variable_Values 0]
  set on [DWLocalSetValue $GDN $STRUCT C_H_H_FNC 0]
  set on [DWLocalSetValue $GDN $STRUCT Activate_C_H_H_FNC_H 0] 
  set on [DWLocalSetValue $GDN $STRUCT D_H_H_FNC 0]
  set on [DWLocalSetValue $GDN $STRUCT Activate_D_H_H_FNC_H 0]   

  if { $Typeofmaterial == "YOUNG_CONCRETE" || $Typeofmaterial == "HPFRC_YOUNG_CONCRETE"} {
          set on [DWLocalSetValue $GDN $STRUCT Activate_Concrete_Model_CERHYD 1] 
          WarnWinText "Concrete_Model_CERHYD enabled"
 
  }
  if { $Typeofmaterial == "CONCRETE" &&  ($Typeofanalysis == "TEMPERATURE" || $Typeofanalysis == "TEMPERATURE_AND_MOISTURE") } {
          set on [DWLocalSetValue $GDN $STRUCT K_TEMP_TEMP_NORMAL "2.1J/sec/C/m"] 
          WarnWinText "K_TEMP_TEMP_NORMAL = 2.1"
          set on [DWLocalSetValue $GDN $STRUCT C_TEMP_TEMP_NORMAL "2.55e+006J/m^3/C"] 
          WarnWinText "C_TEMP_TEMP_NORMAL = 2.55e+006"
          
 } 
 if { ($Typeofmaterial == "CONCRETE" ||  $Typeofmaterial == "HPFRC_CONCRETE" ) &&  ($Typeofanalysis == "MOISTURE" || $Typeofanalysis == "TEMPERATURE_AND_MOISTURE") } {

             if { $Cement_Type == "Type_I"} {
                set nct 1.1
                set vct 0.9
             } elseif { $Cement_Type == "Type_II"} {
                set nct 1.0
                set vct 1.0             
             } elseif { $Cement_Type == "Type_III"} {
                set nct 1.15
                set vct 0.85
             } elseif { $Cement_Type == "Type_IV"} {
                set nct 1.5
                set vct 0.6             
             }
             
             if { $WaterCement_Ratio < 0.3 } {
                set WaterCement_Ratio 0.3
                WarnWinText "WaterCement_Ratio is too low..  new value WaterCement_Ratio = $WaterCement_Ratio"
             }
             if { $WaterCement_Ratio > 0.7 } {
                set WaterCement_Ratio 0.7
                WarnWinText "WaterCement_Ratio is too high..  new value WaterCement_Ratio = $WaterCement_Ratio"
             }      
             
             if {$Typeofmaterial == "CONCRETE"} {
               set density $Density_of_concrete
               set massfibres 0
             }       
             if {$Typeofmaterial == "HPFRC_CONCRETE"} {
               set density [expr $Mass_of_fibres + (1.0 - ($Mass_of_fibres/0.007850) ) * $Density_of_concrete_without_fibers ]
               set massfibres [expr $Mass_of_fibres * 1.0]
             }
             
             #WarnWinText "Density_of_concrete_without_fibers = $Density_of_concrete_without_fibers"
             #WarnWinText "Mass_of_aggregate = $Mass_of_aggregate"   
             #WarnWinText "density = $density"     
             #WarnWinText "Mass_of_fibres = $Mass_of_fibres"
             #WarnWinText "massfibres = $massfibres"       
             
             set Starting_age 28
             #WarnWinText "Starting_age = $Starting_age"
             set v_m [expr (0.068 -(0.22 / $Starting_age) ) * (0.85 + (0.45*$WaterCement_Ratio) )*$vct]
             #WarnWinText "v_m = $v_m"
             set c 18.47827282
             set n [expr (2.5+(15.0/$Starting_age))*(0.33+(2.2*$WaterCement_Ratio))*$nct]
             #WarnWinText "n = $n"
             set k [expr ((1-1/$n)*$c-1)/($c-1)]
             #WarnWinText "k = $k"
             set chh_normal_0 [expr $c*$v_m*(($c-1)*pow($k,3)+$k)/ (pow(1-$k,2)*pow(($c-1)*$k+1,2))*(1-($Mass_of_aggregate+$massfibres)/$density)]
             set unit "kg/m^3"
             set chh_normal [expr $chh_normal_0 * $density * 1000000.0]
             set chh_normal_unit [expr {double(round(1000*$chh_normal))/1000}]$unit
             
             
             set on [DWLocalSetValue $GDN $STRUCT C_H_H_NORMAL $chh_normal_unit]
             WarnWinText "chh_normal = $chh_normal_unit"

            set on [DWLocalSetValue $GDN $STRUCT Activate_Moisture_Advanced 1] 
            set on [DWLocalSetValue $GDN $STRUCT Activate_Moisture_Variable_Values 1]
            set on [DWLocalSetValue $GDN $STRUCT C_H_H_FNC 1]
            set on [DWLocalSetValue $GDN $STRUCT Activate_C_H_H_FNC_H 1]
 
            set Function "#N# 22 "
            for {set i 0} {$i < 11} {incr i} {
                set j [expr $i*0.1]
                set j [expr {double(round(10*$j))/10}]
                
                set chh_normal_0 [expr $c*$v_m*(($c-1)*pow($k,3)*pow($j,2)+$k)/ (pow(1-($k*$j),2)*pow(($c-1)*$k*$j+1,2))*(1-($Mass_of_aggregate+$massfibres)/$density)]
                set chh_normal_0 [expr $chh_normal_0 * $density * 1000000.0 / $chh_normal ]
                set chh_normal_0 [expr {double(round(10000*$chh_normal_0))/10000}]             
                #WarnWinText "$j  -> $chh_normal_0"
                append  Function " " $j " " $chh_normal_0
            }
            WarnWinText "Function Function_for_C_H_H_FNC_H generated ($Function)"
            #set Function "#N# 14 0.0 1.0 200.0 0.817 400 0.667 600 0.551 800 0.468 1000 0.419 1200 0.404"
            set on [DWLocalSetValue $GDN $STRUCT Function_for_C_H_H_FNC_H $Function]

            #WarnWinText "Mean_Compressive_Strength = $Mean_Compressive_Strength"

            set dio [expr 1.0*pow(10,-8)]
            set d1 [expr $dio / ($Mean_Compressive_Strength - 8) ]
            #WarnWinText "d1 = $d1"
            set dhh_normal [expr $d1 * $chh_normal]
            #set dhh_normal [expr {double(round(10000*$dhh_normal))/10000}]
            WarnWinText "dhh_normal = $dhh_normal"
            set dhh_normal_unit [expr $dhh_normal]kg/sec/m
            set on [DWLocalSetValue $GDN $STRUCT D_H_H_NORMAL $dhh_normal_unit]
            
            set on [DWLocalSetValue $GDN $STRUCT D_H_H_FNC 1]
            set on [DWLocalSetValue $GDN $STRUCT Activate_D_H_H_FNC_H 1]
                        
            set alph 0.05
            set hc 0.8
            set n 15
            
            set Function "#N# 16 "
            set prvni 0
            set druhy [expr $alph + (1-$alph) / (1+pow((1-$prvni)/(1-$hc),$n))]
            set druhy [expr {double(round(10000*$druhy))/10000}]
            append  Function " " $prvni " " $druhy
            set prvni 0.7
            set druhy [expr $alph + (1-$alph) / (1+pow((1-$prvni)/(1-$hc),$n))]
            set druhy [expr {double(round(10000*$druhy))/10000}]
            append  Function " " $prvni " " $druhy
            set prvni 0.75
            set druhy [expr $alph + (1-$alph) / (1+pow((1-$prvni)/(1-$hc),$n))]
            set druhy [expr {double(round(10000*$druhy))/10000}]
            append  Function " " $prvni " " $druhy
            set prvni 0.77
            set druhy [expr $alph + (1-$alph) / (1+pow((1-$prvni)/(1-$hc),$n))]
            set druhy [expr {double(round(10000*$druhy))/10000}]
            append  Function " " $prvni " " $druhy                                    
            set prvni 0.83
            set druhy [expr $alph + (1-$alph) / (1+pow((1-$prvni)/(1-$hc),$n))]
            set druhy [expr {double(round(10000*$druhy))/10000}]
            append  Function " " $prvni " " $druhy                                    
            set prvni 0.85
            set druhy [expr $alph + (1-$alph) / (1+pow((1-$prvni)/(1-$hc),$n))]
            set druhy [expr {double(round(10000*$druhy))/10000}]
            append  Function " " $prvni " " $druhy                                    
            set prvni 0.9
            set druhy [expr $alph + (1-$alph) / (1+pow((1-$prvni)/(1-$hc),$n))]
            set druhy [expr {double(round(10000*$druhy))/10000}]
            append  Function " " $prvni " " $druhy                                    
            set prvni 1.0
            set druhy [expr $alph + (1-$alph) / (1+pow((1-$prvni)/(1-$hc),$n))]
            set druhy [expr {double(round(10000*$druhy))/10000}]
            append  Function " " $prvni " " $druhy                                    
            WarnWinText "Function Function_for_D_H_H_FNC_H generated ($Function)"
            set on [DWLocalSetValue $GDN $STRUCT Function_for_D_H_H_FNC_H $Function]            

            set initial_humidity [expr 0.4507 * $WaterCement_Ratio + 0.6847]
            set on [DWLocalSetValue $GDN $STRUCT Humidity_Const $initial_humidity] 
            WarnWinText "initial_humidity = $initial_humidity"         

                    
  } 
  if { $Typeofmaterial == "HPFRC_CONCRETE"} {
  
        if { $Typeofanalysis == "TEMPERATURE" || $Typeofanalysis == "TEMPERATURE_AND_MOISTURE"} {
              set concrete_lambda	2.1 
              #	W/(m K)	concrete conductivity 
              set steel_lambda	43
              #	W/(m K)	steel conductivity 
              set steel_c	3.53E+06
              #	J/(m3 K)	steel specific heat capacity
              set concrete_c	2.55E+06
              #	J/(m3 K)	concrete specific heat capacity
              set mass_of_fibers $Mass_of_fibres	
              #100	kg	
              set steel_density	0.007850
              #	kg/m3	   concrete_density = 0.0024
              set concrete_density $Density_of_concrete_without_fibers
              #	2400 kg/m3	(user input)
              #WarnWinText "mass_of_fibers = $mass_of_fibers"  
              #WarnWinText "concrete_density = $concrete_density"                                                          
              set unit "J/sec/C/m"
              set a1 [expr 1- ($mass_of_fibers/$steel_density)]
              set a2 [expr $steel_lambda*$mass_of_fibers/$steel_density]
              ##WarnWinText "a1 = $a1"
              #WarnWinText "a12 = $a2"
              set kttn [expr [expr $concrete_lambda* $a1] + $a2 ]
              set kttn [expr {double(round(1000*$kttn))/1000}]$unit
              set on [DWLocalSetValue $GDN $STRUCT K_TEMP_TEMP_NORMAL $kttn] 
              WarnWinText "K_TEMP_TEMP_NORMAL = $kttn"
    
              set unit "J/m^3/C"
              set cttn [expr ($steel_c*$mass_of_fibers+$concrete_c*(1-$mass_of_fibers/$steel_density)*$concrete_density)/($mass_of_fibers+(1-$mass_of_fibers/$steel_density)*$concrete_density) ]
              set cttn [expr {double(round(1000*$cttn))/1000}]$unit          
              set on [DWLocalSetValue $GDN $STRUCT C_TEMP_TEMP_NORMAL $cttn] 
              WarnWinText "C_TEMP_TEMP_NORMAL = $cttn"       
        }    
          

 } 
 if { $Typeofmaterial == "STEEL" } {
          set on [DWLocalSetValue $GDN $STRUCT K_TEMP_TEMP_NORMAL "43J/sec/C/m"] 
          WarnWinText "K_TEMP_TEMP_NORMAL = 43"
          set on [DWLocalSetValue $GDN $STRUCT C_TEMP_TEMP_NORMAL "3.53e+006J/m^3/C"] 
          WarnWinText "C_TEMP_TEMP_NORMAL = 3.53e+006"
 
 } 
 if { $Typeofmaterial == "MASONRY" } {
          set on [DWLocalSetValue $GDN $STRUCT K_TEMP_TEMP_NORMAL "0.8J/sec/C/m"] 
          WarnWinText "K_TEMP_TEMP_NORMAL = 0.8"
          set on [DWLocalSetValue $GDN $STRUCT C_TEMP_TEMP_NORMAL "1.6e+006J/m^3/C"] 
          WarnWinText "C_TEMP_TEMP_NORMAL = 1.6e+006"

 } 
 if { $Typeofmaterial == "CONCRETE_AT_HIGH_TEMPERATURE" || $Typeofmaterial == "HPFRC_CONCRETE_AT_HIGH_TEMPERATURE"} {
          set on [DWLocalSetValue $GDN $STRUCT Activate_Temperature_Advanced 1] 
          set on [DWLocalSetValue $GDN $STRUCT Activate_Temperature_Variable_Values 1]
          set on [DWLocalSetValue $GDN $STRUCT K_TEMP_TEMP_FNC 1]
          set on [DWLocalSetValue $GDN $STRUCT Activate_K_TEMP_TEMP_FNC_TEMP 1]
          if { $TypeofConductivity == "Lower_limit" } {
            set Function "#N# 14 0.0 1.0 200.0 0.817 400 0.667 600 0.551 800 0.468 1000 0.419 1200 0.404"
            set on [DWLocalSetValue $GDN $STRUCT Function_for_K_TEMP_TEMP_FNC_TEMP $Function]
          } 
          if { $TypeofConductivity == "Upper_limit" } {
            set Function "#N# 14 0.0 1.0 200.0 0.776 400 0.595 600 0.457 800 0.362 1000 0.310 1200 0.300"
            set on [DWLocalSetValue $GDN $STRUCT Function_for_K_TEMP_TEMP_FNC_TEMP $Function]
          }           
          WarnWinText "Function_for_K_TEMP_TEMP_FNC_TEMP set"
          
          set on [DWLocalSetValue $GDN $STRUCT C_TEMP_TEMP_FNC 1]
          set on [DWLocalSetValue $GDN $STRUCT Activate_C_TEMP_TEMP_FNC_TEMP 1]
          set Function "#N# 14 0.0 1.0 99.5 1.0 100.0 2.244 115.0 2.244 200.0 1.089 400.0 1.161 1200.0 1.076"
          set on [DWLocalSetValue $GDN $STRUCT Function_for_C_TEMP_TEMP_FNC_TEMP $Function]

          WarnWinText "Function_for_C_TEMP_TEMP_FNC_TEMP set"          
        } 


  if { $Typeofanalysis == "TEMPERATURE" } {
          set on [DWLocalSetValue $GDN $STRUCT Activate_Temperature 1] 
          WarnWinText "Temperature enabled"
          set on [DWLocalSetValue $GDN $STRUCT Activate_Moisture 0] 
          WarnWinText "Moisture disabled" 
        }
  if { $Typeofanalysis == "MOISTURE" } {
          set on [DWLocalSetValue $GDN $STRUCT Activate_Temperature 0] 
          WarnWinText "Temperature disabled"
          set on [DWLocalSetValue $GDN $STRUCT Activate_Moisture 1] 
          WarnWinText "Moisture enabled" 
        }
  if { $Typeofanalysis == "TEMPERATURE_AND_MOISTURE" } {
          set on [DWLocalSetValue $GDN $STRUCT Activate_Temperature 1] 
          WarnWinText "Temperature enabled"
          set on [DWLocalSetValue $GDN $STRUCT Activate_Moisture 1] 
          WarnWinText "Moisture enabled"          
        }                
  
  WarnWinText "Parameters of material were updated"
  WarnWinText "------------------------------------"
  
      set on [DWLocalSetValue $GDN $STRUCT Generate_Material No]
  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}



proc TK_GENERATE_MOISTURE_TEMPERATURE_BOUNDARY { event args } {
 switch $event {
   INIT {
  # WarnWin "init"
    return ""
   }
   SYNC {
  # WarnWin "sync"
    return ""
   }
   DEPEND {
   # ...
   #WarnWin "depend"
    set GDN [lindex $args 0]
    set STRUCT [lindex $args 1]
    set QUESTION [lindex $args 2]
    set ACTION [lindex $args 3]
    set VALUE [lindex $args 4]
    # Combination_dof_3
    #WarnWin "$GDN $STRUCT $QUESTION $ACTION $VALUE"
    
    set active [DWLocalGetValue $GDN $STRUCT "Activate_Help_Calculator"]
    set sc [DWLocalGetValue $GDN $STRUCT "Generate"]
    set fixedDofs [DWLocalGetValue $GDN $STRUCT "Help_Calc_FIXED_DOFS"]
    set typeOfCalc [DWLocalGetValue $GDN $STRUCT "Help_Calc_TYPE_OF_CALCULATION"]
    set typeMaterial [DWLocalGetValue $GDN $STRUCT "Help_Calc_TYPE_OF_MATERIAL"]
    set prefProcess [DWLocalGetValue $GDN $STRUCT "Help_Calc_TYPE_OF_PROCESS"]
    
    #WarnWin "fixedDofs = $fixedDofs ... sc= $sc"
    
    #set isc [string equal $sc "GLOBAL"]
    if { $sc == 1 } {
      #WarnWin "$GDN $STRUCT $QUESTION $ACTION $VALUE"
      #WarnWin "active = $active sc= $sc fixedDofs=$fixedDofs"
      
      set on [DWLocalSetValue $GDN $STRUCT "HEAT_CONVECTION_AND_RADIATION" 0] 
      set on [DWLocalSetValue $GDN $STRUCT "HEAT_EVAPORATION" 0] 
      set on [DWLocalSetValue $GDN $STRUCT "MOISTURE_CONVECTION" 0] 
      set on [DWLocalSetValue $GDN $STRUCT "MOISTURE_EVAPORATION" 0] 
      set on [DWLocalSetValue $GDN $STRUCT "MOISTURE_CEMSTONE_CALC" 0] 
      
      if { $typeOfCalc == "TEMPERATURE" || $typeOfCalc == "BOTH"} {   
          if { $prefProcess == "CONVECTION"} {
              set on [DWLocalSetValue $GDN $STRUCT "HEAT_CONVECTION_AND_RADIATION" 1]
          } else {
              set on [DWLocalSetValue $GDN $STRUCT "HEAT_EVAPORATION" 1]
          }
      }
      
      if { $typeOfCalc == "MOISTURE" || $typeOfCalc == "BOTH"} {  
          
          if { $typeMaterial == "CONCRETE"} {
              set on [DWLocalSetValue $GDN $STRUCT "MOISTURE_CEMSTONE_CALC" 1]
          } else {
                if { $prefProcess == "CONVECTION"} {
                    set on [DWLocalSetValue $GDN $STRUCT "MOISTURE_CONVECTION" 1]
                } else {
                    set on [DWLocalSetValue $GDN $STRUCT "MOISTURE_EVAPORATION" 1] 
                }
          }
      }      
    
      set on [DWLocalSetValue $GDN $STRUCT "Generate" 0]  
    }
    
    return ""
   }
   CLOSE {
   #WarnWin "close"
    return ""
   }
 }
 return ""
}   