proc TK_GenerateMCConcreteProperties { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
   
    # set oBaseMaterial [GiD_AccessValue get materials $QUESTION]
  	set BaseMaterial [DWLocalGetValue $GDN $STRUCT $QUESTION]
  	set Generate [DWLocalGetValue $GDN $STRUCT MC_Generate_Material]
   	set SafetyFormat [DWLocalGetValue $GDN $STRUCT MC_Safety_Format]
   	set StrengthValue [DWLocalGetValue $GDN $STRUCT MC_Strength_Value]
   	set StrengthType [DWLocalGetValue $GDN $STRUCT MC_Strength_Type]
   	#set value [GiD_AccessValue get IntvData $current Incremental_Multiplicators]
    
   
    set n1 [GidConvertValueUnit $StrengthValue]
    set n1 [ParserNumberUnit $n1 StrengthValue StrengthValueUnit]
    
    #WarnWinText $StrengthValue
    #WarnWinText $StrengthValueUnit
    set factor [GidTclGetUnitFactor "MPa"]
    #WarnWinText $factor 
    
    set StrengthValue [expr $StrengthValue/$factor]
    #WarnWinText $StrengthValue
    set StrengthValue [expr double(round(1000*$StrengthValue))/1000]
    #WarnWinText $StrengthValue
    
 
 if { $Generate == "No" } {
 } else {
 
# WarnWinText $BaseMaterial  	
 WarnWinText "Material parameters for strength type $StrengthType value $StrengthValue and Safety Format $SafetyFormat :"
 

 #Cubic-Characteristic,Cubic-Mean,Cylinder-Characteristic,Cylinder-Mean)
      #Cylinder-Characteristic
   set fcka $StrengthValue
      
   if { $fcka <0 } {
      set fcka [expr -1.0*$fcka]
  } else {
      set fcka [expr 1.0*$fcka]
  }       
                
  if { $StrengthType == "Cubic-Characteristic" } {
      set fcka [expr $StrengthValue*0.85]
      } elseif { $StrengthType == "Cubic-Mean" } {
      set fcka [expr ($StrengthValue-8)*0.85]
      } elseif { $StrengthType == "Cylinder-Mean" } {
      set fcka [expr ($StrengthValue-8)]
      }
   
  set fck $fcka    
     
   if { $fck <0 } {
      WarnWinText ""
      WarnWinText "----------Error------------"
      WarnWinText "Error: Fck < 0 MPa. It is not allowed."
      WarnWinText "----------Error------------"
      WarnWinText ""
      return ""
  }
  
  if {$fck < 12} {
      WarnWinText ""
      WarnWinText "----------Warning------------"
      WarnWinText "Fck < 12 MPa, Fcm < 20MPa"
      WarnWinText "This calculation acoording to the ModelCode is not suitable for Fck < 12 MPa or Fcm < 20MPa." 
      WarnWinText "Use cylinder characteristic strength for generation and characteristic Safety Format"
      WarnWinText "----------Warning------------"
      WarnWinText ""
  }      
  
  set gamma 1.0
  if { $SafetyFormat == "Design" } {set gamma 1.5}
  if { $SafetyFormat == "Characteristic" } {set gamma 1.0}
  if { $SafetyFormat == "Mean" } {set gamma 1.0}
  if { $SafetyFormat == "EN1992-2" } {set gamma 1.18577}      

  set fcm [expr $fck+8 ]
  set ea [expr ($fck+8.0)/10.0] 
  set eb [expr 1.0/3.0]
  set modulE [expr 21500*1*[tcl::mathfunc::pow  $ea $eb]]

  if {$fck <= 50} {
     set fctm [expr 0.3*[tcl::mathfunc::pow $fck 0.666666666666666]]
     set exc 0.52
  } else {
     set fctm [expr 2.12*log(1+0.1*($fck+8))]
     set exc 0.51
  }
  
 set fctk [expr 0.7*$fctm]

 if { $SafetyFormat == "Mean" } {
    set ft [expr $fctm/$gamma] 
    set fcs [expr $fcm/$gamma]
 } else {   
    set ft [expr $fctk/$gamma] 
    set fcs [expr $fck/$gamma]
  }
  
  
  #set gf [expr 73*(($fcs)^(18/100))]
  set gf [expr 73.0*[tcl::mathfunc::pow $fcs 0.18]]
  
  set eps12	-1.9
  set eps16	-2.0
  set eps20	-2.1
  set eps25	-2.2
  set eps30	-2.3
  set eps35	-2.3
  set eps40	-2.4
  set eps45	-2.5
  set eps50	-2.6
  set eps55	-2.6
  set eps60	-2.7
  set eps70	-2.7
  set eps80	-2.8
  set eps90	-2.9
  set eps100 -3.0
  set eps110 -3.0
  set eps120 -3.0

  if {$fck <= 12} {
     set eps_t $eps12
  } elseif {$fck > 12 && $fck <= 16} {
     set eps_t [expr ($eps16-$eps12)*($fck-12)/(16-12)+$eps12]
  } elseif {$fck > 16 && $fck <= 20} {
     set eps_t [expr ($eps20-$eps16)*($fck-16)/(20-16)+$eps16]
  } elseif {$fck > 20 && $fck <= 25} {
     set eps_t [expr ($eps25-$eps20)*($fck-20)/(25-20)+$eps20]
  } elseif {$fck > 25 && $fck <= 30} {
     set eps_t [expr ($eps30-$eps25)*($fck-25)/(30-25)+$eps25]
  } elseif {$fck > 30 && $fck <= 35} {
     set eps_t [expr ($eps35-$eps30)*($fck-30)/(35-30)+$eps30]
  } elseif {$fck > 35 && $fck <= 40} {
     set eps_t [expr ($eps40-$eps35)*($fck-35)/(40-35)+$eps35]
  } elseif {$fck > 40 && $fck <= 45} {
     set eps_t [expr ($eps45-$eps40)*($fck-40)/(45-40)+$eps40]
  } elseif {$fck > 45 && $fck <= 50} {
     set eps_t [expr ($eps50-$eps45)*($fck-45)/(50-45)+$eps45]                              
  } elseif {$fck > 50 && $fck <= 55} {
     set eps_t [expr ($eps55-$eps50)*($fck-50)/(55-50)+$eps50] 
  } elseif {$fck > 55 && $fck <= 60} {
     set eps_t [expr ($eps60-$eps55)*($fck-55)/(60-55)+$eps55] 
  } elseif {$fck > 60 && $fck <= 70} {
     set eps_t [expr ($eps70-$eps60)*($fck-60)/(70-60)+$eps60] 
  } elseif {$fck > 70 && $fck <= 80} {
     set eps_t [expr ($eps80-$eps70)*($fck-70)/(80-70)+$eps70] 
  } elseif {$fck > 80 && $fck <= 90} {
     set eps_t [expr ($eps90-$eps80)*($fck-80)/(90-80)+$eps80]                     
  } elseif {$fck > 90 && $fck <= 100} {
     set eps_t [expr ($eps100-$eps90)*($fck-90)/(100-90)+$eps90]  
  } elseif {$fck > 100 } {
     set eps_t $eps100 
  }
  #WarnWinText "fck = $fck"
  #WarnWinText "fcs = $fcs"
  #WarnWinText "eps_t = $eps_t"
  #WarnWinText "modulE = $modulE"
  set eps [expr $eps_t/1000 + $fcs/$modulE]
  #set eps [expr $fcs / $modulE]
  #WarnWinText "eps = $eps"

  #Onset_of_Crushing-FC0
  set ft0 [expr $ft* -2.1]
    
  
  #Young_s_Modulus-E
    set modulE2 [format %g%s $modulE "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Young_s_Modulus-E $modulE2] 
    WarnWinText "Young_s_Modulus-E = $modulE2"

    set on [DWLocalSetValue $GDN $STRUCT Poisson_s_Ratio 0.2] 
    WarnWinText "Poisson_s_Ratio = 0.2"
 
  #Tension_Strength-FT 
    set ft2 [format %10.3g%s $ft "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Tension_Strength-FT $ft2] 
    WarnWinText "Tension_Strength-FT = $ft2"
 
   #Compresion_Strength-FC
    set fcs3 [expr -1*$fcs]
    set fcs2 [format %10.3g%s $fcs3 "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Compresion_Strength-FC $fcs2]
    WarnWinText "Compresion_Strength-FC = $fcs2"  

   #Fracture_Energy-GF
    set gf [expr $gf / 1000000]
    set gf [format %10.3g%s $gf "MN/m"]
    set on [DWLocalSetValue $GDN $STRUCT Fracture_Energy-GF $gf] 
    WarnWinText "Fracture_Energy-GF = $gf"   
    
    set on [DWLocalSetValue $GDN $STRUCT Critical_Comp_Disp-WD -0.0005m] 
    WarnWinText "Critical_Comp_Disp-WD = -0.0005m"
    
  #Plastic_Strain-EPS_CP
    set eps [format %10.3g%s $eps ""]
    set on [DWLocalSetValue $GDN $STRUCT Plastic_Strain-EPS_CP $eps] 
    WarnWinText "Plastic_Strain-EPS_CP = $eps" 
    
  #Onset_of_Crushing-FC0
    set ft0 [format %10.3g%s $ft0 "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Onset_of_Crushing-FC0 $ft0] 
    WarnWinText "Onset_of_Crushing-FC0 = $ft0"
  
  set on [DWLocalSetValue $GDN $STRUCT Excentricity-EXC $exc] 
    WarnWinText "Excentricity-EXC = $exc"
  set on [DWLocalSetValue $GDN $STRUCT Dir_of_pl_Flow-BETA 0.0] 
    WarnWinText "Dir_of_pl_Flow-BETA = 0.0"
  set on [DWLocalSetValue $GDN $STRUCT Rho-Density 0.0023kton/m^3] 
    WarnWinText "Rho-Density = 0.0023kton/m^3"
  set on [DWLocalSetValue $GDN $STRUCT Thermal_Expansion-Alpha 0.000012C^-1] 
    WarnWinText "Thermal_Expansion-Alpha = 0.000012"
  set on [DWLocalSetValue $GDN $STRUCT Fixed_Crack 1] 
    WarnWinText "Fixed_Crack = 1"
  
  WarnWinText "Parameters of concerete were updated"
  WarnWinText "------------------------------------"
  
      set on [DWLocalSetValue $GDN $STRUCT MC_Generate_Material No]
      
      set StrengthValue [format %g%s $StrengthValue "MPa"]
      set on [DWLocalSetValue $GDN $STRUCT MC_Last_Generation_was_Strength_Value $StrengthValue]
      set on [DWLocalSetValue $GDN $STRUCT MC_Last_Generation_was_Safety_Format $SafetyFormat]
      set on [DWLocalSetValue $GDN $STRUCT MC_Last_Generation_was_Strength_Type $StrengthType]
  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}
