proc TK_GenerateFRCProperties { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK_GenerateFRCProperties Done"

# QUESTION: Generate_FRC#CB#(Yes,No)
# VALUE: No
# HELP: In order to generate the material parameters select this checkbox and than click the update changes button (next to the material name).
# TKWIDGET: TK_GenerateFRCProperties
# QUESTION: FRC_Select_checkbox_and_click_update_changes_button_to_generate_the_material.
# VALUE: !!!!
# state: disabled
# QUESTION: FRC_Type#CB#(BC48,Dramix5d,Hooked_end_steel)
# VALUE: BC48
# HELP: CC3DNonLinCementitious2-Material prototype is a template for input material parameters; CC3DNonLinCementitious2WithTempDepProperties-Material prototype for high Temperatura dependencies
# DEPENDENCIES: (BC48,RESTORE,FRC_BC48_Concrete,#CURRENT#,RESTORE,FRC_BC48_Weight_of_fibres,#CURRENT#,HIDE,FRC_Dramix5d_Concrete,#CURRENT#,HIDE,FRC_Dramix5d_Weight_of_fibres,#CURRENT#,HIDE,FRC_Hooked_end_steel_Concrete,#CURRENT#,HIDE,FRC_Hooked_end_steel_Weight_of_fibres,#CURRENT#)(Dramix5d,HIDE,FRC_BC48_Concrete,#CURRENT#,HIDE,FRC_BC48_Weight_of_fibres,#CURRENT#,RESTORE,FRC_Dramix5d_Concrete,#CURRENT#,RESTORE,FRC_Dramix5d_Weight_of_fibres,#CURRENT#,HIDE,FRC_Hooked_end_steel_Concrete,#CURRENT#,HIDE,FRC_Hooked_end_steel_Weight_of_fibres,#CURRENT#)(Hooked_end_steel,HIDE,FRC_BC48_Concrete,#CURRENT#,HIDE,FRC_BC48_Weight_of_fibres,#CURRENT#,HIDE,FRC_Dramix5d_Concrete,#CURRENT#,HIDE,FRC_Dramix5d_Weight_of_fibres,#CURRENT#,RESTORE,FRC_Hooked_end_steel_Concrete,#CURRENT#,RESTORE,FRC_Hooked_end_steel_Weight_of_fibres,#CURRENT#)
# QUESTION: FRC_BC48_Concrete#CB#(C25/30,C30/37,C35/45,C40/50)
# VALUE: C25/30
# QUESTION: FRC_BC48_Weight_of_fibres#CB#(2.5,3.0,3.5,4.0,4.5,5.0,5.5,6.0,6.5,7.0,7.5)
# VALUE: 2.5
# HELP: in kg
# QUESTION: FRC_Dramix5d_Concrete#CB#(C40/50,C50/60)
# VALUE: C40/50
# QUESTION: FRC_Dramix5d_Weight_of_fibres#CB#(20,25,30,35)
# VALUE: 20
# HELP: in kg
# QUESTION: FRC_Hooked_end_steel_Concrete#CB#(C25/30,C30/37,C35/45)
# VALUE: C25/30
# QUESTION: FRC_Hooked_end_steel_Weight_of_fibres#CB#(20,25,30,35,40)
# VALUE: 20
# HELP: in kg
    
    set Generate [DWLocalGetValue $GDN $STRUCT Generate_FRC]
    set FRC_Type [DWLocalGetValue $GDN $STRUCT FRC_Type]
  	set FRC_BC48_Concrete [DWLocalGetValue $GDN $STRUCT FRC_BC48_Concrete]
  	set FRC_BC48_Weight_of_fibres [DWLocalGetValue $GDN $STRUCT FRC_BC48_Weight_of_fibres]
   	set FRC_Dramix5d_Concrete [DWLocalGetValue $GDN $STRUCT FRC_Dramix5d_Concrete]
   	set FRC_Dramix5d_Weight_of_fibres [DWLocalGetValue $GDN $STRUCT FRC_Dramix5d_Weight_of_fibres]
   	set FRC_Hooked_end_steel_Concrete [DWLocalGetValue $GDN $STRUCT FRC_Hooked_end_steel_Concrete]
   	set FRC_Hooked_end_steel_Weight_of_fibres [DWLocalGetValue $GDN $STRUCT FRC_Hooked_end_steel_Weight_of_fibres]
   	
 
 if { $Generate == "No" || $Generate == "0" } {
 } else {
 #WarnWinText $Generate
 
 # WarnWinText "$FRC_Type   $FRC_BC48_Concrete   $FRC_BC48_Weight_of_fibres  "
  if { $FRC_Type == "BC48" } {
    WarnWinText "For Type $FRC_Type  "
    WarnWinText "and concrete $FRC_BC48_Concrete "
    WarnWinText "and weight of fibres  $FRC_BC48_Weight_of_fibres"    
    if { $FRC_BC48_Concrete == "C25/30" } {

        if { $FRC_BC48_Weight_of_fibres == "2.5" } { set a   1.69 }    
        if { $FRC_BC48_Weight_of_fibres == "3.0" } { set a  1.93 } 
        if { $FRC_BC48_Weight_of_fibres == "3.5" } { set a  2.19 } 
        if { $FRC_BC48_Weight_of_fibres == "4.0" } { set a  2.45 } 
        if { $FRC_BC48_Weight_of_fibres == "4.5" } { set a  2.80 } 
        if { $FRC_BC48_Weight_of_fibres == "5.0" } { set a  3.15 } 
        if { $FRC_BC48_Weight_of_fibres == "5.5" } { set a  3.65 } 
        if { $FRC_BC48_Weight_of_fibres == "6.0" } { set a  4.14 } 
        if { $FRC_BC48_Weight_of_fibres == "6.5" } { set a  4.70 } 
        if { $FRC_BC48_Weight_of_fibres == "7.0" } { set a  4.97 } 
        if { $FRC_BC48_Weight_of_fibres == "7.5" } { set a  5.25 } 
    } elseif { $FRC_BC48_Concrete == "C30/37" } {
        if { $FRC_BC48_Weight_of_fibres == "2.5" } { set a   1.69 }
        if { $FRC_BC48_Weight_of_fibres == "3.0" } { set a   1.93 }
        if { $FRC_BC48_Weight_of_fibres == "3.5" } { set a   2.33 }
        if { $FRC_BC48_Weight_of_fibres == "4.0" } { set a   2.74 }
        if { $FRC_BC48_Weight_of_fibres == "4.5" } { set a   3.21 }
        if { $FRC_BC48_Weight_of_fibres == "5.0" } { set a   3.68 }
        if { $FRC_BC48_Weight_of_fibres == "5.5" } { set a   4.00 }
        if { $FRC_BC48_Weight_of_fibres == "6.0" } { set a   4.32 }
        if { $FRC_BC48_Weight_of_fibres == "6.5" } { set a   4.84 }
        if { $FRC_BC48_Weight_of_fibres == "7.0" } { set a   5.10 }
        if { $FRC_BC48_Weight_of_fibres == "7.5" } { set a   5.37 } 
    } elseif { $FRC_BC48_Concrete == "C35/45" } {
        if { $FRC_BC48_Weight_of_fibres == "2.5" } { set a   1.75 }
        if { $FRC_BC48_Weight_of_fibres == "3.0" } { set a   1.98 }
        if { $FRC_BC48_Weight_of_fibres == "3.5" } { set a   2.39 }
        if { $FRC_BC48_Weight_of_fibres == "4.0" } { set a   2.80 }
        if { $FRC_BC48_Weight_of_fibres == "4.5" } { set a   3.27 }
        if { $FRC_BC48_Weight_of_fibres == "5.0" } { set a   3.73 }
        if { $FRC_BC48_Weight_of_fibres == "5.5" } { set a   4.08 }
        if { $FRC_BC48_Weight_of_fibres == "6.0" } { set a   4.43 }
        if { $FRC_BC48_Weight_of_fibres == "6.5" } { set a   4.96 }
        if { $FRC_BC48_Weight_of_fibres == "7.0" } { set a   5.22 }
        if { $FRC_BC48_Weight_of_fibres == "7.5" } { set a   5.48 } 
    } elseif { $FRC_BC48_Concrete == "C40/50" } {
        if { $FRC_BC48_Weight_of_fibres == "2.5" } { set a   1.75 }
        if { $FRC_BC48_Weight_of_fibres == "3.0" } { set a   2.10 }
        if { $FRC_BC48_Weight_of_fibres == "3.5" } { set a   2.54 }
        if { $FRC_BC48_Weight_of_fibres == "4.0" } { set a   2.98 }
        if { $FRC_BC48_Weight_of_fibres == "4.5" } { set a   3.41 }
        if { $FRC_BC48_Weight_of_fibres == "5.0" } { set a   3.85 }
        if { $FRC_BC48_Weight_of_fibres == "5.5" } { set a   4.20 }
        if { $FRC_BC48_Weight_of_fibres == "6.0" } { set a   4.55 }
        if { $FRC_BC48_Weight_of_fibres == "6.5" } { set a   5.08 }
        if { $FRC_BC48_Weight_of_fibres == "7.0" } { set a   5.34 }
        if { $FRC_BC48_Weight_of_fibres == "7.5" } { set a   5.60 } 
    } 
  }

  if { $FRC_Type == "Dramix5d" } {
    if { $FRC_Dramix5d_Concrete == "C40/50" } {
        if { $FRC_Dramix5d_Weight_of_fibres == "20" } { set a 7.55 }
        if { $FRC_Dramix5d_Weight_of_fibres == "25" } { set a 8.90 }
        if { $FRC_Dramix5d_Weight_of_fibres == "30" } { set a 10.25 }
        if { $FRC_Dramix5d_Weight_of_fibres == "35" } { set a 12.22 }
    } elseif { $FRC_Dramix5d_Concrete == "C50/60" } {
        if { $FRC_Dramix5d_Weight_of_fibres == "20" } { set a 4.33 }
        if { $FRC_Dramix5d_Weight_of_fibres == "25" } { set a 6.01 }
        if { $FRC_Dramix5d_Weight_of_fibres == "30" } { set a 7.68 }
        if { $FRC_Dramix5d_Weight_of_fibres == "35" } { set a 7.51 }
    } 
  }

  if { $FRC_Type == "Hooked_end_steel" } {
    if { $FRC_Hooked_end_steel_Concrete == "C25/30" } {
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "20" } { set a 1.96 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "25" } { set a 2.56 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "30" } { set a 3.61 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "35" } { set a 4.33 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "40" } { set a 5.05 }
    } elseif { $FRC_Hooked_end_steel_Concrete == "C30/37" } {
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "20" } { set a 2.03 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "25" } { set a 2.34 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "30" } { set a 3.06 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "35" } { set a 3.80 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "40" } { set a 4.54 }     
    } elseif { $FRC_Hooked_end_steel_Concrete == "C35/45" } {
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "20" } { set a 2.36 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "25" } { set a 3.10 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "30" } { set a 3.73 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "35" } { set a 4.42 }
        if { $FRC_Hooked_end_steel_Weight_of_fibres == "40" } { set a 5.11 }     
    } 
  }
 
      set aa [expr (1000.0*$a) ] 
      
      set gff [format %g%s $aa "N/m"]
      set on [DWLocalSetValue $GDN $STRUCT G_FF $gff] 
      
      set wff [format %g%s 3.5 "mm"]
      set on [DWLocalSetValue $GDN $STRUCT W_FF $wff]  
      
      WarnWinText "G_FF = $gff "
      WarnWinText "W_FF = $wff"
      
      WarnWinText "FRC parameters were generated"
      set on [DWLocalSetValue $GDN $STRUCT Generate_FRC No]     

  }
   return ""
  } 
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}
