proc TK_GenerateEC2PropertiesReinf { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
    
  	set YoungsModulusE [DWLocalGetValue $GDN $STRUCT Young_s_Modulus_E]
  	set Generate [DWLocalGetValue $GDN $STRUCT Generate_Material]
   	set SafetyFormat [DWLocalGetValue $GDN $STRUCT Safety_Format]
   	set CharacteristicYieldStrength [DWLocalGetValue $GDN $STRUCT Characteristic_Yield_Strength_f_xk]
   	set ClassofReinforcement [DWLocalGetValue $GDN $STRUCT Class_of_Reinforcement]
   	
   	set TypeofReinforcement [DWLocalGetValue $GDN $STRUCT Type_of_reinforcement]
   	
   	
    set paramk [DWLocalGetValue $GDN $STRUCT Parameter_k]
    set paramkeps [DWLocalGetValue $GDN $STRUCT Epsilon_u_k]

   set n1 [GidConvertValueUnit $CharacteristicYieldStrength]
   set n1 [ParserNumberUnit $n1 CharacteristicYieldStrength CharacteristicYieldStrengthunit]

   set n2 [GidConvertValueUnit $YoungsModulusE]
   set n2 [ParserNumberUnit $n2 YoungsModulusEValue YoungsModulusEUnit] 
 
 if { $Generate == "No" } {
 } else {
 
# WarnWinText $BaseMaterial  	
 WarnWinText "Material parameters for Class $ClassofReinforcement and Characteristic Yield Strength $CharacteristicYieldStrength and Safety Format $SafetyFormat :"
 

# $SafetyFormat
  if { $SafetyFormat == "Design" } {set gamma 1.15}
  if { $SafetyFormat == "Characteristic" } {set gamma 1.0}
  if { $SafetyFormat == "Mean" } {set gamma 0.90909090909090909090909090909090909}


  if { $CharacteristicYieldStrength < 400 } {
WarnWinText "!!!!! Characteristic Yield Strength fyk $CharacteristicYieldStrength should be bigger then 400 MPa."
        }

  if { $CharacteristicYieldStrength > 600 } {
WarnWinText "!!!!! Characteristic Yield Strength fyk $CharacteristicYieldStrength should be smaller then 600 MPa."
        }

#  if { $ClassofReinforcement == "A" } {
#        set paramk 1.05
#        set paramkeps 0.025
#        }
#  if { $ClassofReinforcement == "B" } {
#        set paramk 1.08
#        set paramkeps 0.05
#        }
#  if { $ClassofReinforcement == "C" } {
#        set paramk 1.15
#        set paramkeps 0.075
#        }
        
        
  if { $ClassofReinforcement == "Choose_Class" } {     
  if { $TypeofReinforcement=="Reinforcement"  } {
    WarnWinText "Please choose class of reinforcement !!"
    return ""
        }
   } 
set ysb [expr $CharacteristicYieldStrength / $gamma]
set eps2 $paramkeps
set f2b [expr $ysb * $paramk]
 
  if { $SafetyFormat == "Design" } {
  set eps2 [expr $paramkeps * 0.9]
  set eps2 [format %10.3g%s $eps2 ""]
  set f2b [expr ($ysb + ($ysb*($paramk-1))/($paramkeps-$ysb/$YoungsModulusEValue ) * ($paramkeps*0.9-$ysb/$YoungsModulusEValue ) ) ]
  }
  
  #Young_s_Modulus-E
    #set modulE2 [format %g%s $YoungsModulusE "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Reinf_01_Young_s_Modulus-E $YoungsModulusE] 
    WarnWinText "Young_s_Modulus-E = $YoungsModulusE"

  #Reinf_01_Yield_Strength_YS
    #set ys [format %10.3g%s $ysb "MPa"]
    set ys [format %g%s $ysb $CharacteristicYieldStrengthunit]
    set on [DWLocalSetValue $GDN $STRUCT Reinf_01_Yield_Strength_YS $ys] 
    WarnWinText "Reinf_01_Yield_Strength_YS = $ys"
 
   #Reinf_01_eps2
    set on [DWLocalSetValue $GDN $STRUCT Reinf_01_eps2 $eps2] 
    WarnWinText "Reinf_01_eps2 = $eps2"
 
   #Reinf_01_f2
    set f2 [format %g%s $f2b $CharacteristicYieldStrengthunit]
    set on [DWLocalSetValue $GDN $STRUCT Reinf_01_f2 $f2] 
    WarnWinText "Reinf_01_f2 = $f2"   
   
    set on [DWLocalSetValue $GDN $STRUCT Reinf_01_Number_of_Multilinear_values 2] 
    WarnWinText "Reinf_01_Number_of_Multilinear_values = 2"  
       
    set on [DWLocalSetValue $GDN $STRUCT Rho-Density 7850kg/m^3] 
    WarnWinText "Rho-Density = 7850kg/m^3"

    set on [DWLocalSetValue $GDN $STRUCT Thermal_Expansion-Alpha 0.000012C^-1] 
    WarnWinText "Thermal_Expansion-Alpha = 0.000012"
    
   
  
  WarnWinText "Parameters of reinforcement were updated"
  WarnWinText "------------------------------------"
     set on [DWLocalSetValue $GDN $STRUCT Generate_Material No]
     
      set CharacteristicYieldStrength [format %g%s $CharacteristicYieldStrength $CharacteristicYieldStrengthunit]
     
      set on [DWLocalSetValue $GDN $STRUCT Last_Generation_Characteristic_Yield_Strength_f_xk $CharacteristicYieldStrength]
      set on [DWLocalSetValue $GDN $STRUCT Last_Generation_Type_of_reinforcement $TypeofReinforcement]
      set on [DWLocalSetValue $GDN $STRUCT Last_Generation_Young_s_Modulus_E $YoungsModulusE]
      set on [DWLocalSetValue $GDN $STRUCT Last_Generation_Class_of_Reinforcement $ClassofReinforcement]
      set on [DWLocalSetValue $GDN $STRUCT Last_Generation_Epsilon_u_k $paramkeps]
      set on [DWLocalSetValue $GDN $STRUCT Last_Generation_Parameter_k $paramk]
      set on [DWLocalSetValue $GDN $STRUCT Last_Generation_Safety_Format $SafetyFormat]
      
  
  
  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}














proc TK_GenerateEC2Properties { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
   
    # set oBaseMaterial [GiD_AccessValue get materials $QUESTION]
  	set BaseMaterial [DWLocalGetValue $GDN $STRUCT $QUESTION]
  	set Generate [DWLocalGetValue $GDN $STRUCT EC2_Generate_Material]
   	set SafetyFormat [DWLocalGetValue $GDN $STRUCT EC2_Safety_Format]
   	set StrengthClass [DWLocalGetValue $GDN $STRUCT EC2_Strength_Class]
   	#set value [GiD_AccessValue get IntvData $current Incremental_Multiplicators]
 
 if { $Generate == "No" } {
 } else {
 
# WarnWinText $BaseMaterial  	
 WarnWinText "Material parameters for strength class $StrengthClass and Safety Format $SafetyFormat :"
 

# $SafetyFormat

  if { $StrengthClass == "12/15" } {
        set fck 12
        set beton 15
        set fcm 20
        set fctm 1.6
        set fctk 1.1
        set modulE 27000
        }
  if { $StrengthClass == "16/20" } {
        set fck 16
        set beton 20
        set fcm 24
        set fctm 1.9
        set fctk 1.3
        set modulE 29000
        }
  if { $StrengthClass == "20/25" } {
        set fck 20
        set beton 25
        set fcm 28
        set fctm 2.2
        set fctk 1.5
        set modulE 30000
        }
  if { $StrengthClass == "25/30" } {
        set fck 25
        set beton 30
        set fcm 33
        set fctm 2.6
        set fctk 1.8
        set modulE 31000
        }
  if { $StrengthClass == "30/37" } {
        set fck 30
        set beton 37
        set fcm 38
        set fctm 2.9
        set fctk 2
        set modulE 32000
        }
  if { $StrengthClass == "35/45" } {
        set fck 35
        set beton 45
        set fcm 43
        set fctm 3.2
        set fctk 2.2
        set modulE 34000
        }
  if { $StrengthClass == "40/50" } {
        set fck 40
        set beton 50
        set fcm 48
        set fctm 3.5
        set fctk 2.5
        set modulE 35000
        }   
  if { $StrengthClass == "45/55" } {
        set fck 45
        set beton 55
        set fcm 53
        set fctm 3.8
        set fctk 2.7
        set modulE 36000
        }   
  if { $StrengthClass == "50/60" } {
        set fck 50
        set beton 60
        set fcm 58
        set fctm 4.1
        set fctk 2.9
        set modulE 37000
        }   
  if { $StrengthClass == "55/67" } {
        set fck 55
        set beton 67
        set fcm 63
        set fctm 4.2
        set fctk 3
        set modulE 38000
        }   
  if { $StrengthClass == "60/75" } {
        set fck 60
        set beton 75
        set fcm 68
        set fctm 4.4
        set fctk 3.1
        set modulE 39000
        }   
  if { $StrengthClass == "70/85" } {
        set fck 70
        set beton 85
        set fcm 78
        set fctm 4.6
        set fctk 3.2
        set modulE 41000
        }   
  if { $StrengthClass == "80/95" } {
        set fck 80
        set beton 95
        set fcm 88
        set fctm 4.8
        set fctk 3.4
        set modulE 42000
        }
  if { $StrengthClass == "90/105" } {
        set fck 90
        set beton 105
        set fcm 98
        set fctm 5
        set fctk 3.5
        set modulE 44000
        } 
                                                                                                   
  if { $SafetyFormat == "Design" } {set gamma 1.5}
  if { $SafetyFormat == "Characteristic" } {set gamma 1.0}
  if { $SafetyFormat == "Mean" } {set gamma 1.0}
  if { $SafetyFormat == "EN1992-2" } {set gamma 1.18577}  
  # = 1,1 * 1,15 / 1,5 (CSN EN 1992-2 5.7)   

  
  #Young_s_Modulus-E
    set modulE2 [format %g%s $modulE "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Young_s_Modulus-E $modulE2] 
    WarnWinText "Young_s_Modulus-E = $modulE2"

    set on [DWLocalSetValue $GDN $STRUCT Poisson_s_Ratio 0.2] 
    WarnWinText "Poisson_s_Ratio = 0.2"
 
  
 if { $SafetyFormat == "Mean" } {
   #Tension_Strength-FT 
    set ft [expr $fctm / $gamma]
  #Compresion_Strength-FC
    set fcs [expr $fcm / -$gamma]
 
 } else {   
  #Tension_Strength-FT 
    set ft [expr $fctk / $gamma]
  #Compresion_Strength-FC
    set fcs [expr $fck / -$gamma]
  }
 
  #Tension_Strength-FT 
    set ft2 [format %10.3g%s $ft "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Tension_Strength-FT $ft2] 
    WarnWinText "Tension_Strength-FT = $ft2"
 
   #Compresion_Strength-FC   
    set fcs2 [format %10.3g%s $fcs "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Compresion_Strength-FC $fcs2] 
    WarnWinText "Compresion_Strength-FC = $fcs2"  

 
   #Fracture_Energy-GF
    set gf [expr $ft *  0.000025]
    set gf [format %10.3g%s $gf "MN/m"]
    set on [DWLocalSetValue $GDN $STRUCT Fracture_Energy-GF $gf] 
    WarnWinText "Fracture_Energy-GF = $gf"   
    
    set on [DWLocalSetValue $GDN $STRUCT Critical_Comp_Disp-WD -0.0005m] 
    WarnWinText "Critical_Comp_Disp-WD = -0.0005m"
    
  #Plastic_Strain-EPS_CP
    #eps_cp = eps_c1  fc/E
    #WarnWinText "Fcm = $fcm"
    #set a [tcl::mathfunc::pow  $fcm 0.31]
    #WarnWinText "Fcm na 0,31 = $a" 
    set eps [expr -0.7 * [tcl::mathfunc::pow  $fcm 0.31]/1000 - ($fcs / $modulE)]
    #set eps [expr $fcs / $modulE]
    set eps [format %10.5g%s $eps ""]
    set on [DWLocalSetValue $GDN $STRUCT Plastic_Strain-EPS_CP $eps] 
    WarnWinText "Plastic_Strain-EPS_CP = $eps" 
    #set epsold [expr $fcs / $modulE]
    #WarnWinText "Plastic_Strain-EPS_CP old = $epsold"
    
  #Onset_of_Crushing-FC0
    set ft0 [expr $ft * -2.1]
    set ft0 [format %10.3g%s $ft0 "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Onset_of_Crushing-FC0 $ft0] 
    WarnWinText "Onset_of_Crushing-FC0 = $ft0"
  
  set on [DWLocalSetValue $GDN $STRUCT Excentricity-EXC 0.52] 
    WarnWinText "Excentricity-EXC = 0.52"
  set on [DWLocalSetValue $GDN $STRUCT Dir_of_pl_Flow-BETA 0.0] 
    WarnWinText "Dir_of_pl_Flow-BETA = 0.0"
  set on [DWLocalSetValue $GDN $STRUCT Rho-Density 0.0023kton/m^3] 
    WarnWinText "Rho-Density = 0.0023kton/m^3"
  set on [DWLocalSetValue $GDN $STRUCT Thermal_Expansion-Alpha 0.000012C^-1] 
    WarnWinText "Thermal_Expansion-Alpha = 0.000012"
  set on [DWLocalSetValue $GDN $STRUCT Fixed_Crack 1] 
    WarnWinText "Fixed_Crack = 1"
  
  WarnWinText "Parameters of concerete were updated"
  WarnWinText "------------------------------------"
  
      set on [DWLocalSetValue $GDN $STRUCT EC2_Generate_Material No]
      
      set on [DWLocalSetValue $GDN $STRUCT EC2_Last_Generation_was_Strength_Class $StrengthClass]
      set on [DWLocalSetValue $GDN $STRUCT EC2_Last_Generation_was_Safety_Format $SafetyFormat]
      
   # GiD_CreateData create material Concrete_EC2 Aluminium
 
 
 
  
  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}
proc TK_GenerateSP63Properties { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateSP63Properties Done"
   
    # set oBaseMaterial [GiD_AccessValue get materials $QUESTION]
  	set BaseMaterial [DWLocalGetValue $GDN $STRUCT $QUESTION]
  	set Generate [DWLocalGetValue $GDN $STRUCT SP63_Generate_Material]
   	set SafetyFormat [DWLocalGetValue $GDN $STRUCT SP63_Safety_Format]
   	set StrengthClass [DWLocalGetValue $GDN $STRUCT SP63_Strength_Class]
   	#set value [GiD_AccessValue get IntvData $current Incremental_Multiplicators]
 
 if { $Generate == "No" } {
 } else {
 
# WarnWinText $BaseMaterial  	
 WarnWinText "Material parameters for strength class $StrengthClass and Safety Format $SafetyFormat :"
 

# $SafetyFormat

  if { $StrengthClass == "B15"} {
        set fck 11.0
        set beton 15.0
        set fcm 13.8
        set fctm 1.50
        set fctk 1.10
        set modulE 24000.0
        }
  if { $StrengthClass == "B20"} {
        set fck 15.0
        set beton 20.0
        set fcm 18.8
        set fctm 1.90
        set fctk 1.35
        set modulE 27500.0
        }
  if { $StrengthClass == "B25"} {
        set fck 18.5
        set beton 25.0
        set fcm 23.1
        set fctm 2.20
        set fctk 1.55
        set modulE 30000.0
        }
  if { $StrengthClass == "B30"} {
        set fck 22.0
        set beton 30.0
        set fcm 27.5
        set fctm 2.50
        set fctk 1.75
        set modulE 32500.0
        }
  if { $StrengthClass == "B35"} {
        set fck 25.5
        set beton 35.0
        set fcm 31.9
        set fctm 2.70
        set fctk 1.95
        set modulE 34500.0
        }
  if { $StrengthClass == "B40"} {
        set fck 29.0
        set beton 40.0
        set fcm 36.3
        set fctm 3.00
        set fctk 2.10
        set modulE 36000.0
        }
  if { $StrengthClass == "B45"} {
        set fck 32.0
        set beton 45.0
        set fcm 40.0
        set fctm 3.20
        set fctk 2.25
        set modulE 37000.0
        }
  if { $StrengthClass == "B50"} {
        set fck 36.0
        set beton 50.0
        set fcm 45.0
        set fctm 3.50
        set fctk 2.45
        set modulE 38000.0
        }
  if { $StrengthClass == "B55"} {
        set fck 39.5
        set beton 55.0
        set fcm 49.4
        set fctm 3.70
        set fctk 2.60
        set modulE 39000.0
        }
  if { $StrengthClass == "B60"} {
        set fck 43.0
        set beton 60.0
        set fcm 53.8
        set fctm 3.90
        set fctk 2.75
        set modulE 39500.0
        }
  if { $StrengthClass == "B70"} {
        set fck 50.0
        set beton 70.0
        set fcm 62.5
        set fctm 4.20
        set fctk 3.00
        set modulE 41000.0
        }
  if { $StrengthClass == "B80"} {
        set fck 57.0
        set beton 80.0
        set fcm 71.3
        set fctm 4.70
        set fctk 3.30
        set modulE 42000.0
        }
  if { $StrengthClass == "B90"} {
        set fck 64.0
        set beton 90.0
        set fcm 80.0
        set fctm 5.10
        set fctk 3.60
        set modulE 42500.0
        }
  if { $StrengthClass == "B100"} {
        set fck 71.0
        set beton 100.0
        set fcm 88.8
        set fctm 5.40
        set fctk 3.80
        set modulE 43000.0
        }
                                                                                                   
  if { $SafetyFormat == "Design" } {set gamma 1.3
									set gammat 1.5}
  if { $SafetyFormat == "Characteristic" } {set gamma 1.0}
  if { $SafetyFormat == "Mean" } {set gamma 1.0}

  
  #Young_s_Modulus-E
    set modulE2 [format %g%s $modulE "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Young_s_Modulus-E $modulE2] 
    WarnWinText "Young_s_Modulus-E = $modulE2"

    set on [DWLocalSetValue $GDN $STRUCT Poisson_s_Ratio 0.2] 
    WarnWinText "Poisson_s_Ratio = 0.2"
 
  
 if { $SafetyFormat == "Design" } {
   #Tension_Strength-FT 
    set ft [expr $fctk / $gammat]
  #Compresion_Strength-FC
    set fcs [expr $fck / -$gamma]
	}
 if { $SafetyFormat == "Characteristic" } {
   #Tension_Strength-FT 
    set ft [expr $fctk / $gamma]
  #Compresion_Strength-FC
    set fcs [expr $fck / -$gamma]
	}
 if { $SafetyFormat == "Mean" } {
   #Tension_Strength-FT 
    set ft [expr $fctm / $gamma]
  #Compresion_Strength-FC
    set fcs [expr $fcm / -$gamma]
	}
 
  #Tension_Strength-FT 
    set ft2 [format %10.3g%s $ft "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Tension_Strength-FT $ft2] 
    WarnWinText "Tension_Strength-FT = $ft2"
 
   #Compresion_Strength-FC   
    set fcs2 [format %10.3g%s $fcs "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Compresion_Strength-FC $fcs2] 
    WarnWinText "Compresion_Strength-FC = $fcs2"  

 
   #Fracture_Energy-GF
    set gf [expr $ft *  0.000025]
    set gf [format %10.3g%s $gf "MN/m"]
    set on [DWLocalSetValue $GDN $STRUCT Fracture_Energy-GF $gf] 
    WarnWinText "Fracture_Energy-GF = $gf"   
    
    set on [DWLocalSetValue $GDN $STRUCT Critical_Comp_Disp-WD -0.0005m] 
    WarnWinText "Critical_Comp_Disp-WD = -0.0005m"
    
  #Plastic_Strain-EPS_CP
    #eps_cp = eps_c1  fc/E
    #WarnWinText "Fcm = $fcm"
    #set a [tcl::mathfunc::pow  $fcm 0.31]
    #WarnWinText "Fcm na 0,31 = $a" 
    #set eps [expr -0.7 * [tcl::mathfunc::pow  $fcm 0.31]/1000 - ($fcs / $modulE)] - old from Eurocode
	set eps [expr ((-$beton / $modulE) * ( 1 + ( 0.75 * $beton / 60 ) + ( 0.2 / $beton ) ) / ( 0.12 + ($beton / 60) + (0.2 / $beton))) - ($fcs / $modulE)]
	    #set eps [expr $fcs / $modulE]
    set eps [format %10.5g%s $eps ""]
    set on [DWLocalSetValue $GDN $STRUCT Plastic_Strain-EPS_CP $eps] 
    WarnWinText "Plastic_Strain-EPS_CP = $eps" 
    #set epsold [expr $fcs / $modulE]
    #WarnWinText "Plastic_Strain-EPS_CP old = $epsold"
    
  #Onset_of_Crushing-FC0
    set ft0 [expr $ft * -2.1]
    set ft0 [format %10.3g%s $ft0 "MPa"]
    set on [DWLocalSetValue $GDN $STRUCT Onset_of_Crushing-FC0 $ft0] 
    WarnWinText "Onset_of_Crushing-FC0 = $ft0"
  
  set on [DWLocalSetValue $GDN $STRUCT Excentricity-EXC 0.52] 
    WarnWinText "Excentricity-EXC = 0.52"
  set on [DWLocalSetValue $GDN $STRUCT Dir_of_pl_Flow-BETA 0.0] 
    WarnWinText "Dir_of_pl_Flow-BETA = 0.0"
  set on [DWLocalSetValue $GDN $STRUCT Rho-Density 0.0023kton/m^3] 
    WarnWinText "Rho-Density = 0.0023kton/m^3"
  set on [DWLocalSetValue $GDN $STRUCT Thermal_Expansion-Alpha 0.000012C^-1] 
    WarnWinText "Thermal_Expansion-Alpha = 0.000012"
  set on [DWLocalSetValue $GDN $STRUCT Fixed_Crack 1] 
    WarnWinText "Fixed_Crack = 1"
  
  WarnWinText "Parameters of concrete were updated"
  WarnWinText "------------------------------------"
  
      set on [DWLocalSetValue $GDN $STRUCT SP63_Generate_Material No]
      
      set on [DWLocalSetValue $GDN $STRUCT SP63_Last_Generation_was_Strength_Class $StrengthClass]
      set on [DWLocalSetValue $GDN $STRUCT SP63_Last_Generation_was_Safety_Format $SafetyFormat]
      
   # GiD_CreateData create material Concrete_EC2 Aluminium
 
 
 
  
  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}