proc TK_GenerateDruckerPrager { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
    
  	set Generate [DWLocalGetValue $GDN $STRUCT Generate_Parameters_From_Fi_and_C]
   	set hodnotaFi [DWLocalGetValue $GDN $STRUCT Input_Friction]
   	set hodnotaC [DWLocalGetValue $GDN $STRUCT Input_Cohesion]
   	set hodnotaCone [DWLocalGetValue $GDN $STRUCT Generate_DP_Cone]


   set n1 [GidConvertValueUnit $hodnotaC]
   set n1 [ParserNumberUnit $n1 hodnotaC hodnotaCunit]
   
 if { $Generate == "Yes" } {
 
 WarnWinText "Material parameters for" 
 WarnWinText "Generate_DP_Cone = $hodnotaCone"
 WarnWinText "Generate_DP_Fi = $hodnotaFi"
 WarnWinText "Generate_DP_C = $hodnotaC :"
 WarnWinText " "
 
 set hodnotaFi [expr (($hodnotaFi*3.1415926535897932384626433832795)/180.0) ] 
 
 set sinFi [expr sin($hodnotaFi)]
 
# WarnWinText "sin Fi = $sinFi "
# WarnWinText "[expr (2*sin($hodnotaFi))]"
# WarnWinText "[expr (3-sin($hodnotaFi))]"
# WarnWinText "[expr (sqrt(3.0))]"
# WarnWinText "[expr ( (sqrt(3.0)) * (3-sin($hodnotaFi)))]"
 

 
  if { $hodnotaCone == "Outer" } {
  set alfa [expr (2*sin($hodnotaFi)) /( (sqrt(3.0)) * (3-sin($hodnotaFi)) )    ] 
  set ka [expr (6*$hodnotaC*cos($hodnotaFi)) /( (sqrt(3.0)) * (3-sin($hodnotaFi)) )    ]
  }

  if { $hodnotaCone == "Inner" } {
  set alfa [expr (2*sin($hodnotaFi)) /( (sqrt(3.0)) * (3+sin($hodnotaFi)) )    ] 
  set ka [expr (6*$hodnotaC*cos($hodnotaFi)) /( (sqrt(3.0)) * (3+sin($hodnotaFi)) )    ] 
  }
    
    set alfa [format %g $alfa]
    set on [DWLocalSetValue $GDN $STRUCT Drucker-Prager_ALPHA_DP $alfa] 
    WarnWinText "Drucker-Prager_ALPHA_DP = $alfa"

    set ka [format %g%s $ka $hodnotaCunit]
    set on [DWLocalSetValue $GDN $STRUCT Drucker-Prager_param-K $ka] 
    WarnWinText "Drucker-Prager_param-K = $ka"   
  
  WarnWinText "Parameters of Drucker Prager were updated"
  WarnWinText "------------------------------------"
     set on [DWLocalSetValue $GDN $STRUCT Generate_Parameters_From_Fi_and_C No]
  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}





proc TK_GenerateDruckerPragerFt { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
    
  	set Generate [DWLocalGetValue $GDN $STRUCT Generate_Parameters_From_Ft_and_Fc]
   	set hodnotaFt [DWLocalGetValue $GDN $STRUCT Input_Ft]
   	set hodnotaFc [DWLocalGetValue $GDN $STRUCT Input_Fc]

   set n1 [GidConvertValueUnit $hodnotaFt]
   set n1 [ParserNumberUnit $n1 hodnotaFt hodnotaFtunit]
   
   set n1 [GidConvertValueUnit $hodnotaFc]
   set n1 [ParserNumberUnit $n1 hodnotaFc hodnotaFcunit]

set hodnotaFc [expr abs($hodnotaFc)]
set hodnotaFt [expr abs($hodnotaFt)]
   
 if { $Generate == "Yes" } {
 
 WarnWinText "Material parameters for" 
 WarnWinText "Generate_DP_Ft = $hodnotaFt"
 WarnWinText "Generate_DP_Fc = $hodnotaFc :"
 WarnWinText " "
 
 
  set alfa [expr ( $hodnotaFc - $hodnotaFt ) /( (sqrt(3.0)) * ( $hodnotaFc + $hodnotaFt ))     ] 
  set ka [expr $hodnotaFc * (0.5773502 - $alfa)]

    set alfa [format %g $alfa]
    set on [DWLocalSetValue $GDN $STRUCT Drucker-Prager_ALPHA_DP $alfa] 
    WarnWinText "Drucker-Prager_ALPHA_DP = $alfa"

    set ka [format %g%s $ka $hodnotaFcunit]
    set on [DWLocalSetValue $GDN $STRUCT Drucker-Prager_param-K $ka] 
    WarnWinText "Drucker-Prager_param-K = $ka"   
  
  WarnWinText "Parameters of Drucker Prager were updated"
  WarnWinText "------------------------------------"
     set on [DWLocalSetValue $GDN $STRUCT Generate_Parameters_From_Ft_and_Fc No]
  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}
