proc TK_GenerateBondPropertiesReinf { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"

#QUESTION: Bond_law_by#CB#(Bigaj_1999,CEB_FIB_model_code_1990,NONE)
#VALUE: Bigaj_1999
#QUESTION: Bond_Fcu#UNITS#
#VALUE: 30MPa
#QUESTION: Bond_Bar_Diameter#UNITS#
#VALUE: 0.01m
#QUESTION: Bond_Reinforcement_type#CB#(ribbed_reinf,cold_drawn_wire,hot_rolled_bars)
#VALUE: ribbed_reinf
#QUESTION: Bond_Concrete_confinement#CB#(unconfined,confined)
#VALUE: unconfined
#QUESTION: Bond_quality#CB#(excelent,good,bad)
#VALUE: good
#QUESTION: Bond_qualityCEB#CB#(good,all_other_cases)
#VALUE: good
    
    set BondLawBy [DWLocalGetValue $GDN $STRUCT Bond_law_by]
  	set BondFcu [DWLocalGetValue $GDN $STRUCT Bond_Fcu]
  	set Generate [DWLocalGetValue $GDN $STRUCT Generate_Material_Bond]
   	set BarDiameter [DWLocalGetValue $GDN $STRUCT Bond_Bar_Diameter]
   	set Reinforcement_type [DWLocalGetValue $GDN $STRUCT Bond_Reinforcement_type]
   	set Concrete_confinement [DWLocalGetValue $GDN $STRUCT Bond_Concrete_confinement]
   	set Quality [DWLocalGetValue $GDN $STRUCT Bond_quality]
   	set QualityCEB [DWLocalGetValue $GDN $STRUCT Bond_qualityCEB]

   set n1 [GidConvertValueUnit $BondFcu]
   set n1 [ParserNumberUnit $n1 BondFcuValue BondFcuUnit]
   
   if { $BondFcuUnit == "MPa" } {
   set BondFcuValueMPa [expr 1 * $BondFcuValue]
   } elseif { $BondFcuUnit == "kPa" } {
   set BondFcuValueMPa [expr 0.001 * $BondFcuValue]
   } elseif { $BondFcuUnit == "Pa" } {
   set BondFcuValueMPa [expr 0.000001 * $BondFcuValue] 
   } elseif { $BondFcuUnit == "psi" } {
   set BondFcuValueMPa [expr $BondFcuValue / 145.0377 ]       
   } 

   set n2 [GidConvertValueUnit $BarDiameter]
   set n2 [ParserNumberUnit $n2 BarDiameterValue BarDiameterUnit] 
 
  #WarnWinText "$BondFcu $BondFcuValue $BondFcuUnit -- $BarDiameterValue $BarDiameterUnit - $BondFcuValueMPa "
  #WarnWinText "$BondLawBy"
 
 if { $Generate == "No" || $Generate == "0" || ($Generate == "Yes" && $BondLawBy=="NONE")} {
 } else {
 #WarnWinText $Generate
 
# WarnWinText $BaseMaterial  	
# WarnWinText "Bond material parameters for Class $ClassofReinforcement and Characteristic Yield Strength $CharacteristicYieldStrength and Safety Format $SafetyFormat :"


# $SafetyFormat
  if { $BondLawBy == "Bigaj_1999" } {
    if { $BondFcuValueMPa <60 } {
      set nulaosm 0.8
      if { $Quality == "excelent" } {
         set sd1 0
         set sd2 0.02
         set sd3 0.044
         set sd4 0.48
         set t1 0.5
         set t2 3
         set t3 0.7
         set t4 0
      } elseif { $Quality == "good" } {
         set sd1 0
         set sd2 0.03
         set sd3 0.047
         set sd4 0.48
         set t1 0.5
         set t2 2
         set t3 0.7
         set t4 0    
      } else {
         set sd1 0
         set sd2 0.04
         set sd3 0.047
         set sd4 0.48
         set t1 0.5
         set t2 1
         set t3 0.7
         set t4 0      
      } 
    } else {
        set nulaosm 0.88
        if { $Quality == "excelent" } {
         set sd1 0
         set sd2 0.012
         set sd3 0.03
         set sd4 0.34
         set t1 0.6
         set t2 2.5
         set t3 0.9
         set t4 0
      } elseif { $Quality == "good" } {
         set sd1 0
         set sd2 0.02
         set sd3 0.03
         set sd4 0.34
         set t1 0.6
         set t2 1.9
         set t3 0.9
         set t4 0    
      } else {
         set sd1 0
         set sd2 0.025
         set sd3 0.03
         set sd4 0.34
         set t1 0.6
         set t2 1.1
         set t3 0.9
         set t4 0      
      }
 
    }

      set s1 [expr $sd1 * $BarDiameterValue]
      set s2 [expr $sd2 * $BarDiameterValue]
      set s3 [expr $sd3 * $BarDiameterValue]
      set s4 [expr $sd4 * $BarDiameterValue]
      set t1 [expr $t1 * sqrt($nulaosm * $BondFcuValueMPa)]
      set t2 [expr $t2 * sqrt($nulaosm * $BondFcuValueMPa)]
      set t3 [expr $t3 * sqrt($nulaosm * $BondFcuValueMPa)]
      set t4 [expr $t4 * sqrt($nulaosm * $BondFcuValueMPa)]
      
      set maxBondStrength [format %g%s $t2 "MPa"]
      set on [DWLocalSetValue $GDN $STRUCT Max_Bond_Strength $maxBondStrength] 
      
      set t1 [expr $t1 / $t2]
      set t3 [expr $t3 / $t2]
      set t4 [expr $t4 / $t2]
      set t2 [expr $t2 / $t2]
      
      set s1 [format %10.3g%s $s1 ""]
      set s2 [format %10.3g%s $s2 ""]
      set s3 [format %10.3g%s $s3 ""]
      set s4 [format %10.3g%s $s4 ""]      
      set t1 [format %10.3g%s $t1 ""]
      set t2 [format %10.3g%s $t2 ""]
      set t3 [format %10.3g%s $t3 ""]
      set t4 [format %10.3g%s $t4 ""]
      
      set Function "#N# 8 $s1 $t1 $s2 $t2 $s3 $t3 $s4 $t4"
      set on [DWLocalSetValue $GDN $STRUCT Function_for_Bond_Slip $Function]
      WarnWinText "Function for Bond Slip was updated"  
  
  } elseif { $BondLawBy == "CEB_FIB_model_code_1990" } {

    set BondFcValue [expr $BondFcuValueMPa*0.85]
     
    if { $Reinforcement_type == "ribbed_reinf" } {
       if { $Concrete_confinement == "unconfined" } {
          #  unconfined
          set sd1 0.0006
          set sd2 0.0006
          set alpha 0.4
          if { $QualityCEB == "good" } {
             set sd3 0.001
             set tauMax [expr 2 * sqrt($BondFcValue)]
          } else {
             set sd3 0.0025
             set tauMax [expr 1 * sqrt($BondFcValue)]
          }
          set tauF [expr 0.15 * $tauMax]
       } else {
          #  confined
          set sd1 0.001
          set sd2 0.003
          set sd3 0.01
          set alpha 0.4
          if { $QualityCEB == "good" } {
             set tauMax [expr 2.5 * sqrt($BondFcValue)]
          } else {
             set tauMax [expr 1.25 * sqrt($BondFcValue)]
          }
          set tauF [expr 0.4 * $tauMax]
       }
    } elseif { $Reinforcement_type == "cold_drawn_wire" } {
        set sd1 0.00001
        set sd2 0.00001
        set sd3 0.00001
        set alpha 0.5
        if { $QualityCEB == "good" } {
           set tauMax [expr 0.1 * sqrt($BondFcValue)]
        } else {
           set tauMax [expr 0.05 * sqrt($BondFcValue)]
        }
        set tauF $tauMax
    } elseif { $Reinforcement_type == "hot_rolled_bars" } {
        set sd1 0.0001
        set sd2 0.0001
        set sd3 0.0001
        set alpha 0.5
        if { $QualityCEB == "good" } {
           set tauMax [expr 0.3 * sqrt($BondFcValue)]
        } else {
           set tauMax [expr 0.15 * sqrt($BondFcValue)]
        }
        set tauF $tauMax    
    }
  
      set factorInM 1
      if { $BarDiameterUnit == "in" } { 
      set factorInM 39.3701
      }
      
      #WarnWinText "$BarDiameterUnit - $factorInM"
  
      set s1 0
      set t1 [expr 0.02 * $tauMax]
      
      set s11 [expr 0.01 * $sd1 * $factorInM]
      set s12 [expr 0.025 * $sd1 * $factorInM] 
      set s13 [expr 0.05 * $sd1 * $factorInM]
      set s16 [expr 0.125 * $sd1 * $factorInM]
      set s2 [expr 0.25 * $sd1 * $factorInM]
      set s3 [expr 0.5 * $sd1 * $factorInM]
      set s4 [expr 0.75 * $sd1 * $factorInM] 

      set t11 [expr $tauMax* pow(0.01, $alpha)]
      set t12 [expr $tauMax* pow(0.025, $alpha)]
      set t13 [expr $tauMax* pow(0.05, $alpha)]
      set t16 [expr $tauMax* pow(0.125, $alpha)]      
      set t2 [expr $tauMax* pow(0.25, $alpha)]
      set t3 [expr $tauMax* pow(0.5, $alpha)]
      set t4 [expr $tauMax* pow(0.75, $alpha)]
       
      set s5 [expr $sd1 * $factorInM]
      set s6 [expr $sd2 * $factorInM]
      set s7 [expr $sd3 * $factorInM]
      set t5 $tauMax
      set t6 $tauMax
      set t7 $tauF
      
      set maxBondStrength [format %g%s $tauMax "MPa"]
      set on [DWLocalSetValue $GDN $STRUCT Max_Bond_Strength $maxBondStrength] 
      
      set t1 [expr $t1 / $tauMax]
      set t11 [expr $t11 / $tauMax]
      set t12 [expr $t12 / $tauMax]
      set t13 [expr $t13 / $tauMax]
      set t16 [expr $t16 / $tauMax]
      set t2 [expr $t2 / $tauMax]
      set t3 [expr $t3 / $tauMax]
      set t4 [expr $t4 / $tauMax]
      set t5 1
      set t6 1
      set t7 [expr $t7 / $tauMax]
      
      set s1 [format %10.3g%s $s1 ""]
      set s11 [format %10.3g%s $s11 ""]
      set s12 [format %10.3g%s $s12 ""]
      set s13 [format %10.3g%s $s13 ""]
      set s16 [format %10.3g%s $s16 ""]
      set s2 [format %10.3g%s $s2 ""]
      set s3 [format %10.3g%s $s3 ""]
      set s4 [format %10.3g%s $s4 ""]
      set s5 [format %10.3g%s $s5 ""] 
      set s6 [format %10.3g%s $s6 ""] 
      set s7 [format %10.3g%s $s7 ""]                         
      set t1 [format %10.3g%s $t1 ""]
      set t11 [format %10.3g%s $t11 ""]
      set t12 [format %10.3g%s $t12 ""]
      set t13 [format %10.3g%s $t13 ""]
      set t16 [format %10.3g%s $t16 ""]
      set t2 [format %10.3g%s $t2 ""]
      set t3 [format %10.3g%s $t3 ""]
      set t4 [format %10.3g%s $t4 ""]
      set t5 [format %10.3g%s $t5 ""]
      set t6 [format %10.3g%s $t6 ""]
      set t7 [format %10.3g%s $t7 ""]
      
      set Function "#N# 22 $s1 $t1 $s11 $t11 $s12 $t12 $s13 $t13 $s16 $t16 $s2 $t2 $s3 $t3 $s4 $t4 $s5 $t5 $s6 $t6 $s7 $t7"
      set on [DWLocalSetValue $GDN $STRUCT Function_for_Bond_Slip $Function]  
      WarnWinText "Function for Bond Slip was updated"
  
    #konec fib 1990
  } elseif { $BondLawBy == "CEB_FIB_model_code_2010" } {


    set Bond_failure_mode [DWLocalGetValue $GDN $STRUCT Bond_failure_mode]
    set Cond_Concrete_confinement [DWLocalGetValue $GDN $STRUCT Cond_Concrete_confinement]
    set Ribs_spacing [DWLocalGetValue $GDN $STRUCT Ribs_spacing]
       set n2 [GidConvertValueUnit $Ribs_spacing]
       set n2 [ParserNumberUnit $n2 RibsSpacingValue RibsSpacingUnit] 
       
    set BondFcValue [expr $BondFcuValueMPa*1.0] 
    # we used mean value
    set Reinforcement_type2010 [DWLocalGetValue $GDN $STRUCT Bond_Reinforcement_type2010]

     
    if { $Reinforcement_type2010 == "ribbed_reinf" } {
       if { $Bond_failure_mode == "Splitting" } {
          #  Splitting
          if { $Cond_Concrete_confinement == "unconfined" } {
              if { $QualityCEB == "good" } {
                 set sd1_0 0.001
                 set tauMax_0 [expr 2.5 * sqrt($BondFcValue)]
                 #set tauMax [expr 7 * (($BondFcValue/25)^(0.25))]
                 set fnc0 [expr $BondFcValue/25]
                 set tauMax [expr 7 * [tcl::mathfunc::pow $fnc0 0.25]]
                 set alpha 0.4
                 set fnc1 [expr $tauMax/$tauMax_0]
                 set fnc2 [expr 1/$alpha]
                 set sd1 [expr $sd1_0 * [tcl::mathfunc::pow $fnc1 $fnc2]]
                 set sd2 [expr 1.0 * $sd1]
                 set sd3 [expr 1.2 * $sd1]
                 set tauF 0.0
              } else {
                 set sd1_0 0.0018
                 set tauMax_0 [expr 1.25 * sqrt($BondFcValue)]
                 #set tauMax [expr 5 * (($BondFcValue/25)^(0.25))]
                 set fnc0 [expr $BondFcValue/25]
                 set tauMax [expr 5 * [tcl::mathfunc::pow $fnc0 0.25]]
                 set alpha 0.4
                 set fnc1 [expr $tauMax/$tauMax_0]
                 set fnc2 [expr 1/$alpha]
                 set sd1 [expr $sd1_0 * [tcl::mathfunc::pow $fnc1 $fnc2]]
                 set sd2 [expr 1.0 * $sd1]
                 set sd3 [expr 1.2 * $sd1]
                 set tauF 0.0
              }          
          } elseif { $Cond_Concrete_confinement == "stirrups" } {
              if { $QualityCEB == "good" } {
                 set sd1_0 0.001
                 set tauMax_0 [expr 2.5 * sqrt($BondFcValue)]
                 #set tauMax [expr 8 * (($BondFcValue/25)^(0.25))]
                 set fnc0 [expr $BondFcValue/25]
                 set tauMax [expr 8 * [tcl::mathfunc::pow $fnc0 0.25]]
                 set alpha 0.4
                 set fnc1 [expr $tauMax/$tauMax_0]
                 set fnc2 [expr 1/$alpha]
                 set sd1 [expr $sd1_0 * [tcl::mathfunc::pow $fnc1 $fnc2]]
                 set sd2 [expr 1.0 * $sd1]
                 set sd3 [expr 0.5 * $RibsSpacingValue]
                 set tauF [expr 0.4 * $tauMax]
              } else {
                 set sd1_0 0.0018
                 set tauMax_0 [expr 1.25 * sqrt($BondFcValue)]
                 #set tauMax [expr 5 * (($BondFcValue/25)^(0.25))]
                 set fnc0 [expr $BondFcValue/25]
                 set tauMax [expr 5.5 * [tcl::mathfunc::pow $fnc0 0.25]]
                 set alpha 0.4
                 set fnc1 [expr $tauMax/$tauMax_0]
                 set fnc2 [expr 1/$alpha]
                 set sd1 [expr $sd1_0 * [tcl::mathfunc::pow $fnc1 $fnc2]]
                 set sd2 [expr 1.0 * $sd1]
                 set sd3 [expr 0.5 * $RibsSpacingValue]
                 set tauF [expr 0.4 * $tauMax]
              }           
          } else {
             WarnWinText "Unknown type of Bond_failure_mode"
          }


          
       } elseif { $Bond_failure_mode == "Pull-out" } {
          # Pull-out 
          if { $QualityCEB == "good" } {
             set sd1 0.001
             set sd2 0.002
             set sd3 [expr 1.0 * $RibsSpacingValue]
             set alpha 0.4
             set tauMax [expr 2.5 * sqrt($BondFcValue)]
          } else {
             set sd1 0.0018
             set sd2 0.0036
             set sd3 [expr 1.0 * $RibsSpacingValue]
             set alpha 0.4
             set tauMax [expr 1.25 * sqrt($BondFcValue)]
          }
          set tauF [expr 0.4 * $tauMax]
       } else {
      WarnWinText "Unknown type of Bond_failure_mode"
       }
    } elseif { $Reinforcement_type2010 == "cold_drawn_wire" } {
        set sd1 0.00001
        set sd2 0.00001
        set sd3 0.00001
        set alpha 0.5
        if { $QualityCEB == "good" } {
           set tauMax [expr 0.1 * sqrt($BondFcValue)]
        } else {
           set tauMax [expr 0.05 * sqrt($BondFcValue)]
        }
        set tauF $tauMax
    } elseif { $Reinforcement_type2010 == "hot_rolled_bars" } {
        set sd1 0.0001
        set sd2 0.0001
        set sd3 0.0001
        set alpha 0.5
        if { $QualityCEB == "good" } {
           set tauMax [expr 0.3 * sqrt($BondFcValue)]
        } else {
           set tauMax [expr 0.15 * sqrt($BondFcValue)]
        }
        set tauF $tauMax    
    } else {
      WarnWinText "Unknown type of Reinforcement_type2010"
  }
  
      set factorInM 1
      if { $BarDiameterUnit == "in" } { 
      set factorInM 39.3701
      }
      
      #WarnWinText "$BarDiameterUnit - $factorInM"
  
      set s1 0
      set t1 [expr 0.02 * $tauMax]
      
      set s11 [expr 0.01 * $sd1 * $factorInM]
      set s12 [expr 0.025 * $sd1 * $factorInM] 
      set s13 [expr 0.05 * $sd1 * $factorInM]
      set s16 [expr 0.125 * $sd1 * $factorInM]
      set s2 [expr 0.25 * $sd1 * $factorInM]
      set s3 [expr 0.5 * $sd1 * $factorInM]
      set s4 [expr 0.75 * $sd1 * $factorInM] 

      set t11 [expr $tauMax* pow(0.01, $alpha)]
      set t12 [expr $tauMax* pow(0.025, $alpha)]
      set t13 [expr $tauMax* pow(0.05, $alpha)]
      set t16 [expr $tauMax* pow(0.125, $alpha)]      
      set t2 [expr $tauMax* pow(0.25, $alpha)]
      set t3 [expr $tauMax* pow(0.5, $alpha)]
      set t4 [expr $tauMax* pow(0.75, $alpha)]
       
      set s5 [expr $sd1 * $factorInM]
      set s6 [expr $sd2 * $factorInM]
      set s7 [expr $sd3 * $factorInM]
      set t5 $tauMax
      set t6 $tauMax
      set t7 $tauF
      
      set maxBondStrength [format %g%s $tauMax "MPa"]
      set on [DWLocalSetValue $GDN $STRUCT Max_Bond_Strength $maxBondStrength] 
      
      set t1 [expr $t1 / $tauMax]
      set t11 [expr $t11 / $tauMax]
      set t12 [expr $t12 / $tauMax]
      set t13 [expr $t13 / $tauMax]
      set t16 [expr $t16 / $tauMax]
      set t2 [expr $t2 / $tauMax]
      set t3 [expr $t3 / $tauMax]
      set t4 [expr $t4 / $tauMax]
      set t5 1
      set t6 1
      set t7 [expr $t7 / $tauMax]
      
      set s1 [format %10.3g%s $s1 ""]
      set s11 [format %10.3g%s $s11 ""]
      set s12 [format %10.3g%s $s12 ""]
      set s13 [format %10.3g%s $s13 ""]
      set s16 [format %10.3g%s $s16 ""]
      set s2 [format %10.3g%s $s2 ""]
      set s3 [format %10.3g%s $s3 ""]
      set s4 [format %10.3g%s $s4 ""]
      set s5 [format %10.3g%s $s5 ""] 
      set s6 [format %10.3g%s $s6 ""] 
      set s7 [format %10.3g%s $s7 ""]                         
      set t1 [format %10.3g%s $t1 ""]
      set t11 [format %10.3g%s $t11 ""]
      set t12 [format %10.3g%s $t12 ""]
      set t13 [format %10.3g%s $t13 ""]
      set t16 [format %10.3g%s $t16 ""]
      set t2 [format %10.3g%s $t2 ""]
      set t3 [format %10.3g%s $t3 ""]
      set t4 [format %10.3g%s $t4 ""]
      set t5 [format %10.3g%s $t5 ""]
      set t6 [format %10.3g%s $t6 ""]
      set t7 [format %10.3g%s $t7 ""]
      
      set Function "#N# 22 $s1 $t1 $s11 $t11 $s12 $t12 $s13 $t13 $s16 $t16 $s2 $t2 $s3 $t3 $s4 $t4 $s5 $t5 $s6 $t6 $s7 $t7"
      set on [DWLocalSetValue $GDN $STRUCT Function_for_Bond_Slip $Function]  
      WarnWinText "Function for Bond Slip was updated"
  
    #konec fib 2010
  } else {
      WarnWinText "Unknown type of generation"
  }
    
     set on [DWLocalSetValue $GDN $STRUCT Generate_Material_Bond No]
  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}
