proc TK_GenerateBeamCrosssecton { event args } {
 switch $event {
 INIT {
  # do nothing here
  return ""
 }
 SYNC {
  set GDN [lindex $args 0]
  set STRUCT [lindex $args 1]
  set QUESTION [lindex $args 2]

#  WarnWinText $GDN
#  WarnWinText $STRUCT
#  WarnWinText $QUESTION
#  WarnWinText "TK GenerateEC2Properties Done"
    
  	set Generate [DWLocalGetValue $GDN $STRUCT Generate_Crosssection]

   	set Crossection_Type [DWLocalGetValue $GDN $STRUCT Crossection_Type]
   	set DivH [DWLocalGetValue $GDN $STRUCT Division_h]
   	set DivV [DWLocalGetValue $GDN $STRUCT Division_v]
    set DivV2 [DWLocalGetValue $GDN $STRUCT Division__v]

    set SizeT [DWLocalGetValue $GDN $STRUCT Beam_Ref_Size_t]	
    set n1 [GidConvertValueUnit $SizeT]
    set n1 [ParserNumberUnit $n1 SizeT SizeTUnit]
    set SizeS [DWLocalGetValue $GDN $STRUCT Beam_Ref_Size_s]
    set n1 [GidConvertValueUnit $SizeS]
    set n1 [ParserNumberUnit $n1 SizeS SizeSUnit]
       
    set Th1 [DWLocalGetValue $GDN $STRUCT Thickness_th1]	
    set Th2 [DWLocalGetValue $GDN $STRUCT Thickness_th2]	
    set Tv [DWLocalGetValue $GDN $STRUCT Thickness_tv]	
      
   	set RadiusR [DWLocalGetValue $GDN $STRUCT Radius_R]
    set Th [DWLocalGetValue $GDN $STRUCT Thickness_th]
    set DivC [DWLocalGetValue $GDN $STRUCT Circle_Division]

    set T [DWLocalGetValue $GDN $STRUCT Thickness_t]

 if { $Generate == "No" } {
 } else {
 
# WarnWinText $BaseMaterial  	
set numberOfFibres 0 
set sumaArea 0 
set fibres ""




  if { $Crossection_Type == "O" } {
  
      set mensiRozmer [expr {min($SizeT,$SizeS)}]
      
      #kontroly
      if { [expr (($mensiRozmer/2.0) - $RadiusR)] < 0 } {
         WarnWinText "Error: RadiusR > Size"
         return ""
      }
      if { [expr (($mensiRozmer/2.0) - $Th)] < 0 } {
         WarnWinText "Error: Th2> Size"
         return ""
      } 

         set RadiusRmedium [expr ($RadiusR - ($Th / 2.0))]
         set RadiusRmedium [format %10.3g%s $RadiusRmedium ""]
               
         set delka [expr (2 * 3.1415926535897931 * $RadiusRmedium / $DivC)]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Th * $delka] 
         set area [format %10.5g%s $area ""] 
         
         set deltaAlpha [expr (360.0 / $DivC)]
         set deltaAlpha [format %10.3g%s $deltaAlpha ""]
      
        for {set i 0} {$i < $DivC} {incr i} {
            set alpha [expr ($deltaAlpha * $i)]
            set alpha [format %10.5g%s $alpha ""] 
            set alphaRad [expr (2.0 * 3.1415926535897931 * $alpha / 360.0 )]
            set alphaRad [format %10.6g%s $alphaRad ""] 
            
            set x [expr cos($alphaRad) * $RadiusRmedium ]
            set x [format %10.5g%s $x " "] 
            if { abs($x) < 1e-6 } {
            set x 0 
            set x [format %10.5g%s $x " "] 
            }   
            set y [expr sin($alphaRad) * $RadiusRmedium ]
            set y [format %10.5g%s $y " "] 
            if { abs($y) < 1e-6 } {
            set y 0 
            set y [format %10.5g%s $y " "] 
            }              
            #WarnWinText "$deltaAlpha $alpha $alphaRad: x= $x y= $y"
            append fibres $area " " $x " " $y " " 
            incr numberOfFibres
            set sumaArea [expr $sumaArea + $area] 
        }
    

    
    
    }













































      if { $Crossection_Type == "Rectangle" } {
  
  #kontroly
  if { [expr ($SizeT/2.0)-$T] < 0 } {
     WarnWinText "Error: T ($T) > (SizeT ($SizeT) / 2)"
     return ""
  }
  if { [expr ($SizeS/2.0)-$T] < 0 } {
     WarnWinText "Error: T > (SizeS / 2)"
     return ""
  }     

  
  
  
    set t_top [expr ($SizeT/2.0 )- ($T / 2.0)]
    set t_top [format %10.3g%s $t_top ""]
    
    set s_left [expr ($SizeS/2.0 )- ($T / 2.0)]
    set s_left [format %10.3g%s $s_left ""]
    
    #rohy T1 - T4 
    set area [expr $T * $T] 
    set area [format %10.3g%s $area ""]
    #T1
    set x [expr 1 * $s_left]
    set x [format %10.3g%s $x ""]   
    set y [expr 1 * $t_top]
    set y [format %10.3g%s $y ""]    
    append fibres $area $x $y 
    incr numberOfFibres
    set sumaArea [expr $sumaArea + $area] 
    #T2
    set x [expr -1 * $s_left]
    set x [format %10.3g%s $x ""]   
    set y [expr 1 * $t_top]
    set y [format %10.3g%s $y ""]    
    append fibres $area $x $y 
    incr numberOfFibres
    set sumaArea [expr $sumaArea + $area] 
    #T3
    set x [expr -1 * $s_left]
    set x [format %10.3g%s $x ""]   
    set y [expr -1 * $t_top]
    set y [format %10.3g%s $y ""]    
    append fibres $area $x $y 
    incr numberOfFibres
    set sumaArea [expr $sumaArea + $area]
    #T4
    set x [expr 1 * $s_left]
    set x [format %10.3g%s $x ""]   
    set y [expr -1 * $t_top]
    set y [format %10.3g%s $y ""]    
    append fibres $area $x $y 
    incr numberOfFibres
    set sumaArea [expr $sumaArea + $area]            
    
    
    #vodorovne
    
    if { $DivV2 == "4" } {  
         set delka [expr (($SizeS / 2.0) - $T)]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $T * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set x [expr ($delka / 2.0)]
         set x [format %10.3g%s $x ""] 
         set y [expr 1 * $t_top]
         set y [format %10.3g%s $y ""]             
         #T2
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T3
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]     
         
         set x [expr (-1 * $x)]
         set x [format %10.3g%s $x ""] 
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]             
         #T4
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T5
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]  
     }
     
    if { $DivV2 == "6" } {  
         set delka [expr (($SizeS / 2.0) - $T) / 2.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $T * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set x [expr ($delka / 2.0)]
         set x [format %10.3g%s $x ""] 
         set y [expr 1 * $t_top]
         set y [format %10.3g%s $y ""]             
         #T2
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T3
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]     
         
         set x [expr (-1 * $x)]
         set x [format %10.3g%s $x ""] 
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]             
         #T4
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T5
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]  
         
         set x [expr (-1 * $x) + $delka]
         set x [format %10.3g%s $x ""] 
         set y [expr 1 * $t_top]
         set y [format %10.3g%s $y ""]             
         #T2
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T3
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]     
         
         set x [expr (-1 * $x)]
         set x [format %10.3g%s $x ""] 
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]             
         #T4
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T5
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]    
         
                
     }     
     
    if { $DivV2 == "8" } {  
         set delka [expr (($SizeS / 2.0) - $T) / 3.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $T * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set x [expr ($delka / 2.0)]
         set x [format %10.3g%s $x ""] 
         set y [expr 1 * $t_top]
         set y [format %10.3g%s $y ""]             
         #T2
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T3
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]     
         
         set x [expr (-1 * $x)]
         set x [format %10.3g%s $x ""] 
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]             
         #T4
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T5
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]  
         
         set x [expr (-1 * $x) + $delka]
         set x [format %10.3g%s $x ""] 
         set y [expr 1 * $t_top]
         set y [format %10.3g%s $y ""]             
         #T2
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T3
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]     
         
         set x [expr (-1 * $x)]
         set x [format %10.3g%s $x ""] 
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]             
         #T4
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T5
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]  
         
         set x [expr (-1 * $x) + $delka]
         set x [format %10.3g%s $x ""] 
         set y [expr 1 * $t_top]
         set y [format %10.3g%s $y ""]             
         #T2
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T3
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]     
         
         set x [expr (-1 * $x)]
         set x [format %10.3g%s $x ""] 
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]             
         #T4
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T5
         set y [expr -1 * $y]
         set y [format %10.3g%s $y ""]
         append fibres $area $x $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]             
         
                
     }       
            
     
     
    
 
     #svisle  
     
    if { $DivH == "4" } {  
         set delka [expr ($SizeT/2.0) - $T]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $T * $delka] 
         set area [format %10.3g%s $area ""]  
         #LH         
         set x [expr (-1 * $s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr ($delka / 2)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #LD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]
         #PH         
         set x [expr ($s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr (-1 * $y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #PD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]           
     }   
     
    if { $DivH == "6" } {  
         set delka [expr (($SizeT/2.0) - $T) / 2.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $T * $delka] 
         set area [format %10.3g%s $area ""]  
         #LH         
         set x [expr (-1 * $s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr ($delka / 2)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #LD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]
         #PH         
         set x [expr ($s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr (-1 * $y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #PD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]   
         
         #LH         
         set x [expr (-1 * $s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr ($delka / 2) + $delka]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #LD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]
         #PH         
         set x [expr ($s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr (-1 * $y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #PD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]                  
     }     
     
    if { $DivH == "8" } {  
         set delka [expr (($SizeT/2.0) - $T) / 3.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $T * $delka] 
         set area [format %10.3g%s $area ""]  
         #LH         
         set x [expr (-1 * $s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr ($delka / 2.0)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #LD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]
         #PH         
         set x [expr ($s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr (-1 * $y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #PD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]   
         
         #LH         
         set x [expr (-1 * $s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr (-1 * $y) + $delka]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #LD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]
         #PH         
         set x [expr ($s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr (-1 * $y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #PD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]  
         
         #LH         
         set x [expr (-1 * $s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr (-1 * $y) + $delka]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #LD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]
         #PH         
         set x [expr ($s_left)]
         set x [format %10.3g%s $x ""]
         set y [expr (-1 * $y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #PD         
         set y [expr -1 * ($y)]
         set y [format %10.3g%s $y ""]  
         append fibres $area $x $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]                           
     }        
     
    
  
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  










  if { $Crossection_Type == "I" } {
  
  #kontroly
  if { [expr ($SizeT/2.0)-$Th1] < 0 } {
     WarnWinText "Error: Th1 > (SizeT / 2)"
     return ""
  }
  if { [expr ($SizeT/2.0)-$Th2] < 0 } {
     WarnWinText "Error: Th2 > (SizeT / 2)"
     return ""
  } 
  if { [expr ($SizeS)-$Tv] < 0 } {
     WarnWinText "Error: Tv > SizeS"
     return ""
  }     

  
  
  
    set t_top [expr ($SizeT/2.0 )- ($Th1 / 2.0)]
    set t_top [format %10.3g%s $t_top ""]
    
    set t_down [expr -1 * ( ($SizeT/2.0) - ($Th2 / 2.0) )]
    set t_down [format %10.3g%s $t_down ""]  
    
    #T1
    set area [expr $Th1 * $Tv] 
    set area [format %10.3g%s $area ""]
    
    set nula 0
    set nula [format %10.3g%s $nula ""]
    
    append fibres $area $nula $t_top 
    incr numberOfFibres
    set sumaArea [expr $sumaArea + $area] 
    
    if { $DivV == "3" } {  
         set delka [expr ($SizeS - $Tv) / 2.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Th1 * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set x [expr ($delka / 2.0) + ( $Tv / 2.0)]
         set x [format %10.3g%s $x ""]  
         #T2
         append fibres $area $x $t_top 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #T3
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         
         append fibres $area $x $t_top 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]      
     }
            
    if { $DivV == "5" } {  
         set delka [expr ($SizeS - $Tv) / 4.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Th1 * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set x [expr ($delka / 2.0) + ( $Tv / 2.0)]
         set x [format %10.3g%s $x ""]  
         #T2
         append fibres $area $x $t_top 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #T3
         append fibres $area $x $t_top 
         incr numberOfFibres  
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr (-1*$x) + $delka]
         set x [format %10.3g%s $x ""] 
         #T4
         append fibres $area $x $t_top 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #T5
         append fibres $area $x $t_top 
         incr numberOfFibres  
         set sumaArea [expr $sumaArea + $area]             
     }   
     
    if { $DivV == "7" } {  
         set delka [expr ($SizeS - $Tv) / 6.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Th1 * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set x [expr ($delka / 2.0) + ( $Tv / 2.0)]
         set x [format %10.3g%s $x ""]  
         #T2
         append fibres $area $x $t_top 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #T3
         append fibres $area $x $t_top 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area]   
         
         set x [expr (-1*$x) + $delka]
         set x [format %10.3g%s $x ""] 
         #T4
         append fibres $area $x $t_top 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #T5
         append fibres $area $x $t_top 
         incr numberOfFibres  
         set sumaArea [expr $sumaArea + $area]  
         
         set x [expr (-1*$x) + $delka]
         set x [format %10.3g%s $x ""] 
         #T6
         append fibres $area $x $t_top 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #T7
         append fibres $area $x $t_top 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area]                  
     }      
     
     
     
     #dolni pasnice
     
    #D1
    set area [expr $Th2 * $Tv] 
    set area [format %10.3g%s $area ""]
    
    set nula 0
    set nula [format %10.3g%s $nula ""]
    
    append fibres $area $nula $t_down 
    incr numberOfFibres
    set sumaArea [expr $sumaArea + $area] 
    
    if { $DivV == "3" } {  
         set delka [expr ($SizeS - $Tv) / 2.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Th2 * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set x [expr ($delka / 2.0) + ( $Tv / 2.0)]
         set x [format %10.3g%s $x ""]  
         #D2
         append fibres $area $x $t_down 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         #D3
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         
         append fibres $area $x $t_down 
         incr numberOfFibres    
         set sumaArea [expr $sumaArea + $area]   
     }
            
    if { $DivV == "5" } {  
         set delka [expr ($SizeS - $Tv) / 4.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Th2 * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set x [expr ($delka / 2.0) + ( $Tv / 2.0)]
         set x [format %10.3g%s $x ""]  
         #D2
         append fibres $area $x $t_down 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #D3
         append fibres $area $x $t_down 
         incr numberOfFibres   
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr (-1*$x) + $delka]
         set x [format %10.3g%s $x ""] 
         #D4
         append fibres $area $x $t_down 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #D5
         append fibres $area $x $t_down 
         incr numberOfFibres   
         set sumaArea [expr $sumaArea + $area]            
     }   
     
    if { $DivV == "7" } {  
         set delka [expr ($SizeS - $Tv) / 6.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Th2 * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set x [expr ($delka / 2.0) + ( $Tv / 2.0)]
         set x [format %10.3g%s $x ""]  
         #D2
         append fibres $area $x $t_down 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #D3
         append fibres $area $x $t_down 
         incr numberOfFibres  
         set sumaArea [expr $sumaArea + $area]  
         
         set x [expr (-1*$x) + $delka]
         set x [format %10.3g%s $x ""] 
         #D4
         append fibres $area $x $t_down 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #D5
         append fibres $area $x $t_down 
         incr numberOfFibres   
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr (-1*$x) + $delka]
         set x [format %10.3g%s $x ""] 
         #D6
         append fibres $area $x $t_down 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set x [expr -1 * $x]
         set x [format %10.3g%s $x ""]
         #D7
         append fibres $area $x $t_down 
         incr numberOfFibres    
         set sumaArea [expr $sumaArea + $area]                   
     }     
     
     #pasnice  
     
    if { $DivH == "4" } {  
         set delka [expr ($SizeT/2.0) - $Th1]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Tv * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set y [expr ($delka / 2.0)]
         set y [format %10.3g%s $x ""]  
         #PH
         append fibres $area $nula $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 

         set delka [expr ($SizeT/2.0) - $Th2]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Tv * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set y [expr -1 * ($delka / 2.0)]
         set y [format %10.3g%s $x ""]  
         #PD
         append fibres $area $nula $y 
         incr numberOfFibres     
         set sumaArea [expr $sumaArea + $area] 
     }      
     
    if { $DivH == "6" } {  
         set delka [expr (($SizeT/2.0) - $Th1) / 2.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Tv * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set y [expr ($delka / 2.0)]
         set y [format %10.3g%s $y ""]  
         #PH
         append fibres $area $nula $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set y [expr ($y + $delka)]
         set y [format %10.3g%s $y ""]  
         #PH2
         append fibres $area $nula $y 
         incr numberOfFibres  
         set sumaArea [expr $sumaArea + $area]        

         set delka [expr (($SizeT/2.0) - $Th2) / 2.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Tv * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set y [expr -1 * ($delka / 2.0)]
         set y [format %10.3g%s $y ""]  
         #PD
         append fibres $area $nula $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area] 
         
         set y [expr ($y - $delka)]
         set y [format %10.3g%s $y ""]  
         #PD2
         append fibres $area $nula $y 
         incr numberOfFibres   
         set sumaArea [expr $sumaArea + $area]            
     } 
     
    if { $DivH == "8" } {  
         set delka [expr (($SizeT/2.0) - $Th1) / 3.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Tv * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set y [expr ($delka / 2.0)]
         set y [format %10.3g%s $y ""]  
         #PH
         append fibres $area $nula $y 
         incr numberOfFibres
         set sumaArea [expr $sumaArea + $area] 
         
         set y [expr ($y + $delka)]
         set y [format %10.3g%s $y ""]  
         #PH2
         append fibres $area $nula $y 
         incr numberOfFibres    
         set sumaArea [expr $sumaArea + $area] 
         
         set y [expr ($y + $delka)]
         set y [format %10.3g%s $y ""]  
         #PH3
         append fibres $area $nula $y 
         incr numberOfFibres       
         set sumaArea [expr $sumaArea + $area]          

         set delka [expr (($SizeT/2.0) - $Th2) / 3.0]
         set delka [format %10.3g%s $delka ""] 
         set area [expr $Tv * $delka] 
         set area [format %10.3g%s $area ""]  
         
         set y [expr -1 * ($delka / 2.0)]
         set y [format %10.3g%s $y ""]  
         #PD
         append fibres $area $nula $y 
         incr numberOfFibres 
         set sumaArea [expr $sumaArea + $area] 
         
         set y [expr ($y - $delka)]
         set y [format %10.3g%s $y ""]  
         #PD2
         append fibres $area $nula $y 
         incr numberOfFibres  
         set sumaArea [expr $sumaArea + $area]     
         
         set y [expr ($y - $delka)]
         set y [format %10.3g%s $y ""]  
         #PD3
         append fibres $area $nula $y 
         incr numberOfFibres  
         set sumaArea [expr $sumaArea + $area]                   
     }                  
  
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
    if { $Crossection_Type == "Circle" } {
    
     set DivCircle2 [DWLocalGetValue $GDN $STRUCT CircleDivision]
     set mensiRozmer [expr {min($SizeT,$SizeS)}]
      #kontroly
      if { [expr (($mensiRozmer/2.0) - $RadiusR)] < 0 } {
         WarnWinText "Error: RadiusR > Size"
         return ""
      }    
    
      
        
       if { $DivCircle2 == "5" || $DivCircle2 == "13"} {
      
          if { $DivCircle2 == "5" } {
                set numb_a 4
                set numb_b 0 
                set numb_c 1
            } 
         if { $DivCircle2 == "13" } {
                set numb_a 8
                set numb_b 4 
                set numb_c 1
            } 
      
      #area_center = (radius_m/3)*(radius_m/3)*pi
      set area_center [expr (3.1415926535897931 * $RadiusR/3.0 * $RadiusR/3.0)]
      set area_center [format %10.5g%s $area_center " "]
      set sumaArea 0
     
       if { $numb_c == 1 } {
            #elTypeProxy.AddRecord("SolidCell", 0, 0, area_center, "Material to assign")
            append fibres $area_center " " 0 " " 0 " "
            set sumaArea [expr $sumaArea + $area_center] 
       }     
  
       if { $numb_b > 1 } {
          set pieces [expr 1 * $numb_b ]
          #pieces_int = int(pieces) 
          set area_middle_all [expr ( ($RadiusR/3*2)*($RadiusR/3*2)*3.1415926535897931 ) - $area_center ]
          set area_middle_all_rest [expr  ( ($RadiusR/3*2)*($RadiusR/3*2)*3.1415926535897931 )]
          set area_middle_one [expr $area_middle_all / $pieces] 
            
            
          for {set i 0} {$i < $pieces} {incr i} {
            #set alpha [expr 360.0 / $pieces  * $i]
            set alpharad [expr 2.0 * 3.1415926535897931 / $pieces  * $i]
            #set alpharad [expr radians($alpha)]
            
            set radiusmiddle [expr $RadiusR/2]
            #x = cos (alpharad) * radiusmiddle
            set x [expr cos($alpharad) * $radiusmiddle ] 
            #y = sin (alpharad) * radiusmiddle
            set y [expr sin($alpharad) * $radiusmiddle ]             
            
            if { abs($x) < 1e-6 } {
            set x 0 
            }
            set x [format %10.5g%s $x " "]
            
            if { abs($y) < 1e-6 } {
            set y 0 
            }
            set y [format %10.5g%s $y " "]              
            #elTypeProxy.AddRecord("SolidCell", x, y, area_middle_one, "Material to assign")
            set area_middle_one [format %10.5g%s $area_middle_one " "]
            append fibres $area_middle_one " " $x " " $y " "
            set sumaArea [expr $sumaArea + $area_middle_one]           
          }
        } else {
            set area_middle_all_rest [expr 1.0 * $area_center ]
        }



      #edge
      #pieces = numb_a
      set pieces [expr 1 * $numb_a ]
      #pieces_int = int(pieces)
      set area_edge_all [expr ( ($RadiusR)*($RadiusR)*3.1415926535897931 ) - $area_middle_all_rest ] 
      set area_edge_one [expr $area_edge_all / $pieces]
      
      for {set i 0} {$i < $pieces} {incr i} {
        #set alpha [expr 360.0 / $pieces  * $i]
        #set alpharad [expr radians($alpha)]
        set alpharad [expr 2.0 * 3.1415926535897931 / $pieces  * $i]
        set radiusmiddle [expr $RadiusR/6*5]
        #x = cos (alpharad) * radiusmiddle
        set x [expr cos($alpharad) * $radiusmiddle ] 
        #y = sin (alpharad) * radiusmiddle
        set y [expr sin($alpharad) * $radiusmiddle ]             
        
        if { abs($x) < 1e-6 } {
        set x 0 
        }
        set x [format %10.5g%s $x " "]
        
        if { abs($y) < 1e-6 } {
        set y 0 
        }
        set y [format %10.5g%s $y " "]              
        #elTypeProxy.AddRecord("SolidCell", x, y, area_middle_one, "Material to assign")
        set area_edge_one [format %10.5g%s $area_edge_one " "]
        append fibres $area_edge_one " " $x " " $y " "
         set sumaArea [expr $sumaArea + $area_edge_one]            
      }
 
          for {set i 0} {$i < $DivCircle2} {incr i} {
            incr numberOfFibres
        }
          
       
  }   
        
        
       
        
  
  
  if { $DivCircle2 == "25" } {
      
      


               
         set plochaAll [expr (3.1415926535897931 * $RadiusR * $RadiusR)]
         set area [expr ($plochaAll / 25.0)]
         set area [format %10.3g%s $area ""] 
         
#1 0.0 0.0
            append fibres $area " " 0 " " 0 " " 
#2 0.4000 0.0
            set x [expr 0.4 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.0 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#3 0.2828 0.2828
            set x [expr 0.2828 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.2828 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#4 0.0 0.4000
            set x [expr 0.0 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.4 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#5 -0.2828 0.2828
            set x [expr -0.2828 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.2828 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#6 -0.4000 0.0
            set x [expr -0.4 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.0 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#7 -0.2828 -0.2828
            set x [expr -0.2828 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.2828 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#8 0.0 -0.4000
            set x [expr 0.0 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.4 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#9 0.2828 -0.2828
            set x [expr 0.2828 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.2828 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#10 0.8000 0.0
            set x [expr 0.8 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.0 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#11 0.7391 0.3061
            set x [expr 0.7391 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.3061 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#12 0.5657 0.5657
            set x [expr 0.5657 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.5657 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#13 0.3061 0.7391
            set x [expr 0.3061 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.7391 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#14 0.0 0.8000
            set x [expr 0.0 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.8 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#15 -0.3061 0.7391
            set x [expr -0.3061 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.7391 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#16 -0.5657 0.5657
            set x [expr -0.5657 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.5657 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#17 -0.7391 0.3061
            set x [expr -0.7391 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.3061 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#18 -0.8000 0.0
            set x [expr -0.8 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr 0.0 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#19 -0.7391 -0.3061
            set x [expr -0.7391 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.3061 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#20 -0.5657 -0.5657
            set x [expr -0.5657 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.5657 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#21 -0.3061 -0.7391
            set x [expr -0.3061 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.7391 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#22 0.0 -0.8000
            set x [expr 0.0 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.8 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#23 0.3061 -0.7391
            set x [expr 0.3061 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.7391 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#24 0.5657 -0.5657
            set x [expr 0.5657 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.5657 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 
#25 0.7391 -0.3061 
            set x [expr 0.7391 * $RadiusR ]
            set x [format %10.5g%s $x " "] 
            set y [expr -0.3061 * $RadiusR ]
            set y [format %10.5g%s $y " "] 
            append fibres $area " " $x " " $y " " 


         
        for {set i 0} {$i < 25} {incr i} {
            incr numberOfFibres
            set sumaArea [expr $sumaArea + $area] 
        }
    

    }        
    
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
  
  


      set pocet [expr $numberOfFibres * 3] 
      set Function "#N# "
      append Function "$pocet $fibres" 
      set on [DWLocalSetValue $GDN $STRUCT Fiber_Cords $Function]
        
      set sumaArea [format %10.5g%s $sumaArea ""] 
      WarnWinText "Crosssection generated"
      WarnWinText "------------------------------------"
       WarnWinText "Crosssection type = $Crossection_Type"
      WarnWinText "Total area = $sumaArea"
      WarnWinText "Total fibres = $numberOfFibres"
      WarnWinText "$Function"
     set on [DWLocalSetValue $GDN $STRUCT Generate_Crosssection No]
  
  } 
  return ""
 }
 CLOSE {
  # do nothing here
  return ""
 }
 }
 return ""
}