proc TK_InitVolumeCriteria { zero_UniqueVolumeList 
                             zero_Draw_Each_Iteration 
                             zero_Volume_List 
                             zero_Attribute_List 
                             zero_MinMax_List 
                             zero_Item_At 
                             zero_CheckName 
                             zero_MonitorName 
                             zero_UniqueMonitorName } {
        if { $zero_UniqueVolumeList == 0 } {
                GiD_AccessValue set gendata "UniqueVolumeList"        "#N# 1 -1"
        }
        if { $zero_Draw_Each_Iteration == 0 } {
                GiD_AccessValue set gendata "Draw_Each_Iteration"     "#N# 1 -1"
        }
        if { $zero_Volume_List == 0 } {
                GiD_AccessValue set gendata "VolumeList"              "#N# 1 -1"
        }
        if { $zero_Attribute_List == 0 } {
                GiD_AccessValue set gendata "AttributeList"           "#N# 1 -1"
        }
        if { $zero_MinMax_List == 0 } {
                GiD_AccessValue set gendata "MinMaxList"              "#N# 1 -1"
        }
        if { $zero_Item_At == 0 } {
                GiD_AccessValue set gendata "Item_At"                 "#N# 1 -1"
        }
        if { $zero_CheckName == 0 } {
                GiD_AccessValue set gendata "CheckName"               "#N# 1 -1"
        }
        if { $zero_MonitorName == 0 } {
                GiD_AccessValue set gendata "MonitorName"             "#N# 1 -1"
        }
        if { $zero_UniqueMonitorName == 0 } {
                GiD_AccessValue set gendata "UniqueMonitorName"       "#N# 1 -1"
        }
        return ""
}

proc TK_CreateVolumeArraysCriteriaInfo { 
                                         Data_Attribute 
                                         Global_MM 
                                         Item_At 
                                         Draw_Each_Iteration 
                                         Entity_Number 
                                         CheckName 
                                         MonitorName } {

#       Cond(Data_Attribute) *Cond(Global_MM) *Cond(Item_At,int) *Cond(Draw_Each_Iteration,int) *Cond(Entity_Number,int)
#        set Data_Attribute PRINCIPAL_STRESS
#        set Global_MM MAXIMUM
#        set Entity_Number 1
#        set Draw_Each_Iteration 1
#        set Item_At 1

#N#
#         UniqueVolumeList()
#         Draw_Each_Iteration()
#         VolumeList(List_of_Monitored_Volumes)
#         AttributeList(Data_Attributes)
#         MinMaxList(Minimum_or_Maximum)

        if { $Global_MM == "/*No_extrem_but_all_nodes_currently_in_one_monitor*/"} {
             set Global_MM "/* No_extrem_but_all_nodes_currently_in_one_monitor */"
           }

        set uvl [GiD_AccessValue get gendata     "UniqueVolumeList"   ]
        set al  [GiD_AccessValue get gendata     "AttributeList"      ]
        set mml [GiD_AccessValue get gendata     "MinMaxList"         ]
        set vl  [GiD_AccessValue get gendata     "VolumeList"         ]
        set dei [GiD_AccessValue get gendata     "Draw_Each_Iteration"]
        set at  [GiD_AccessValue get gendata     "Item_At"            ]
        set chn [GiD_AccessValue get gendata     "CheckName"          ]
        set mn  [GiD_AccessValue get gendata     "MonitorName"        ]
        set umn [GiD_AccessValue get gendata     "UniqueMonitorName"  ]

        set NumCells [lindex $vl 1]
        set fval     [lindex $vl 2]
        if { $NumCells == 1 && $fval == -1 } {
                set NumCells 0
        }

#        WarnWinText "uvl=$uvl"
#        WarnWinText "dei=$dei"
#        WarnWinText "al=$al"
#        WarnWinText "mml=$mml"
#        WarnWinText "vl=$vl"
#        WarnWinText "at=$at"

        set compareindex -1
        set volumelist ""
        set monitornamelist ""

        for {set i 2} {$i <= [expr $NumCells+1]} {set i [expr $i+1]} {
                set compareindex 0
                set volumeindex [expr 1 * [lindex $vl $i] ]
                set monitornameindex [lindex $mn $i]
                if { $volumeindex == $Entity_Number } {
                        set attributedata [lindex $al $i]
                        if { $attributedata == $Data_Attribute } {
                                set minmaxglobal [lindex $mml $i]
                                if { $minmaxglobal == $Global_MM } {
                                        set draweachiteration [expr 1 *[lindex $dei $i] ]
                                        if { $draweachiteration == $Draw_Each_Iteration } {
                                                #set compareindex 1
                                                if { $monitornameindex == $MonitorName } {
                                                        set compareindex 1
                                                }                                                
                                        }
                                }
                        }
                }
                lappend volumelist $volumeindex
                lappend monitornamelist $monitornameindex
        }
        lappend volumelist $Entity_Number
        lappend monitornamelist $MonitorName

#        WarnWinText "volumelist=$volumelist"

        if { $compareindex < 1 } {
                set ovl  [AddItem2Array $vl $Entity_Number ]
#                  set size [llength $ovl]
#                  WarnWinText "size = $size"
#                  WarnWinText "ovl=$ovl"
#                  if { $size > 100 } {
#                  WarnWinText "ovl pred=$ovl"                
#                  set ovl [SortHeap $ovl ]
#                  WarnWinText "ovl po=$ovl"                
#                  }
#                WarnWinText "ovl=$ovl"
                GiD_AccessValue set gendata "VolumeList" $ovl

#                WarnWinText "volumelist=$volumelist"
                set uvl [lsort -integer -unique $volumelist]
                set ouvl "#N# [llength $uvl] $uvl"
#                WarnWinText "ouvl=$ouvl"
                GiD_AccessValue set gendata "UniqueVolumeList" $ouvl

                set odei [AddItem2Array $dei $Draw_Each_Iteration ]
#                WarnWinText "odei=$odei"
                GiD_AccessValue set gendata "Draw_Each_Iteration" $odei

                set oal  [AddItem2Array $al $Data_Attribute ]
#                WarnWinText "oal=$oal"
                GiD_AccessValue set gendata "AttributeList" $oal

                set omml [AddItem2Array $mml $Global_MM ]
#                WarnWinText "omml=$omml"
                GiD_AccessValue set gendata "MinMaxList" $omml

                set oat [AddItem2Array $at $Item_At ]
#                WarnWinText "oat=$oat"
                GiD_AccessValue set gendata "Item_At" $oat
                
                set ochn [AddItem2Array $chn $CheckName ]
#                WarnWinText "ochn=$ochn"
                GiD_AccessValue set gendata "CheckName" $ochn

                set omn [AddItem2Array $mn $MonitorName ]
#                WarnWinText "omn=$omn"
#                    set size [llength $omn]
#                    WarnWinText "size = $size"
#    #                WarnWinText "ovl=$ovl"
#                    if { $size > 100 } {
#                    WarnWinText "ovl pred=$ovl"                
#                    set ovl [SortHeapStr $omn ]
#                    WarnWinText "ovl po=$ovl"                
#                    }
                GiD_AccessValue set gendata "MonitorName" $omn
        }                
                set umn [lsort -ascii -unique $monitornamelist]
                set oumn "#N# [llength $umn] $umn"
#                WarnWinText "oumn=$oumn"
                GiD_AccessValue set gendata "UniqueMonitorName" $oumn                

#        WarnWinText "compareindex < 1"
        return ""
}


proc SortHeap { array } {
  set ret ""
  set NumCells [lindex $array 1]
  for {set j 3} {$j <= [expr $NumCells+1]} {set j [expr $j+1]} {
    lappend ret [lindex $array $j]
  }

  set array [lsort -integer -unique $ret]
  set NumCells [llength $array]

  set array "#N# $NumCells $array"

  return $array
}

proc SortHeapStr { array } {
  set ret ""
  set NumCells [lindex $array 1]
  for {set j 3} {$j <= [expr $NumCells+1]} {set j [expr $j+1]} {
    lappend ret [lindex $array $j]
  }

  set array [lsort -ascii -unique $ret]
  set NumCells [llength $array]

  set array "#N# $NumCells $array"

  return $array
}