// Geometry definition for Shell elements.
GEOMETRY ID *matvar 
  Name "ShellGeometry #*matvar as name  *MatProp(0)/*MatProp(Material_Prototype)" 
*If(strcmp(MatProp(Idealisation),"SHELL")==0)
  TYPE "LayeredShell"
*Else
  TYPE "*MatProp(Idealisation)"
*EndIf
*If(MatProp(Define_Local_Axis_Z,Int)==1)
	DETECT_DEPTH DETECT_VECTOR *MatProp(V3x) *MatProp(V3y) *MatProp(V3z)
*Else
	DETECT_DEPTH
*EndIf
*#
*If(strcmp(MatProp(Define_Local_Axis_X),"By_Node_ID")==0)
  REF_V1_IDS *MatProp(V1_Node_1,Int) *MatProp(V1_Node_2,Int)
*ElseIf(strcmp(MatProp(Define_Local_Axis_X),"By_Vector")==0)
  REF_V1_VECTOR *MatProp(V1x,Real) *MatProp(V1y,Real) *MatProp(V1z,Real)
*EndIf
*#
*#If(MatProp(Activate_Ref_Thick,Int)==1)
  REF_THICK *MatProp(Solid_Ref_Thick,Real)
*#EndIf
*#
*If(MatProp(Allow_Shell_Deformation_in_Z,Int)==1)
   INTERFACE "*MatProp(Selection_Name)#*matvar"
*EndIf
*#
   SOLID
*Set Var ShellThickness=MatProp(Solid_Ref_Thick,Real)
*Set Var SolidTHICKNESS=Operation(MatProp(Solid_Ref_Thick,Real)/MatProp(Layers,Real))
*for(i=1;i<=MatProp(Layers,Int);i=i+1)
     LAYER *i  MATERIAL *matvar THICKNESS *SolidTHICKNESS
*End
*Set Var allreinforcement=Operation(MatProp(Reinf_01_Layers,Int)+MatProp(Reinf_02_Layers,Int)+MatProp(Reinf_03_Layers,Int))
*Set Var actuallayer=MatProp(Layers,Int)
*Set Var xyzReinf=Operation(MatProp(Activate_Reinforcement_01,Int)+MatProp(Activate_Reinforcement_02,Int)+MatProp(Activate_Reinforcement_03,Int)+MatProp(Activate_Reinforcement_04,Int))
*#
*If(allreinforcement>0 && xyzReinf>0)
   REINFORCEMENT
*Set Var divis=0
*If(MatProp(Activate_Reinforcement_01,Int)==1)
*If(MatProp(Reinf_01_Calculator,Int)==1)
*Set Var okryti=Operation(MatProp(Reinf_01_Profile,Real)*0.5+MatProp(Reinf_01_Cover,Real))
*#MatProp(Reinf_01_Cover,Real) 
*#MatProp(Reinf_01_Profile,Real)
*#Set Var okryti=tcl(TK_Calculation_cover_and_radius *MatProp(Reinf_01_Cover,Real) *MatProp(Reinf_01_Profile,Real))
*Else
*Set Var okryti=MatProp(Reinf_01_Reinforcement_Distance_From_Surface,Real)
*#Operation(MatProp(Reinf_01_Cover,Real)+sqrt(MatProp(Reinf_01_Area,Real)/3.14159265))
*EndIf
*Set Var EtaPos=Operation(ShellThickness/2.0-okryti)
*#
*If(EtaPos<0.0)
*MessageBox error: Material *MatProp(0) in Reinf_01 has too big Cover
*EndIf
*#
*for(j=1;j<=MatProp(Reinf_01_Layers,Int);j=j+1)
*Set Var divis=divis+1
*#
*If(strcmp(MatProp(Reinf_01_Localization),"Top")==0)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+9) THICKNESS *MatProp(Reinf_01_Area,Real) POSITION *Operation(EtaPos*1.0) DIAMETER *MatProp(Reinf_01_Diameter,Real)
*ElseIf(strcmp(MatProp(Reinf_01_Localization),"Bottom")==0)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+9) THICKNESS *MatProp(Reinf_01_Area,Real) POSITION *Operation(EtaPos*SignMinus) DIAMETER *MatProp(Reinf_01_Diameter,Real)
*ElseIf(strcmp(MatProp(Reinf_01_Localization),"Top_and_Bottom_Both")==0)
*# If(Operation(divis*2)!=j)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+9) THICKNESS *MatProp(Reinf_01_Area,Real) POSITION *Operation(EtaPos*1.0) DIAMETER *MatProp(Reinf_01_Diameter,Real)
*# Else
*Set Var divis=divis+1
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+9) THICKNESS *MatProp(Reinf_01_Area,Real) POSITION *Operation(EtaPos*SignMinus) DIAMETER *MatProp(Reinf_01_Diameter,Real)
*# EndIf
*EndIf
*#
*End
*EndIf
*#
*Set Var actuallayer=Operation(actuallayer+MatProp(Reinf_01_Layers,Int))
*If(MatProp(Reinf_02_Calculator,Int)==1)
*Set Var okryti=Operation(MatProp(Reinf_02_Profile,Real)*0.5+MatProp(Reinf_02_Cover,Real))
*#Set Var okryti=tcl(TK_Calculation_cover_and_radius *MatProp(Reinf_02_Cover,Real) *MatProp(Reinf_02_Profile,Real))
*Else
*Set Var okryti=MatProp(Reinf_02_Reinforcement_Distance_From_Surface,Real)
*#Operation(MatProp(Reinf_02_Cover,Real)+sqrt(MatProp(Reinf_02_Area,Real)/3.14159265))
*EndIf
*Set Var EtaPos=Operation(ShellThickness/2.0-okryti)
*#

*If(MatProp(Activate_Reinforcement_02,Int)==1)
*#
*If(EtaPos<0.0)
*MessageBox error: Material *MatProp(0) in Reinf_02 has too big Cover
*EndIf
*#
*For(j=1;j<=MatProp(Reinf_02_Layers,Int);j=j+1)
*Set Var divis=divis+1
*#
*If(strcmp(MatProp(Reinf_02_Localization),"Top")==0)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+14) THICKNESS *MatProp(Reinf_02_Area,Real) POSITION *Operation(EtaPos*1.0) DIAMETER *MatProp(Reinf_02_Diameter,Real)
*ElseIf(strcmp(MatProp(Reinf_02_Localization),"Bottom")==0)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+14) THICKNESS *MatProp(Reinf_02_Area,Real) POSITION *Operation(EtaPos*SignMinus) DIAMETER *MatProp(Reinf_02_Diameter,Real)
*ElseIf(strcmp(MatProp(Reinf_02_Localization),"Top_and_Bottom_Both")==0)
*# Set Var divis=operation(j/2,Int)
*# If(Operation(divis*2)!=j)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+14) THICKNESS *MatProp(Reinf_02_Area,Real) POSITION *Operation(EtaPos*1.0) DIAMETER *MatProp(Reinf_02_Diameter,Real)
*# Else
*Set Var divis=divis+1
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+14) THICKNESS *MatProp(Reinf_02_Area,Real) POSITION *Operation(EtaPos*SignMinus) DIAMETER *MatProp(Reinf_02_Diameter,Real)
*# EndIf
*EndIf
*#
*End
*EndIf
*#
*Set Var actuallayer=Operation(actuallayer+MatProp(Reinf_02_Layers,Int))
*If(MatProp(Reinf_03_Calculator,Int)==1)
*Set Var okryti=Operation(MatProp(Reinf_03_Profile,Real)*0.5+MatProp(Reinf_03_Cover,Real))
*#Set Var okryti=tcl(TK_Calculation_cover_and_radius *MatProp(Reinf_03_Cover,Real) *MatProp(Reinf_03_Profile,Real))
*Else
*Set Var okryti=MatProp(Reinf_03_Reinforcement_Distance_From_Surface,Real)
*#Operation(MatProp(Reinf_03_Cover,Real)+sqrt(MatProp(Reinf_03_Area,Real)/3.14159265))
*EndIf
*Set Var EtaPos=Operation(ShellThickness/2.0-okryti)
*#
*#
*If(MatProp(Activate_Reinforcement_03,Int)==1)
*#
*If(EtaPos<0.0)
*MessageBox error: Material *MatProp(0) in Reinf_03 has too big Cover
*EndIf
*#
*For(j=1;j<=MatProp(Reinf_03_Layers,Int);j=j+1)
*Set Var divis=divis+1
*If(strcmp(MatProp(Reinf_03_Localization),"Top")==0)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+17) THICKNESS *MatProp(Reinf_03_Area,Real) POSITION *Operation(EtaPos*1.0) DIAMETER *MatProp(Reinf_03_Diameter,Real)
*ElseIf(strcmp(MatProp(Reinf_03_Localization),"Bottom")==0)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+17) THICKNESS *MatProp(Reinf_03_Area,Real) POSITION *Operation(EtaPos*SignMinus) DIAMETER *MatProp(Reinf_03_Diameter,Real)
*ElseIf(strcmp(MatProp(Reinf_03_Localization),"Top_and_Bottom_Both")==0)
*# Set Var divis=operation(j/2,Int)
*# If(Operation(divis*2)!=j)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+17) THICKNESS *MatProp(Reinf_03_Area,Real) POSITION *Operation(EtaPos*1.0) DIAMETER *MatProp(Reinf_03_Diameter,Real)
*# Else
*Set Var divis=divis+1
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+17) THICKNESS *MatProp(Reinf_03_Area,Real) POSITION *Operation(EtaPos*SignMinus) DIAMETER *MatProp(Reinf_03_Diameter,Real)
*# EndIf
*EndIf
*#
*End
*EndIf
*#
*Set Var actuallayer=Operation(actuallayer+MatProp(Reinf_03_Layers,Int))
*If(MatProp(Reinf_04_Calculator,Int)==1)
*Set Var okryti=Operation(MatProp(Reinf_04_Profile,Real)*0.5+MatProp(Reinf_04_Cover,Real))
*#Set Var okryti=tcl(TK_Calculation_cover_and_radius *MatProp(Reinf_04_Cover,Real) *MatProp(Reinf_04_Profile,Real))
*Else
*Set Var okryti=MatProp(Reinf_04_Reinforcement_Distance_From_Surface,Real)
*#Operation(MatProp(Reinf_04_Cover,Real)+sqrt(MatProp(Reinf_04_Area,Real)/3.14159265))
*EndIf
*Set Var EtaPos=Operation(ShellThickness/2.0-okryti)
*#
*#
*If(MatProp(Activate_Reinforcement_04,Int)==1)
*#
*If(EtaPos<0.0)
*MessageBox error: Material *MatProp(0) in Reinf_04 has too big Cover
*EndIf
*#
*For(j=1;j<=MatProp(Reinf_04_Layers,Int);j=j+1)
*Set Var divis=divis+1
*If(strcmp(MatProp(Reinf_04_Localization),"Top")==0)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+20) THICKNESS *MatProp(Reinf_04_Area,Real) POSITION *Operation(EtaPos*1.0) DIAMETER *MatProp(Reinf_04_Diameter,Real)
*ElseIf(strcmp(MatProp(Reinf_04_Localization),"Bottom")==0)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+20) THICKNESS *MatProp(Reinf_04_Area,Real) POSITION *Operation(EtaPos*SignMinus) DIAMETER *MatProp(Reinf_04_Diameter,Real)
*ElseIf(strcmp(MatProp(Reinf_04_Localization),"Top_and_Bottom_Both")==0)
*# Set Var divis=operation(j/2,Int)
*# If(Operation(divis*2)!=j)
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+20) THICKNESS *MatProp(Reinf_04_Area,Real) POSITION *Operation(EtaPos*1.0) DIAMETER *MatProp(Reinf_04_Diameter,Real)
*# Else
*Set Var divis=divis+1
     LAYER *Operation(divis*1,Int)  MATERIAL *Operation(matvar*IncrAdvancedMatID+20) THICKNESS *MatProp(Reinf_04_Area,Real) POSITION *Operation(EtaPos*SignMinus) DIAMETER *MatProp(Reinf_04_Diameter,Real)
*# EndIf
*EndIf
*#
*End
*EndIf
*#
*EndIf
*#
*#
*#
*#
*#
*If(strcmp(MatProp(Element_Type),"CCIsoShellQuad<xxxxxxxx>")==0 || strcmp(MatProp(Element_Type),"CCIsoShellTriangle<xxxxxx>")==0 || strcmp(MatProp(Element_Type),"CCIsoShellQuad<xxxx>")==0 || strcmp(MatProp(Element_Type),"CCIsoShellTriangle<xxx>")==0)
*If(MatProp(Activate_Thickness_Eqn,Int)==1)
  THICKNESS_EQN "*MatProp(Thickness_Eqn)"
*Else
  THICKNESS_EQN "*MatProp(Solid_Ref_Thick)"
*EndIf

*EndIf
