*If(strcmp(MatProp(Geom_Type),"BAR_WITH_BOND")==0 || strcmp(MatProp(Geom_Type),"BAR_WITH_MEMORY_BOND")==0)
*include ..\include.src.bas\Function_BarWithBond.bas

GEOMETRY ID *matvar
  NAME "BarWithBondGeometry #*matvar as name *MatProp(Material_Prototype)"
  TYPE "Cable"
  AREA       *MatProp(Area,Real)
  PERIMETER  *MatProp(Bar_Perimeter,Real)
  BOND_COHESION  1.0
  FRICTION CONSTANT 0.0
  FRICTION COEFFICIENT 0.0
  RADIUS 1e8
  RESET_SLIPS
*If(strcmp(MatProp(Bar_End),"Fixed_START")==0)
  FIXED START
*ElseIf(strcmp(MatProp(Bar_End),"Fixed_END")==0)
  FIXED END
*ElseIf(strcmp(MatProp(Bar_End),"Fixed_BOTH")==0)
  FIXED BOTH
*ElseIf(strcmp(MatProp(Bar_End),"Fixed_NONE")==0)
  // FIXED NONE   
*EndIf
*If(strcmp(MatProp(Geom_Type),"BAR_WITH_BOND")==0 || strcmp(MatProp(Geom_Type),"BAR_WITH_MEMORY_BOND")==0)
  FUNCTION SLIP *Operation(matvar*IncrAdvancedFunID+20)
*If(MatProp(Activate_temperature_dependancy,Int)==1)
  FUNCTION TEMPERATURE *Operation(matvar*IncrAdvancedFunID+21)
*EndIf
*If(MatProp(Activate_corrosion_dependancy,Int)==1)
  FUNCTION CORROSION *Operation(matvar*IncrAdvancedFunID+22)
*EndIf
*If(MatProp(Activate_location_dependancy,Int)==1)
  FUNCTION LOCATION *Operation(matvar*IncrAdvancedFunID+23)
*EndIf  
*EndIf
*If(strcmp(MatProp(Geom_Type),"BAR_WITH_MEMORY_BOND")==0)
  FRICTION UNLOAD COEFFICIENT 0
  SLIP_UNLOAD_COEFF *MatProp(Friction_unload_coefficient,Real)
*EndIf
*ElseIf(strcmp(MatProp(Geom_Type),"INTERNAL_CABLE")==0)
*include ..\include.src.bas\Function_BarWithBond.bas

GEOMETRY ID *matvar
  NAME "BarWithBondGeometry #*matvar as name *MatProp(Material_Prototype)"
  TYPE "Cable"
  AREA                 *MatProp(Area,Real)
  PERIMETER            *MatProp(Bar_Perimeter,Real)
  BOND_COHESION        1.0 
  FRICTION CONSTANT    0.0 
  FRICTION COEFFICIENT *Operation(MatProp(Bond_Friction_Coefficient,Real)/MatProp(Bar_Perimeter,Real))  //  = Bond_Friction_Coefficient *MatProp(Bond_Friction_Coefficient,Real) / Perimetr *MatProp(Bar_Perimeter,Real)    
  RADIUS 1e8
*If(MatProp(Use_Wobble_Coefficient,Int)==1)
  WOBBLE_COEFFICIENT   *Operation(MatProp(Wobble_Coefficient,Real) / MatProp(Bar_Perimeter,Real) * MatProp(Area,Real))  //  = Wobble_Coefficient *MatProp(Wobble_Coefficient,Real) / Perimetr *MatProp(Bar_Perimeter,Real)  ** Area *MatProp(Area,Real)       
*Else
  WOBBLE_COEFFICIENT   0
*EndIf
  RESET_SLIPS
*If(strcmp(MatProp(Bar_End),"Fixed_START")==0)
  FIXED START
*ElseIf(strcmp(MatProp(Bar_End),"Fixed_END")==0)
  FIXED END
*ElseIf(strcmp(MatProp(Bar_End),"Fixed_BOTH")==0)
  FIXED BOTH
*ElseIf(strcmp(MatProp(Bar_End),"Fixed_NONE")==0)
  // FIXED NONE   
*EndIf
  FUNCTION *Operation(matvar*IncrAdvancedFunID+20)
*If(strcmp(MatProp(Geom_Type),"BAR_WITH_MEMORY_BOND")==0)
  FRICTION UNLOAD COEFFICIENT 0
  SLIP_UNLOAD_COEFF *MatProp(Friction_unload_coefficient,Real)
*EndIf
*ElseIf(strcmp(MatProp(Geom_Type),"CABLE")==0)

GEOMETRY ID *matvar
  NAME "CableBondGeometry #*matvar as name *MatProp(Material_Prototype)"
  TYPE "Cable"
  AREA                 *MatProp(Area,Real)
  PERIMETER            *MatProp(Cable_Bar_Perimeter,Real)
  FRICTION CONSTANT    *Operation(MatProp(Cohesion,Real)/MatProp(Cable_Bar_Perimeter,Real))  //  = Cohesion *MatProp(Cohesion,Real) / Cable_Bar_Perimeter *MatProp(Cable_Bar_Perimeter,Real)
  FRICTION COEFFICIENT *Operation(MatProp(Friction,Real)/MatProp(Cable_Bar_Perimeter,Real))  //  = Friction *MatProp(Friction,Real) / Cable_Bar_Perimeter *MatProp(Cable_Bar_Perimeter,Real)  
  RADIUS               *MatProp(Radius,Real)
  BOND_COHESION 0
*If(strcmp(MatProp(Active_Anchor),"START")==0)
  PRESTRESSED START
*ElseIf(strcmp(MatProp(Active_Anchor),"END")==0)
  PRESTRESSED END
*ElseIf(strcmp(MatProp(Active_Anchor),"BOTH")==0)
  PRESTRESSED BOTH
*EndIf
*Else
*# If(strcmp(MatProp(Geom_Type),"NORMAL")==0)

GEOMETRY ID *matvar
  NAME "TrussGeometry #*matvar as name *MatProp(Material_Prototype)"
  TYPE "Truss"
  AREA *MatProp(Area,Real) ;
*EndIf
