// Geometry definition for Beam elements.
GEOMETRY ID *matvar 
  Name "CCBeam3D Geometry #*matvar as name  *MatProp(0)/*MatProp(Material_Prototype)" 
  TYPE "*MatProp(Idealisation)" // "Beam3D"
*#EndIf
*#If(MatProp(Activate_Ref_Height,Int)==1)
*#  REF_HEIGHT *MatProp(Solid_Ref_Height,real)
*#EndIf
*#If(MatProp(Activate_Ref_Width,Int)==1)
*#  REF_WIDTH *MatProp(Solid_Ref_Width,real)
*#EndIf
*If(strcmp(MatProp(Definition_by),"Fiber_Rastr")==0)
*#  ---------------------------------------- rozdeleni jestli je  Fiber_Rastr,Fiber_Cords     = Fiber_Rastr
*#
   SOLID
*Set Var BeamRefHeight=MatProp(Beam_Ref_Size_t,Real)
*Set Var BeamRefWidtht=MatProp(Beam_Ref_Size_s,Real)
*#
*If(strcmp(MatProp(Crossection_Cells),"Cell_Count")==0)
*Set Var SolidHeight=Operation(MatProp(Beam_Ref_Size_t,Real)/MatProp(Cell_Number_in_t,Int))
*Set Var SolidWidth=Operation(MatProp(Beam_Ref_Size_s,Real)/MatProp(Cell_Number_in_s,Int))
	HEIGHTS NUMBER *MatProp(Cell_Number_in_t,Int) VALUES *\
*for(i=1;i<=MatProp(Cell_Number_in_t,Int);i=i+1)
*SolidHeight *\
*End

	WIDTHS NUMBER *MatProp(Cell_Number_in_s,Int) VALUES *\
*for(i=1;i<=MatProp(Cell_Number_in_s,int);i=i+1)
*SolidWidth *\
*End
*Set Var beamCount=Operation(MatProp(Cell_Number_in_t,Int)*MatProp(Cell_Number_in_s,Int))
*ElseIf(strcmp(MatProp(Crossection_Cells),"Cell_Sizes")==0)
*#
*Set Var SolidHeight=Operation(MatProp(Beam_Ref_Size_t,Real)/MatProp(CELL_SIZES_IN_T,int))
*Set Var SolidWidth=Operation(MatProp(Beam_Ref_Size_s,Real)/MatProp(CELL_SIZES_IN_S,int))
*#
	HEIGHTS NUMBER *MatProp(CELL_SIZES_IN_T,int) VALUES *\
*for(i=1;i<=MatProp(CELL_SIZES_IN_T,int);i=i+1)
*MatProp(CELL_SIZES_IN_T,*i,real) *\
*End

*#
	WIDTHS NUMBER *MatProp(CELL_SIZES_IN_S,int) VALUES *\
*for(i=1;i<=MatProp(CELL_SIZES_IN_S,int);i=i+1)
*MatProp(CELL_SIZES_IN_S,*i,Real) *\
*End
*Set Var beamCount=Operation(MatProp(CELL_SIZES_IN_T,Int)*MatProp(CELL_SIZES_IN_S,Int))
*endif
*#

	DOMAINS NUMBER 2
		MATERIAL *Operation(matvar) QUAD_IDS LIST *tcl(TK_WriteBeamGeometryActive *MatProp(0) *beamCount)  
*#		MATERIAL *Operation(matvar) QUAD_IDS LIST *\
*Set Var InactiveCount=MatProp(INACTIVE_CELLS,Int)
*#
*#WarningBox Warning: 1
*#for(bgi=1;bgi<=beamCount;bgi=bgi+1)
*#Set Var checkActivity=1
*#
*#WarningBox Warning: 2
*#for(bgj=1;bgj<=InactiveCount;bgj=bgj+1)
*#Set Var inactiveNum=MatProp(INACTIVE_CELLS,*bgj,Int)
*#If(inactiveNum==bgi)
*#Set Var checkActivity=0
*#EndIf
*#End
*#
*#WarningBox Warning: 3
*#If(checkActivity==1)
*#bgi *\
*#EndIf
*#WarningBox Warning: 4
*#End
		MATERIAL 0 QUAD_IDS LIST *\
*for(j=1;j<=InactiveCount;j=j+1)
*Set Var inactiveNum=MatProp(INACTIVE_CELLS,*j,Int)
*inactiveNum *\
*End

*If(MatProp(Activate_Reinforcement_01,Int)==1)
   REINFORCEMENT
*Set Var BarCount=Operation(MatProp(Reinf_Profiles,int)/4)
*Set Var BarNumbers=0
*for(i=1;i<=BarCount;i=i+1)
*Set Var bindex=Operation(4*i)
*If(MatProp(Reinf_Profiles,*bindex,int)==1)
*Set Var BarNumbers=Operation(BarNumbers+1)
*EndIf
*End
BARS NUMBER *BarNumbers
*#
*for(i=1;i<=BarCount;i=i+1)
*Set Var bindex=Operation(4*i)
*If(MatProp(Reinf_Profiles,*bindex,int)==1)
	MATERIAL *Operation(matvar*IncrAdvancedMatID+9) ST_AREA *MatProp(Reinf_Profiles,*Operation(bindex-3),Real) S_COORD *MatProp(Reinf_Profiles,*Operation(bindex-2),Real) T_COORD *MatProp(Reinf_Profiles,*Operation(bindex-1),Real)
*EndIf
*#
*End
*EndIf

*#  ---------------------------------------- rozdeleni jestli je  Fiber_Rastr,Fiber_Cords        = Fiber_Cords
*Else
*Set Var BarCountSolid=Operation(MatProp(Fiber_Cords,int)/3)
*Set Var BarCount=Operation(MatProp(Reinf_Profiles,int)/4)
*Set Var BarCountReinf=0
*If(MatProp(Activate_Reinforcement_01,Int)==1)
*for(i=1;i<=BarCount;i=i+1)
*Set Var bindex=Operation(4*i)
*If(MatProp(Reinf_Profiles,*bindex,int)==1)
*Set Var BarCountReinf=Operation(BarCountReinf+1)
*EndIf
*End
*EndIf
*#
*Set Var BarNumbers=Operation(BarCountReinf+BarCountSolid)
BARS NUMBER *BarNumbers
*#
   SOLID
*for(i=1;i<=BarCountSolid;i=i+1)
*#
*Set Var bindex=Operation(3*i)
	MATERIAL *Operation(matvar) ST_AREA *MatProp(Fiber_Cords,*Operation(bindex-2),Real) S_COORD *MatProp(Fiber_Cords,*Operation(bindex-1),Real) T_COORD *MatProp(Fiber_Cords,*Operation(bindex),Real) IGNORE_REF_HEIGHT IGNORE_REF_WIDTH
*#
*End
*#

*If(MatProp(Activate_Reinforcement_01,Int)==1)
   REINFORCEMENT
*Set Var BarCount=Operation(MatProp(Reinf_Profiles,int)/4)
*#BARS NUMBER *BarCount
*#
*for(i=1;i<=BarCount;i=i+1)
*Set Var bindex=Operation(4*i)
*If(MatProp(Reinf_Profiles,*bindex,int)==1)
	MATERIAL *Operation(matvar*IncrAdvancedMatID+9) ST_AREA *MatProp(Reinf_Profiles,*Operation(bindex-3),Real) S_COORD *MatProp(Reinf_Profiles,*Operation(bindex-2),Real) T_COORD *MatProp(Reinf_Profiles,*Operation(bindex-1),Real)
*EndIf
*#
*End
*EndIf

*#  ---------------------------------------- rozdeleni jestli je  Fiber_Rastr,Fiber_Cords      end
*EndIf
*If(strcmp(MatProp(Idealisation),"Beam3D")==0)
*If(MatProp(Define_Local_Axes_X_Z,Int)==1)
	DETECT_AXIS DETECT_AXIS_VECTOR *MatProp(V1x) *MatProp(V1y) *MatProp(V1z)
	DETECT_HEIGHT DETECT_HEIGHT_VECTOR *MatProp(V3x) *MatProp(V3y) *MatProp(V3z)
*Else
	DETECT_AXIS
	DETECT_HEIGHT
*EndIf
*EndIf
*If(strcmp(MatProp(Idealisation),"Beam1D")==0)

*If(strcmp(MatProp(Definition_by),"Fiber_Rastr")==0)
*Else
  CS_ISO_WIDTH *MatProp(Beam_Ref_Size_s,Real)
  CS_ISO_HEIGHT *MatProp(Beam_Ref_Size_t,Real)
*EndIf

*If(MatProp(Define_Local_Axes_X_Z,Int)==1)
  CS_WIDTH_EQN "*MatProp(Beam_Ref_Size_s,Real)"
  CS_HEIGHT_EQN "*MatProp(Beam_Ref_Size_t,Real)" 
  VT_X_EQN "*MatProp(V3x)"
  VT_Y_EQN "*MatProp(V3y)"
  VT_Z_EQN "*MatProp(V3z)"
*Else

*EndIf
*EndIf
	NUMBER_OF_IPS_IN_R *MatProp(NUMBER_OF_IPS_IN_R,Int)
