
proc InitGIDProject { dir } {
    
    global GIDDEFAULT
    cd $GIDDEFAULT
    # WarnWinText $GIDDEFAULT
    
#    Debuging_Comm
   foreach filename {Ver_number.tcl TK_Utils.tcl TK_GenerateDruckerPragerProperties.tcl TK_GenerateTransportProperties.tcl TK_GenerateMCConcreteProperties.tcl TK_GenerateEC2Properties.tcl TK_GenerateVariableConcreteProperties.tcl TK_GenerateBondProperties.tcl TK_GenerateFRCProperties.tcl TK_GenerateBeamCrosssecton.tcl MaximalMonitor_for_Surface.tcl MaximalMonitor_for_Volume.tcl TK_Utils_init_problemtypes.tcl} {
        source [file join $dir .. include.src.bas $filename]
    }
    
    
    global NumMenus MenuNames MenuEntries MenuCommands MenuAcceler
    global MenuNamesP MenuEntriesP MenuCommandsP
    global VersionNumber ProgramName ProblemTypePriv 
    global problem_dir
    global GidPriv
    global aptsplash
    set aptsplash 0
    global keepsplash
    set keepsplash 0
    
    DefaultStartValues    

    set ProgramName [_ "GiD+Atena-Transport 2D and 3D Interface"] 
    set VersionRequired "7.7.2b"
    set problem_dir $dir
    set comp -1
    catch {
       set comp [GiDVersionCmp $VersionRequired]
    }
    if {$comp < 0 } {
       WarnWin "This interface requires GiD $VersionRequired or later"
       return
    }

    Splash $dir
    set aptsplash $dir
    Atena_Menu $dir

    AtenaPreBitmaps $dir 
    AtenaPostBitmaps $dir    
    set GidPriv(ProgName) $ProgramName
    ChangeWindowTitle  

    GidShowBook gendata GiD-Atena_Hidden_System_Data 0
#    UpdateMenus
   set comp -1
   catch {
       set comp [GiDVersionCmp "17.0.0"]
   }
   if {$comp < 0 } {
     #WarnWin "This A"
   } else {
     #WarnWin "This B"
        GiD_Set DetachMeshFromGeometry 1
        # Enrique  24.1.2025
   } 
}

proc ChangedLanguage { newlan } {
  global problem_dir    
  Atena_Menu $problem_dir
  AtenaPreBitmaps $problem_dir
  AtenaPostBitmaps $problem_dir    
} 


proc TK_DEPEND_Generate_Transport_Material { event args } {
   switch $event {
	 DEPEND {
	  #WarnWinText "DEPEND"
    set GDN [lindex $args 0]
    set STRUCT [lindex $args 1]
    set QUESTION [lindex $args 2]   

     set Type_of_material [DWLocalGetValue $GDN $STRUCT "Type_of_material"]
     set Type_of_analysis [DWLocalGetValue $GDN $STRUCT "Type_of_analysis"]    
     
     #WarnWinText "------------------------------------"
     #WarnWinText "Type_of_material = $Type_of_material"
     #WarnWinText "Type_of_analysis = $Type_of_analysis"
     
     #YOUNG_CONCRETE,CONCRETE,CONCRETE_AT_HIGH_TEMPERATURE,,,,,HPFRC_CONCRETE_AT_HIGH_TEMPERATURE)

     set on [DWLocalSetValue $GDN $STRUCT "Type_of_analysis" [DWLocalGetValue $GDN $STRUCT "Type_of_analysis"] "normal"]
     set on [DWLocalSetValue $GDN $STRUCT "Type_of_conductivity" [DWLocalGetValue $GDN $STRUCT "Type_of_conductivity"] "hidden"] 
     set on [DWLocalSetValue $GDN $STRUCT "Mean_Compressive_Strength" [DWLocalGetValue $GDN $STRUCT "Mean_Compressive_Strength"] "hidden"]
     set on [DWLocalSetValue $GDN $STRUCT "Starting_age" [DWLocalGetValue $GDN $STRUCT "Starting_age"] "hidden"]
     set on [DWLocalSetValue $GDN $STRUCT "Cement_Type" [DWLocalGetValue $GDN $STRUCT "Cement_Type"] "hidden"]
     set on [DWLocalSetValue $GDN $STRUCT "Mass_of_fibres" [DWLocalGetValue $GDN $STRUCT "Mass_of_fibres"] "hidden"]
     set on [DWLocalSetValue $GDN $STRUCT "Density_of_concrete_without_fibers" [DWLocalGetValue $GDN $STRUCT "Density_of_concrete_without_fibers"] "hidden"]
     set on [DWLocalSetValue $GDN $STRUCT "Density_of_concrete" [DWLocalGetValue $GDN $STRUCT "Density_of_concrete"] "hidden"]
     set on [DWLocalSetValue $GDN $STRUCT "Water/Cement_Ratio" [DWLocalGetValue $GDN $STRUCT "Water/Cement_Ratio"] "hidden"]
     set on [DWLocalSetValue $GDN $STRUCT "Mass_of_aggregate" [DWLocalGetValue $GDN $STRUCT "Mass_of_aggregate"] "hidden"]
     
     
        if { $Type_of_material == "YOUNG_CONCRETE" } {
                  if { $Type_of_analysis == "TEMPERATURE" || $Type_of_analysis == "TEMPERATURE_AND_MOISTURE"} {
                           set on [DWLocalSetValue $GDN $STRUCT "Starting_age" [DWLocalGetValue $GDN $STRUCT "Starting_age"] "normal"]
                  } 
                  if { $Type_of_analysis == "MOISTURE" || $Type_of_analysis == "TEMPERATURE_AND_MOISTURE"} {
                           set on [DWLocalSetValue $GDN $STRUCT "Mean_Compressive_Strength" [DWLocalGetValue $GDN $STRUCT "Mean_Compressive_Strength"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Starting_age" [DWLocalGetValue $GDN $STRUCT "Starting_age"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Cement_Type" [DWLocalGetValue $GDN $STRUCT "Cement_Type"] "normal"]
                  }
          } elseif { $Type_of_material == "CONCRETE" } {
                  if { $Type_of_analysis == "TEMPERATURE" || $Type_of_analysis == "TEMPERATURE_AND_MOISTURE"} {

                  } 
                  if { $Type_of_analysis == "MOISTURE" || $Type_of_analysis == "TEMPERATURE_AND_MOISTURE"} {
                           set on [DWLocalSetValue $GDN $STRUCT "Mean_Compressive_Strength" [DWLocalGetValue $GDN $STRUCT "Mean_Compressive_Strength"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Mass_of_aggregate" [DWLocalGetValue $GDN $STRUCT "Mass_of_aggregate"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Density_of_concrete" [DWLocalGetValue $GDN $STRUCT "Density_of_concrete"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Cement_Type" [DWLocalGetValue $GDN $STRUCT "Cement_Type"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Water/Cement_Ratio" [DWLocalGetValue $GDN $STRUCT "Water/Cement_Ratio"] "normal"]
                  }          
          } elseif { $Type_of_material == "CONCRETE_AT_HIGH_TEMPERATURE" } {
                          set on [DWLocalSetValue $GDN $STRUCT "Type_of_analysis" "TEMPERATURE" "disabled"]
                          set on [DWLocalSetValue $GDN $STRUCT "Type_of_conductivity" [DWLocalGetValue $GDN $STRUCT "Type_of_conductivity"] "normal"]
          
          } elseif { $Type_of_material == "STEEL" } {
          
          } elseif { $Type_of_material == "MASONRY" } {
          
          } elseif { $Type_of_material == "HPFRC_YOUNG_CONCRETE" } {
          
          } elseif { $Type_of_material == "HPFRC_CONCRETE" } {
                  if { $Type_of_analysis == "TEMPERATURE" || $Type_of_analysis == "TEMPERATURE_AND_MOISTURE"} {
                          set on [DWLocalSetValue $GDN $STRUCT "Mass_of_fibres" [DWLocalGetValue $GDN $STRUCT "Mass_of_fibres"] "normal"]
                          set on [DWLocalSetValue $GDN $STRUCT "Density_of_concrete_without_fibers" [DWLocalGetValue $GDN $STRUCT "Density_of_concrete_without_fibers"] "normal"]
                  } 
                  if { $Type_of_analysis == "MOISTURE" || $Type_of_analysis == "TEMPERATURE_AND_MOISTURE"} {
                           set on [DWLocalSetValue $GDN $STRUCT "Mean_Compressive_Strength" [DWLocalGetValue $GDN $STRUCT "Mean_Compressive_Strength"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Mass_of_aggregate" [DWLocalGetValue $GDN $STRUCT "Mass_of_aggregate"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Mass_of_fibres" [DWLocalGetValue $GDN $STRUCT "Mass_of_fibres"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Density_of_concrete_without_fibers" [DWLocalGetValue $GDN $STRUCT "Density_of_concrete_without_fibers"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Cement_Type" [DWLocalGetValue $GDN $STRUCT "Cement_Type"] "normal"]
                           set on [DWLocalSetValue $GDN $STRUCT "Water/Cement_Ratio" [DWLocalGetValue $GDN $STRUCT "Water/Cement_Ratio"] "normal"]
                  }            


          } elseif { $Type_of_material == "HPFRC_CONCRETE_AT_HIGH_TEMPERATURE" } {
                          set on [DWLocalSetValue $GDN $STRUCT "Type_of_analysis" "TEMPERATURE" "disabled"]
                          set on [DWLocalSetValue $GDN $STRUCT "Type_of_conductivity" [DWLocalGetValue $GDN $STRUCT "Type_of_conductivity"] "normal"] 
          
          }
         #  normal / hidden  / disabled
    return ""
	 }
   }
   return ""
}


# Pre Toolbar
proc AtenaPreBitmaps { dir { type "DEFAULT INSIDELEFT"} } {
    global AtenaPreBitmapsNames AtenaPreBitmapsCommands AtenaPreBitmapsHelp ProgramName ProblemTypePriv

    set AtenaPreBitmapsNames(0) {linka_stat.gif options.gif linka_stat.gif temperatura.gif
        show_mat.gif linka_stat.gif constraints.gif constraints_view.gif linka_stat.gif
        stopky.gif stopky_sipka.gif linka_stat.gif calc_transport.gif linka_stat.gif logoV4-transport.gif}
              
    set AtenaPreBitmapsCommands(0) [list\
            "" [list -np- GidOpenProblemData Problem_Data] "" \
            [list -np- GidOpenMaterials SOLID_Material] \
            [list -np- GiD_Process Mescape Data Materials DrawMaterial -DrawAll-] "" \
            "Data Conditions CondWindow"\
            [list -np- GiD_Process MEscape Data Conditions DrawCond -DrawAll-] ""  \
            "Data IDataWindow" \
            [list -np- GiD_Process MEscape Data Intervals ChangeInterval] ""  \
            "Utilities Calculate"  "" \
            "-np- VisitWeb http://www.cervenka.cz/downloads"]
            
	    
    set AtenaPreBitmapsHelp(0) {
            "" "Define global Problem Data" ""  \
            "Define SOLID Concrete material" \
            "Draw all materials" ""  \
            "Define boundary conditions ... Loads & Supports" \
            "Draw all boundary conditions ... Loads & Supports" ""  \
            "Define interval solution parameters ... Interval Data" \
            "Go to interval number..." ""  \
            "Start ATENA transport analysis" ""  \
            "http://www.cervenka.cz/downloads" }
            	    

    set prefix Pre
    set images_path [file normalize [file join $dir .. images]]
    set name AtenaPreBar
    set ProblemTypePriv(pretoolbarwin) [CreateOtherBitmaps $name "Atena Pre-Processor toolbar" \
	    AtenaPreBitmapsNames AtenaPreBitmapsCommands \
	    AtenaPreBitmapsHelp $images_path [list AtenaPreBitmaps $images_path] $type $prefix]
    AddNewToolbar "$ProgramName prebar" ${prefix}${name}WindowGeom [list AtenaPreBitmaps $images_path]
}

# Post Toolbar
proc AtenaPostBitmaps { dir { type "DEFAULT INSIDELEFT"} } {
    global AtenaPostBitmapsNames AtenaPostBitmapsCommands AtenaPostBitmapsHelp ProgramName ProblemTypePriv

    set AtenaPostBitmapsNames(0) {linka_stat.gif options.gif importa2g.gif linka_stat.gif
        ReadGidResults.gif linka_stat.gif logoV4-transport.gif}

    set AtenaPostBitmapsCommands(0) [list\
            "" [list -np- OptionPost]\
            [list -np- InitA2G] "" \
            [list -np- ReadResults] "" \
            "-np- VisitWeb http://www.cervenka.cz/downloads" ]

    set AtenaPostBitmapsHelp(0) {
            "" "Define global Post Data" \
            "Import results from AtenaWIN" "" \
            "Read results from GiD" "" \
            "http://www.cervenka.cz/downloads" }

    set prefix Post
    set images_path [file normalize [file join $dir .. images]]
    set name AtenaPostBar
    set ProblemTypePriv(posttoolbarwin) [CreateOtherBitmaps $name "Atena Post-Processor toolbar" \
            AtenaPostBitmapsNames AtenaPostBitmapsCommands \
            AtenaPostBitmapsHelp $images_path [list AtenaPostBitmaps $images_path] $type $prefix]
    AddNewToolbar "$ProgramName postbar" ${prefix}${name}WindowGeom [list AtenaPostBitmaps $images_path]
}




