
proc InitGIDProject { dir } {

    global GIDDEFAULT
    cd $GIDDEFAULT
    # WarnWinText $GIDDEFAULT
                                                                                                                                      
#    Debuging_Comm
   foreach filename {Ver_number.tcl TK_Utils.tcl TK_GenerateDruckerPragerProperties.tcl TK_GenerateMCConcreteProperties.tcl TK_GenerateEC2Properties.tcl TK_GenerateVariableConcreteProperties.tcl TK_GenerateBondProperties.tcl TK_GenerateFRCProperties.tcl TK_GenerateBeamCrosssecton.tcl MaximalMonitor_for_Surface.tcl MaximalMonitor_for_Volume.tcl TK_Utils_init_problemtypes.tcl} {
        source [file join $dir .. include.src.bas $filename]
    }

    global NumMenus MenuNames MenuEntries MenuCommands MenuAcceler
    global MenuNamesP MenuEntriesP MenuCommandsP
    global VersionNumber ProgramName ProblemTypePriv
    global problem_dir
    global GidPriv
    global aptsplash
    set aptsplash 0
    global keepsplash
    set keepsplash 0    

    DefaultStartValues

    set ProgramName [_ "GiD+Atena-Static 2D and 3D Interface"]
    set VersionRequired "7.7.2b"
    set problem_dir $dir
    set comp -1
    catch {
       set comp [GiDVersionCmp $VersionRequired]
    }
    if { $comp < 0 } {
       WarnWin "This interface requires GiD $VersionRequired or later"
       return
    }
   
    Splash $dir
    set aptsplash $dir
    Atena_Menu $dir

    AtenaPreBitmaps $dir
    AtenaPostBitmaps $dir
    
    set GidPriv(ProgName) $ProgramName
    ChangeWindowTitle

    GidShowBook gendata GiD-Atena_Hidden_System_Data 0
#    UpdateMenus
    
   set comp -1
   catch {
       set comp [GiDVersionCmp "17.0.0"]
   }
   if {$comp < 0 } {
     #WarnWin "This A"
   } else {
     #WarnWin "This B"
        GiD_Set DetachMeshFromGeometry 1
        # Enrique  24.1.2025
   }    
}

proc ChangedLanguage { newlan } {
  global problem_dir    
  Atena_Menu $problem_dir
  AtenaPreBitmaps $problem_dir
  AtenaPostBitmaps $problem_dir    
} 

proc getMaterialNameByMaterialNumber { ElemsMat } {
        return "CC3DNonLinCementitious2"
}

proc CurrentElementType { ElemsMat ElemsType ElemsNnode AddingGapElemID AddingNonLinElemID} {

        set matName "CC3DNonLinCementitious2"
        # [getMaterialNameByMaterialNumber ElemsMat ]

        set Mat_Prototype      [GiD_AccessValue get materials $matName "Material_Prototype"]
        set Geom_Non-Linearity [GiD_AccessValue get materials $matName "Geometrical_Non-Linearity"]

        set CurrentType -1

        if  { $Geom_Non-Linearity == "LINEAR" && $Mat_Prototype == "CC3DInterface" || $Mat_Prototype == "CC2DInterface" } {
                set CurrentType [expr $ElemsNnode+$AddingGapElemID]
        } elseif { $Geom_Non-Linearity == "NONLINEAR" && $Mat_Prototype == "CC3DInterface" || $Mat_Prototype == "CC2DInterface" } {
                set CurrentType [expr $ElemsNnode+$AddingGapElemID+$AddingNonLinElemID]
        } elseif { $Geom_Non-Linearity == "LINEAR" && $Mat_Prototype == "CCShellMaterial" } {
                set CurrentType 16
        } elseif { $Geom_Non-Linearity == "NONLINEAR" && $Mat_Prototype == "CCShellMaterial" } {
                set CurrentType [expr 16+$AddingNonLinElemID]
                WarnWinText "WARNING: Element type Shell is not supported Geometrical-NONLINEAR"
        } elseif { $Geom_Non-Linearity == "LINEAR" && $Mat_Prototype != "CC3DInterface" && $Mat_Prototype != "CC2DInterface" } {
                set CurrentType [expr $ElemsNnode*1]
        } elseif { $Geom_Non-Linearity == "NONLINEAR" && $Mat_Prototype != "CC3DInterface" && $Mat_Prototype != "CC2DInterface" } {
                set CurrentType [expr $ElemsNnode+$AddingNonLinElemID]
        }
        return $CurrentType
}


proc EndGiDPostprocess {} {
     AtenaPreBitmaps
}

# Pre Toolbar
proc AtenaPreBitmaps { dir { type "DEFAULT INSIDELEFT" } } {
    global AtenaPreBitmapsNames AtenaPreBitmapsCommands AtenaPreBitmapsHelp ProgramName ProblemTypePriv

    set AtenaPreBitmapsNames(0) { 
        linka_stat.gif options.gif linka_stat.gif concrete.gif shell.gif
        beam.gif reinf.gif icko.gif show_mat.gif linka_stat.gif constraints.gif
        constraints_view.gif linka_stat.gif stopky.gif stopky_sipka.gif linka_stat.gif
        calc_stat.gif linka_stat.gif logoV4-static.gif 
    }
    

    set AtenaPreBitmapsCommands(0) [list\
            "" [list -np- GidOpenProblemData Problem_Data] "" \
            [list -np- GidOpenMaterials SOLID_Concrete]\
            [list -np- GidOpenMaterials SHELL_Concrete-Steel]\
            [list -np- GidOpenMaterials BEAM_Concrete]\
            [list -np- GidOpenMaterials 1D_Reinforcement]\
            [list -np- GidOpenMaterials SOLID_Steel] \
            [list -np- GiD_Process Mescape Data Materials DrawMaterial -DrawAll-] "" \
            "Data Conditions CondWindow"\
            [list -np- GiD_Process Mescape Data Conditions DrawCond -DrawAll-] ""  \
            "Data IDataWindow" \
            [list -np- GiD_Process Mescape Data Intervals ChangeInterval] "" \
            "Utilities Calculate"  "" \
            "-np- VisitWeb http://www.cervenka.cz/downloads"]

    set AtenaPreBitmapsHelp(0) {
            "" "Define global Problem Data" ""  \
            "Define SOLID Concrete material"\
            "Define SHELL material"\
            "Define BEAM material"\
            "Define Reinforcement material"\
            "Define SOLID Steel material"\
            "Draw all materials" ""\
            "Define boundary conditions ... Loads & Supports"\
            "Draw all boundary conditions ... Loads & Supports" "" \
            "Define interval solution parameters ... Interval Data" \
            "Go to interval number..." "" \
            "Start ATENA static analysis" "" \
            "http://www.cervenka.cz/downloads" }

    set prefix Pre
    set images_path [file normalize [file join $dir .. images]]
    set name AtenaPreBar
    set ProblemTypePriv(pretoolbarwin) [CreateOtherBitmaps $name "Atena Pre-Processor toolbar" \
            AtenaPreBitmapsNames AtenaPreBitmapsCommands \
            AtenaPreBitmapsHelp $images_path [list AtenaPreBitmaps $images_path] $type $prefix]
    AddNewToolbar "$ProgramName prebar" ${prefix}${name}WindowGeom [list AtenaPreBitmaps $images_path]
}

# Post Toolbar
proc AtenaPostBitmaps { dir { type "DEFAULT INSIDELEFT"} } {
    global AtenaPostBitmapsNames AtenaPostBitmapsCommands AtenaPostBitmapsHelp ProgramName ProblemTypePriv

    set AtenaPostBitmapsNames(0) {linka_stat.gif options.gif importa2g.gif linka_stat.gif ReadGidResults.gif linka_stat.gif logoV4-static.gif}

    set AtenaPostBitmapsCommands(0) [list\
            "" [list -np- OptionPost]\
            [list -np- InitA2G] "" \
            [list -np- ReadResults] "" \
            "-np- VisitWeb http://www.cervenka.cz/downloads" ]

    set AtenaPostBitmapsHelp(0) {
            "" "Define global Post Data" \
            "Import results from AtenaWIN" "" \
            "Read results from GiD" "" \
            "http://www.cervenka.cz/downloads" }

    set prefix Post
    set images_path [file normalize [file join $dir .. images]]
    set name AtenaPostBar
    set ProblemTypePriv(posttoolbarwin) [CreateOtherBitmaps $name "Atena Post-Processor toolbar" \
            AtenaPostBitmapsNames AtenaPostBitmapsCommands \
            AtenaPostBitmapsHelp $images_path [list AtenaPostBitmaps $images_path] $type $prefix]
    AddNewToolbar "$ProgramName postbar" ${prefix}${name}WindowGeom [list AtenaPostBitmaps $images_path]
}




