*include ..\include.src.bas\Ver.bas
*tcl(TK_CleanMaterialNumberVSGroupID)
*tcl(TK_CleanMinMaxGroupIDVSMaterial)

*#If(ndime==2)
*#WarningBox Info: For exporting Transport 2D & 2D Axisymetry & 3D modeling.
*#EndIf

*include ..\include.src.bas\RestoreFrom.bas

// --------------------------
//  This is a TRANSPORT task 
// --------------------------
MODULE TYPE "CCStructuresTransport" CHECK
TASK name "*GenData(TaskName)"

*Set Var Axisym=0
*If(ndime==2 && GenData(Axi_symmetric_task,Int)==1)
*Set Var Axisym=1
*EndIf
*#
Title "*GenData(Title)"
*If(Axisym==1)
 space axisymmetric
*Else
 dimension  *ndime
*EndIf

*If(nmats(Int)==0)
*MessageBox error: You don't have assigned Materials
*EndIf

*# // zapis jednotek
*include ..\include.src.bas\WriteUnits.bas

*Set Var DefaultSpace=3
*include ..\include.src.bas\initialVariablesSetting.bas
*include ..\include.src.bas\Materials.bas
*Set Var AddTranspAnalysis=60

*include ..\include.src.bas\WriteJoints.bas

*loop materials
*If(strcmp(MatProp(Material_Prototype),"CCModelBaXi94")==0 || strcmp(MatProp(Material_Prototype),"CCSandwicKubinaCombinedMaterial")==0 || strcmp(MatProp(Material_Prototype),"CCSandwicKubina")==0)
*#Format "%i"
SELECTION "$N$Mat*MatNum" LIST /** *MatProp(0) **/ *tcl(NodesWithMaterial *MatProp(0)) ;

*#Format "%i"
 NODAL SETTING SELECTION "$N$Mat*MatNum"
      GENERATE_TYPE *MatNum(Int)
   CONST *MatProp(Temperature_CONST,real)	COEFF_X *MatProp(Temperature_COEFF_X,real)	COEFF_Y *MatProp(Temperature_COEFF_Y,real)	COEFF_Z *MatProp(Temperature_COEFF_Z,real)	GENERATE_TEMP
*If(strcmp(MatProp(Initial_Water_State),"Humidity")==0)
   CONST *MatProp(Humidity_CONST,real)	COEFF_X *MatProp(Humidity_COEFF_X,real)	COEFF_Y *MatProp(Humidity_COEFF_Y,real)	COEFF_Z *MatProp(Humidity_COEFF_Z,real)	GENERATE_H
*Else
*# If(strcmp(MatProp(Initial_Water_State),"Moisture")==0)
   CONST *MatProp(Moisture_Content_CONST,real)	COEFF_X *MatProp(Moisture_Content_COEFF_X,real)	COEFF_Y *MatProp(Moisture_Content_COEFF_Y,real)	COEFF_Z *MatProp(Moisture_Content_COEFF_Z,real)	GENERATE_W
*endif   
   ;
*ElseIf(strcmp(MatProp(Material_Prototype),"CCTransportMaterial")==0 || strcmp(MatProp(Material_Prototype),"CCTransportMaterialLevel7")==0 )   
*#Format "%i"
SELECTION "$N$Mat*MatNum" LIST /** *MatProp(0) **/ *tcl(NodesWithMaterial *MatProp(0)) ;

*#Format "%i"
 NODAL SETTING SELECTION "$N$Mat*MatNum"
      GENERATE_TYPE *MatNum(Int)
   CONST *MatProp(Temperature_CONST,real)	COEFF_X *MatProp(Temperature_COEFF_X,real)	COEFF_Y *MatProp(Temperature_COEFF_Y,real)	COEFF_Z *MatProp(Temperature_COEFF_Z,real)	GENERATE_TEMP
   CONST *MatProp(Humidity_CONST,real)	COEFF_X *MatProp(Humidity_COEFF_X,real)	COEFF_Y *MatProp(Humidity_COEFF_Y,real)	COEFF_Z *MatProp(Humidity_COEFF_Z,real)	GENERATE_H
   ;   
*EndIf
*End materials
*#
*Set elems(All)
*#
*Set Var CurrentType=-1
*Set Var PreviousType=0
*Set Var PreviousIndex=0
*Set Var warnQuadHex=0
*Set Var warnQuadTetra=0
*Set Var warnShell=0
*# Set Var oMaxIndexElemGroups=0
*# Set Var oMinIndexElemGroups=90000
*Set Var groupID=-1
*Set Var ElemConstrActiv=0
*Set Var oldElemsMat=0
*#
// Element group definition
*Set Var nshells=0
*Set Var nbeam=0
*loop elems
*If(elemsmat==SignMinus || elemsmat==0)

ElemsNum    *ElemsNum *ElemsConec
ElemsMat    *ElemsMat
CurrentType *CurrentType
ElemsType *ElemsType
ElemsNnode *ElemsNnode

*tcl(TK_Signal *ElemsNum)
// ERROR: You don't have assigned Material *ElemsMat at Element *ElemsNum For first number of unassigned element
*tcl(TK_VypisMessageBox *ElemsMat *ElemsNum)
*EndIf
*#If(ElemsType!=1)
*# 	1=Linear, toto je samostatna podminka, ze se nebudou Vypisovat Trussove prvky
*Set Var MaterialType=0
*#
*include ..\include.src.bas\InLoopElementCheck.bas
*include ..\include.src.bas\CurrentElementGroupID.bas
*#
*If(CurrentType==SignMinus && groupID<=SignMinus)
// *CurrentType *groupID *ElemsMat *ElemsNum *ElemsNnode ;
*# If(ElemsType==3 || ElemsType==2)
*# MessageBox error: You can't use 2D elements(on Surfaces) in 3D. This problem solve: Meshing->Mesh criteria->No Mesh->Surfaces (please select all)
*# Else
*tcl(TK_Signal *ElemsNum)

ElemsNum    *ElemsNum *ElemsConec
ElemsMat    *ElemsMat
CurrentType *CurrentType
ElemsType *ElemsType
ElemsNnode *ElemsNnode

// ERROR: You don't have assigned Material *ElemsMat at Element *ElemsNum For first number of unassigned element
*tcl(TK_VypisMessageBox *ElemsMat *ElemsNum)
*# EndIf
*# *WarningBox Warning: You don't have assigned Material for Element ID ElemsNum(Int) *ElemsNum(Int)
*EndIf
*If(PreviousType!=CurrentType || PreviousIndex!=groupID)
*#
*#include ..\include.src.bas\ElementType3.bas
*tcl(TK_WriteElementType2Activity *ElemsMatProp(0) *ElemsType *ElemsNnode *AddTranspAnalysis *groupID)
*#
 ELEMENT GROUP ID *groupID TYPE *groupID /** *ElemsMatProp(0)/*ElemsMatProp(1) - *CurrentType **/ MATERIAL *ElemsMat GEOMETRY  *ElemsMat
 ELEMENT INCIDENCES
// *ElemsMatProp(0) *ElemsMatProp(1)
*EndIf
*#
*include ..\include.src.bas\ElementConectivities.bas
*#
*#EndIf
*End elems

*# pro deskove prvky je nyni nutne zapsat PREPARE_CALCULATION flag
*Set Var ElemConstrActiv=0
*If(nshells>0||nbeam>0)
*#tcl(TK_WriteShellPrepareCalculation *Cond(Assign_material) *ElemsType *ElemsNnode *AddTranspAnalysis *groupID)
*include ..\include.src.bas\ShellPrepareCalculation.bas
*EndIf

*# Set elems(Linear)
*# Set Var nrods=nelem(Linear)
*# If(nrods>0)
*# // Vypis tycovych prvku primo Do inpu - neni automaticky zajisteno spojeni s konstrukci - experimentalni provoz
*# // pozor spojeni s konstrukci musi zajistit uzivatel(koncove uzly prutu musi byt soucasne uzly dalsi konstrukce) 
*# *Set Var oMaxReinfGroups=-1
*# *include ..\include.src.bas\Write_Clasic_Bar_Element.bas
*# *#
*# // Vypis Embedded_Reinforcement generovanych prvku - spojeni s konstrukci zajisteno samo
*# *include ..\include.src.bas\Write_Trusses_and_Cables.bas
*# // End block of Reinforcement
*# EndIf 

*Set elems(All)
*#// Writing SELECTIONs
*#include ..\include.src.bas\TransportElementSelection.bas
*#include ..\include.src.bas\LoadElementSelection.bas // selection se odted zapisuji pred kazdym intervalem
*#
*#Set Var ApplyInSubIncrement=2
*Set Var ApplyInSubIncrement=0
*#If(strcmp(GenData(Calculation_Analysis),"SandwichTemperature3D")!=0)
*#// veskere Master nodes v jednom listu a veskere Slave nodes ve druhem listu
*#include ..\include.src.bas\MasterSlaveSelectionNodes.bas

*#// Master nodes a Slave nodes v samostatnych listech
*#include ..\include.src.bas\Contact_for_Surface.bas   // selection se odted zapisuji pred kazdym intervalem
*#EndIf
*#
*IntFormat "%10i"
*Set Var oiSel=988800
*#
	Function ID *oiSel NAME "Load function#*oiSel" TYPE "CCMultiLinearFunction" REMOVE_ALL XVALUES 0.0  YVALUES 1.0 ;
	MACRO_JOINT COORDINATES *oiSel 0.0 0.0 0.0
	SELECTION "all_nodes#*oiSel" GENERATE NODES WITHIN  DISTANCE 1000000.0 FROM  POINT MACRO NODES *oiSel Execute ;

*#
*# writing information For Maximal Monitored values
*# begin block of Maximal Monitors
// to generate automatic selections of the generated reinforcement nodes
T3D_EXPAND_SELECTIONS PROP_GENERATION AUTOMATIC
*include ..\include.src.bas\MaxMonitor_for.bas
//	-> block of MaxMonitors  #*nMaxMonitor
*#
*# begin block of Clasic Monitors
*include ..\include.src.bas\Clasic_Monitor_for_nodes.bas
//	-> block of Monitors  #*nMonitor
 ; 

OUTPUT  MONITOR_2 NAME "% of load in interval" EACH STEP 
LOCATION OUTPUT_DATA 
DATA LIST "USER_LOAD_CASES_CONTRIBUTION" ITEM FROM 2 TO 2 END 
TRACK ;

OUTPUT  MONITOR_2 NAME "summation % of load in interval" SUMMATION EACH STEP  
LOCATION OUTPUT_DATA 
DATA LIST "USER_LOAD_CASES_CONTRIBUTION" ITEM FROM 2 TO 2 END 
TRACK ;

*#
*If(GenData(Write_IP_coordinates_to_output,Int)==1)
OUTPUT STANDARD RECORD LENGTH 1000 LOCATION ELEMENT_IPS DATA LIST "REFERENCE_IP_COORDINATES" END ;
*#Else
*#OUTPUT STANDARD RECORD LENGTH 1000 LOCATION OUTPUT_DATA DATA ALL ;
*EndIf
*#

*include ..\include.src.bas\WriteLayerSelection.bas

//----------------------------------------------------------------------------
//                          Default Setting of Method
//----------------------------------------------------------------------------
SET *GenData(Method)
*If(strcmp(GenData(Method),"Arc-Length")==0)
 *GenData(Arc-Length_Method)
 *GenData(Arc-Length_Adjustment_Method)
 LOAD_DISPLACEMENT_RATIO *GenData(Arc-Length_Load-displacement_ratio,real)
 *GenData(Arc-Length_Load-displacement_adjustment_method)
 REFERENCE_NUMBER_OF_ITERATIONS *GenData(Arc-Length_Optimal_number_of_iterations)
SET ARC_LENGTH_RESET_STEP_LENGTH
*EndIf
SET relative TEMPERATURE Error *GenData(Temperature_Error)
SET relative HUMIDITY Error *GenData(Humidity_Error)
SET absolute TEMPERATURE Error *GenData(Absolute_Temperature_Error)
SET absolute HUMIDITY Error *GenData(Absolute_Humidity_Error)
             
*If(GenData(Activate_Negligible_Size_Absolute,Int)==1)
SET absolute NEGLIGIBLE_SIZE *GenData(Negligible_Size_Absolute,Real)
*Else
SET relative NEGLIGIBLE_SIZE *GenData(Negligible_Size_Relative,Real)
*EndIf
SET Iteration limit    *GenData(Iteration_limit)
SET Optimize width     *GenData(Optimize_width)
SET *GenData(Stiffness_type)
*If(strcmp(GenData(Assemble_Stiffness_Matrix),"Each_Iteration")==0)
SET Full_NR
*else
SET Modified_NR
*EndIf
*#If(GenData(Line-Search_Method,Int)==1)
*If(0)
SET Line-Search
SET *GenData(Line_Search_With_Iterations)
SET Unbalanced_Energy_Limit *GenData(Unbalanced_Energy_Limit)
*If(strcmp(GenData(Line_Search_With_Iterations),"Line_Search_With_Iterations")==0)
SET Line_Search_Iteration_Limit *GenData(Line_Search_Iteration_Limit,Int)
*EndIf
SET Minimum_Eta *GenData(Minimum_Eta)
SET Maximum_Eta *GenData(Maximum_Eta)
*EndIf
SET SOLVER *GenData(Solver)
*If(strcmp(GenData(Solver),"PARDISO")==0 || strcmp(GenData(Solver),"ICCG")==0 || strcmp(GenData(Solver),"DCG")==0 || strcmp(GenData(Solver),"DCGN")==0 || strcmp(GenData(Solver),"LUCN")==0)
Set extend_accuracy_factor *GenData(Extend_Accuracy_Factor)
*EndIf
*If(strcmp(GenData(Solver),"PARDISO")==0)
SET PARDISO_REQUIRED_ACCURACY limit *GenData(Pardiso_Required_accuracy,real) 
*EndIf
*If(strcmp(GenData(Solver),"ICCG")==0 || strcmp(GenData(Solver),"DCG")==0 || strcmp(GenData(Solver),"DCGN")==0 || strcmp(GenData(Solver),"LUCN")==0)
Set SLAP_ITERATION LIMIT *GenData(Solver_Iter_limit)
*EndIf
*If(GenData(SOLVE_LHS_BCS_OFF,Int)==1)
SET SOLVE_LHS_BCS_OFF
*EndIf
Set MIN_LHS_BCS_MASTER_NODE_COEFF *GenData(MIN_LHS_BCS_MASTER_NODE_COEFF,Real)

*If(GenData(Conditional_Break_Criteria,Int)==1)
*include ..\include.src.bas\Advanced_set_method.bas
*Else
*include ..\include.src.bas\Advanced_set_method_default.bas
*EndIf

//----------------------------------------------------------------------------\\
//                                 Load step definitions                      \\
//----------------------------------------------------------------------------\\
/**
CURRENT_TRANSIENT_TIME of GenData is replaced by INTERVAL_STARTING_TIME of 1. Interval
*tcl(Set_Starting_Time1Interval_To_Current_TimeGenData )
**/
*Set Var IntervalIndex=0
*loop intervals
*Set Var IntervalIndex=Operation(IntervalIndex+1)
*If(IntervalIndex==1)
SET TRANSIENT TIME CURRENT *IntvData(INTERVAL_STARTING_TIME,Real)
*EndIf
*End Intervals

//SET TRANSIENT TIME CURRENT *GenData(CURRENT_TRANSIENT_TIME,Real)
SET TRANSIENT TIME_INTEGRATION *GenData(TIME_INTEGRATION_OF_TRANSIENT)
*If(strcmp(GenData(TIME_INTEGRATION_OF_TRANSIENT),"CRANK_NICHOLSON")==0)
THETA *GenData(THETA_OF_CRANK_NICHOLSON)
*Else
NEWMARK BETA *GenData(NEWMARK_BETA_OF_ADAMS_BASHFORTH)
NEWMARK GAMA *GenData(NEWMARK_GAMA_OF_ADAMS_BASHFORTH)
*EndIf

*If(GenData(EXPORT_TRANSPORT_RESULTS,Int)==1) Then
HISTORY OVERWRITE EXPORT GEOMETRY "*GenData(EXPORT_GEOMETRY_TO)"
RESULTS  "*GenData(EXPORT_RESULTS_TO)"
*EndIf

/** Load case combination **/
Output Record Length 9000
// Apply load case 1 and etc. on the model
*Set Var AddingConstruction=3000
*Set Var StepIndex=0
*Set Var IntervalIndex=0
*Set Var IntervalIndex2=0
*Set elems(All)

*Set Var oflagElmIDMerge=1
*If(GenData(Show_Surface_Loads_In_Post-Processor,Int)==0)
*Set Var oflagElmIDMerge=0
*EndIf

*loop intervals
*Set Var IntervalIndex2=Operation(IntervalIndex2+1)
*Set Var krokVIntervalu=Operation(0+1)
*Set Var krokVIntervaluActivity=Operation(0+1)
*If(IntvData(Interval_Is_Active,real)==1)
*#
*Set Var IntervalIndex=Operation(IntervalIndex+1)
*Set Var ApplyInSubIncrement=1

*# selection se zapisuji pred kazdym intervalem
*include ..\include.src.bas\LoadElementSelection_beforeStep.bas
*include ..\include.src.bas\Contact_for_Surface_before_step.bas

*#include ..\include.src.bas\SelectionNodes.bas 
*#// hloupy zapis selection nodes
*include ..\include.src.bas\SelectionNodes2.bas 
*#//chytry zapis selection nodes
*#include ..\include.src.bas\SelectionElements2.bas 
*#//chytry zapis selection elements

// begin of block For Load Case
*include ..\include.src.bas\WriteLoadCase_for_Transport.bas
*#
*Set Var multip=Operation(IntvData(INTERVAL_Multiplier,Real)/IntvData(Number_of_LOAD_STEPs,Real))

*Set Var LastInteractMater=0
*Set Var EActivity=0
*Set Var ElemConstrActiv=1

*#If(strcmp(GenData(Calculation_Analysis),"SandwichTemperature3D")!=0)
*include ..\include.src.bas\ElementActivityDelete.bas
*include ..\include.src.bas\ElementActivity.bas
*#EndIf

*#include ..\include.src.bas\ElementActivityInterval.bas

*If(IntvData(User_Solution_Parameters,Int)==1)
//----------------------------------------------------------------------------\\
//                      Setting of Method in INTERVAL *IntervalIndex             \\
//----------------------------------------------------------------------------\\
SET *IntvData(Method)
*If(strcmp(IntvData(Method),"Arc-Length")==0)
 *GenData(Arc-Length_Method)
 *GenData(Arc-Length_Adjustment_Method)
 LOAD_DISPLACEMENT_RATIO *GenData(Arc-Length_Load-displacement_ratio,real)
 *GenData(Arc-Length_Load-displacement_adjustment_method)
 REFERENCE_NUMBER_OF_ITERATIONS *GenData(Arc-Length_Optimal_number_of_iterations)
SET ARC_LENGTH_RESET_STEP_LENGTH
*EndIf
SET relative TEMPERATURE Error *IntvData(Temperature_Error)
SET relative HUMIDITY Error *IntvData(Humidity_Error)
SET absolute TEMPERATURE Error *IntvData(Absolute_Temperature_Error)
SET absolute HUMIDITY Error *IntvData(Absolute_Humidity_Error)

SET Iteration limit    *IntvData(Iteration_limit)
SET Optimize width     *IntvData(Optimize_width)
SET *IntvData(Stiffness_type)
*If(strcmp(IntvData(Assemble_Stiffness_Matrix),"Each_Iteration")==0)
SET Full_NR
*else
SET Modified_NR
*EndIf
*#If(IntvData(Line-Search_Method,Int)==1)
*If(0)
SET Line-Search
SET *IntvData(Line_Search_With_Iterations)
SET Unbalanced_Energy_Limit *IntvData(Unbalanced_Energy_Limit)
*If(strcmp(IntvData(Line_Search_With_Iterations),"Line_Search_With_Iterations")==0)
SET Line_Search_Iteration_Limit *IntvData(Line_Search_Iteration_Limit,Real)
*EndIf
SET Minimum_Eta *IntvData(Minimum_Eta)
SET Maximum_Eta *IntvData(Maximum_Eta)
*EndIf
Set SOLVER *IntvData(Solver)
*If(strcmp(IntvData(Solver),"PARDISO")==0)
SET PARDISO_REQUIRED_ACCURACY limit *IntvData(Pardiso_Required_accuracy,real) 
*EndIf
*If(strcmp(IntvData(Solver),"ICCG")==0 || strcmp(IntvData(Solver),"DCG")==0 || strcmp(IntvData(Solver),"DCGN")==0 || strcmp(IntvData(Solver),"LUCN")==0)
Set SLAP_ITERATION LIMIT *IntvData(Solver_Iter_limit)
*EndIf
*EndIf
//----------------------------------------------------------------------------- 
//  DEFINITION and EXECUTION OF INTERVAL *IntervalIndex Name:*IntvData(LOAD_NAME)
//----------------------------------------------------------------------------- 
/** Number of steps in Interval *IntervalIndex = *IntvData(Number_of_LOAD_STEPs,Int) **/

*include ..\include.src.bas\WriteTransportStep.bas
*Set Var IsIntervalWithFire=0
*Else


// GiD Interval number *IntervalIndex2 is disabled
*If(IntervalIndex2==1)
*WarningBox  Warning: Interval 1 is disabled.. if you are using monitors, it is not used
*EndIf
*Set Var IntervalIndex=Operation(IntervalIndex+1)
*EndIf

*End Intervals

*include ..\include.src.bas\MonitorOutput.bas

*include ..\include.src.bas\StepInfo.bas

*# erase monitor data from .prb
*tcl(TK_InitSurfaceCriteria 0 0 0 0 0 0 0 0 0)

/** End of file **/
