*include ..\include.src.bas\Ver.bas
*tcl(TK_CleanMaterialNumberVSGroupID)
*tcl(TK_CleanMinMaxGroupIDVSMaterial)

*#If(ndime==2)
*#WarningBox Info: For exporting Static 2D & 2D Axisymetry & 3D and 3D Shell modeling.
*#EndIf

*include ..\include.src.bas\RestoreFrom.bas

// -----------------------
//  This is a STATIC task 
// -----------------------
MODULE TYPE "CCStructures" CHECK
TASK name "*GenData(TaskName)"

*Set Var Axisym=0
*If(ndime==2 && GenData(Axi_symmetric_task,Int)==1)
*Set Var Axisym=1
*EndIf

Title "*GenData(Title)"
*If(Axisym==1)
 space axisymmetric
*Else
 dimension  *ndime
*EndIf

*If(nmats(Int)==0)
*MessageBox error: You don't have assigned Material
*EndIf
*Realformat "%16.6e"

*# // zapis jednotek
*include ..\include.src.bas\WriteUnits.bas

*Set Var DefaultSpace=3
*include ..\include.src.bas\initialVariablesSetting.bas
*include ..\include.src.bas\Materials.bas

*include ..\include.src.bas\WriteJoints.bas

*#           1=Linear,2=Triangle,3=Quadrilateral,4=Tetrahedra,5=Hexahedra,6=Prism,7=OnlyPoints.
// Element group definition

*# Set Var oMaxIndexElemGroups=0
*Set Var nshells=0
*Set Var nbeam=0
*loop elems
*If(elemsmat==SignMinus || elemsmat==0)

ElemsNum    *ElemsNum *ElemsConec
ElemsMat    *ElemsMat
CurrentType *CurrentType
ElemsType *ElemsType
ElemsNnode *ElemsNnode

*tcl(TK_Signal *ElemsNum)
// ERROR: You don't have assigned Material *ElemsMat at Element *ElemsNum For first number of unassigned element
*tcl(TK_VypisMessageBox *ElemsMat *ElemsNum)
*EndIf
*If(strcmp(ElemsMatProp(Idealisation),"1D")!=0 && strcmp(ElemsMatProp(Material_Prototype),"CCDummyMaterial")!=0)
*#    *ElemsMatProp(Material_Prototype)     ElemsType!=1 1=Linear, toto je samostatna podminka ze se nebudou Vypisovat Trussove prvky v tomto cyklu,
*#                   ale jinde - pozdeji
*#          dalsi podminka je ze se nezapisujou elementy s virtual materialem
*include ..\include.src.bas\InLoopElementCheck.bas
*include ..\include.src.bas\CurrentElementGroupID.bas
*#
*If(CurrentType==SignMinus && groupID<=SignMinus)
*CurrentType *groupID *ElemsMat *ElemsNum *ElemsNnode ;
*If(ElemsType==3 || ElemsType==2)
*# MessageBox error: You can't use 2D elements(on Surfaces) in 3D. This problem solve: Meshing->Mesh criteria->No Mesh->Surfaces (please select all)
*WarningBox Info: You can experimentaly use 2D elements(on Surfaces) in 3D.
*Else
ElemsNum    *ElemsNum *ElemsConec
ElemsMat    *ElemsMat
CurrentType *CurrentType
ElemsType   *ElemsType
ElemsNnode  *ElemsNnode
*tcl(TK_Signal *ElemsNum)
*MessageBox error: You don't have assigned Material *ElemsMat at Element *ElemsNum For first number of unassigned element see *.dat file
*EndIf
*# *WarningBox Warning: You don't have assigned Material for Element ID ElemsNum(Int) *ElemsNum(Int)
*EndIf
*If((PreviousType!=CurrentType || PreviousIndex!=groupID) )
*#
*#include ..\include.src.bas\ElementType3.bas
*tcl(TK_WriteElementType2Activity *ElemsMatProp(0) *ElemsType *ElemsNnode *AddTranspAnalysis *groupID)
*tcl(TK_SaveMaterialNumberVSGroupID *ElemsMatProp(0) *groupID)
*tcl(TK_SaveMinMaxGroupIDVSMaterial *ElemsMatProp(0) *groupID)
*# // TK_SaveMaterialNumberVSGroupID *ElemsMatProp(0) *groupID
*tcl(TK_ShellCheck *ElemsMatProp(0) *ElemsType *ElemsNnode *AddTranspAnalysis *groupID)

*#
 ELEMENT GROUP ID *groupID TYPE *groupID /** *ElemsMatProp(0)/*ElemsMatProp(1) - *CurrentType **/ MATERIAL *ElemsMat GEOMETRY  *ElemsMat
 ELEMENT INCIDENCES
// *ElemsMatProp(0) *ElemsMatProp(1) CurrentType=*CurrentType ElemsType=*ElemsType ElemsNnode=*ElemsNnode
*EndIf
*#
*include ..\include.src.bas\ElementConectivities.bas
*#
*#// ElemsCenter          *ElemsCenter         
*#// ElemsConec           *ElemsConec          
*#// ElemsLayerName       *ElemsLayerName      
*#// ElemsLayerNum        *ElemsLayerNum       
*#// ElemsMat             *ElemsMat            
*#// ElemsMatProp         *ElemsMatProp(0) *ElemsMatProp(1)         
*#// ElemsNnode           *ElemsNnode          
*#   *# // ElemsNnodeCurt       *#ElemsNnodeCurt      
*#   *#// ElemsNNodeFace       *#ElemsNNodeFace      
*#   *#// ElemsNNodeFaceCurt   *#ElemsNNodeFaceCurt  
*#   *#// ElemsNormal          *#ElemsNormal         
*#   *#// ElemsNum             *#ElemsNum            
*#   *#// ElemsRadius          *#ElemsRadius         
*#// ElemsType            *ElemsType           
*#// ElemsTypeName        *ElemsTypeName       
*#
*EndIf
*End elems

*# pro deskove prvky je nyni nutne zapsat PREPARE_CALCULATION flag
*Set Var ElemConstrActiv=0
*# *nshells *nbeam
*If(nshells>0||nbeam>0)
*#tcl(TK_WriteShellPrepareCalculation *Cond(Assign_material) *ElemsType *ElemsNnode *AddTranspAnalysis *groupID)
*include ..\include.src.bas\ShellPrepareCalculation.bas
*EndIf

// begin block of Cond of Spring
*include ..\include.src.bas\Write_All_Springs.bas
// End block of Spring

*If(ndime==2 && GenData(Axi_symmetric_task,Int)==1)
// For Circular Reinforcement bar
*include ..\include.src.bas\CircularReinforcement.bas
*EndIf

*Set elems(All)
*#// Writing Selections For Load
*#include ..\include.src.bas\LoadElementSelection.bas // selection se odted zapisuji pred kazdym intervalem

*#Set Var ApplyInSubIncrement=2
*Set Var ApplyInSubIncrement=1
*intformat "%d"
*# // veskere Master nodes v jednom listu a veskere Slave nodes ve druhem listu
*# include ..\include.src.bas\MasterSlaveSelectionNodes.bas
*# // Master nodes a Slave nodes v samostatnych listech
*#include ..\include.src.bas\Contact_for_Surface.bas // selection se odted zapisuji pred kazdym intervalem

*# // Writing Load Cases With temerature areas from Transport analysis
*# include ..\include.src.bas\read_transport_temperature_backup01.bas
*#
*#
*# writing information For Maximal Monitored values
*# begin block of Maximal Monitors
// to generate automatic selections of the generated reinforcement nodes
T3D_EXPAND_SELECTIONS PROP_GENERATION AUTOMATIC
*#include ..\include.src.bas\MaxMonitor_for.bas
*#//	-> block of MaxMonitors  #*nMaxMonitor
*#
*#
*# begin block of Clasic Monitors
*#include ..\include.src.bas\Clasic_Monitor_for_nodes.bas
*#//	-> block of Monitors  #*nMonitor
*If(GenData(Write_Fatigue_Applied_Cycles_Monitor,Int)==1)
Output Name "Ncycles" MONITOR_2  LOCATION GLOBAL 
       DATA List  "FATIGUE_DATA" End ;
     
*EndIf
*#

*include ..\include.src.bas\WriteLayerSelection.bas

*# base temperature from problemdata
*If(GenData(Activate_Base_Temperature,Int)==1)
NODAL TEMPERATURE SETTING
BASE_TEMPERATURE *GenData(Base_Temperature,real) ;
     
*EndIf
*# base humidity from problemdata
*If(GenData(Activate_Base_Humidity,Int)==1)
NODAL HUMIDITY SETTING
BASE_HUMIDITY *GenData(Base_Humidity,real) ;
     
*EndIf
*Set Var Vypsanimacrojointu=Operation(0+0)
//----------------------------------------------------------------------------
//                          Default Setting of Method
//----------------------------------------------------------------------------
// Set analysis option/switch
SET *GenData(Method)
*If(strcmp(GenData(Method),"Arc-Length")==0)
 *GenData(Arc-Length_Method)
 *GenData(Arc-Length_Adjustment_Method)
 LOAD_DISPLACEMENT_RATIO *GenData(Arc-Length_Load-displacement_ratio,real)
 *GenData(Arc-Length_Load-displacement_adjustment_method)
 REFERENCE_NUMBER_OF_ITERATIONS *GenData(Arc-Length_Optimal_number_of_iterations)
SET ARC_LENGTH_RESET_STEP_LENGTH
*#
*If(GenData(SetStepLenghtAtNode,Int)==1)
SET STEP_LENGTH_ONCE *GenData(STEP_LENGTH_ONCE,real)
  MIN_REL_REF_STEP_LENGTH 1.0 MAX_REL_REF_STEP_LENGTH 1.000000
  LOCATION NODE AT *GenData(STEP_LENGTH_ONCE_Node,Int) DOF AT *\
*If(strcmp(GenData(STEP_LENGTH_ONCE_Dir),"X")==0)
 1 *\
*ElseIf(strcmp(GenData(STEP_LENGTH_ONCE_Dir),"Y")==0)
 2 *\
*Else
 3 *\
*EndIf
 COEFF 1.000 
*EndIf
*#
*#
*#
*EndIf
SET relative DISPLACEMENT Error *GenData(Displacement_Error,real)
SET relative RESIDUAL Error     *GenData(Residual_Error,real)
SET absolute RESIDUAL Error *GenData(Absolute_Residual_Error,real)
SET relative ENERGY Error       *GenData(Energy_Error,real)

*If(GenData(Activate_Negligible_Size_Absolute,Int)==1)
SET absolute NEGLIGIBLE_SIZE *GenData(Negligible_Size_Absolute,Real)
*Else
SET relative NEGLIGIBLE_SIZE *GenData(Negligible_Size_Relative,Real)
*EndIf
SET Iteration limit    *GenData(Iteration_limit,Int)
SET Optimize width     *GenData(Optimize_Band_Width)
SET *GenData(Stiffness_type)
*If(strcmp(GenData(Assemble_Stiffness_Matrix),"Each_Iteration")==0)
SET Full_NR
*Else
SET Modified_NR
*EndIf
*If(GenData(Line-Search_Method,Int)==1)
SET Line-Search
SET *GenData(Line_Search_With_Iterations)
SET Unbalanced_Energy_Limit *GenData(Unbalanced_Energy_Limit,real)
*If(strcmp(GenData(Line_Search_With_Iterations),"Line_Search_With_Iterations")==0)
SET Line_Search_Iteration_Limit *GenData(Line_Search_Iteration_Limit,Int)
*EndIf
SET Minimum_Eta *GenData(Minimum_Eta,real)
SET Maximum_Eta *GenData(Maximum_Eta,real)
*EndIf
SET SOLVER *GenData(Solver)
*If(strcmp(GenData(Solver),"PARDISO")==0 || strcmp(GenData(Solver),"ICCG")==0 || strcmp(GenData(Solver),"DCG")==0 || strcmp(GenData(Solver),"DCGN")==0 || strcmp(GenData(Solver),"LUCN")==0)
Set extend_accuracy_factor *GenData(Extend_Accuracy_Factor)
*EndIf
*If(strcmp(GenData(Solver),"PARDISO")==0)
SET PARDISO_REQUIRED_ACCURACY limit *GenData(Pardiso_Required_accuracy,real) 
*EndIf
*If(strcmp(GenData(Solver),"ICCG")==0 || strcmp(GenData(Solver),"DCG")==0 || strcmp(GenData(Solver),"DCGN")==0 || strcmp(GenData(Solver),"LUCN")==0)
Set SLAP_ITERATION LIMIT *GenData(Solver_Iter_limit)
*EndIf
*If(GenData(SOLVE_LHS_BCS_OFF,Int)==1)
SET SOLVE_LHS_BCS_OFF
*EndIf
Set MIN_LHS_BCS_MASTER_NODE_COEFF *GenData(MIN_LHS_BCS_MASTER_NODE_COEFF,Real)
*If(GenData(Trace_OFF,Real)==1)
OUTPUT LOCATION ELEMENTS TRACE OFF
*Endif

*# pokracuje klasicky zapis 

Output Record Length 9000

*If(GenData(Conditional_Break_Criteria,Int)==1)
*include ..\include.src.bas\Advanced_set_method.bas
*Else
*include ..\include.src.bas\Advanced_set_method_default.bas
*EndIf

*If(GenData(Use_Iteration_With_Lowest_Error,Int)==1)
SET  USE_BEST_ITERATION_FOR_CRITERION *GenData(USE_BEST_ITERATION_FOR_CRITERION)
SET BEST_ITERATION_MIN_ID *GenData(BEST_ITERATION_MIN_ID)
*Else
SET USE_BEST_ITERATION_FOR_CRITERION 0 
*EndIf

*If(GenData(Repeat_No_Converged_Step,Int)==1)
SET  STEP_LOAD_REDUCTION_ALLOWANCE *GenData(STEP_LOAD_REDUCTION_ALLOWANCE,int)
SET  REDUCE_STEP_LOAD_COEFF *GenData(REDUCE_STEP_LOAD_COEFF,real)
*EndIf

*Set Var nEActivity=0
*Set Var StepIndex=0
*Set Var IntervalIndex=0
*Set Var IntervalIndex2=0
*Set Var OneGroupID=-1
*If(oMinIndexElemGroups==oMaxIndexElemGroups)
*Set Var OneGroupID=oMinIndexElemGroups
*EndIf

*#Set elems(All)
*Set Var ApplyInSubIncrement=1
*loop Intervals
*Set Var IntervalIndex2=Operation(IntervalIndex2+1)
*Set Var krokVIntervalu=Operation(0+1)
*Set Var krokVIntervaluActivity=Operation(0+1)
*If(IntvData(Interval_Is_Active,real)==1)
*Set Var IntervalIndex=Operation(IntervalIndex+1)


*# selection se zapisuji pred kazdym intervalem
*include ..\include.src.bas\LoadElementSelection_beforeStep.bas
*include ..\include.src.bas\Contact_for_Surface_before_step.bas
*include ..\include.src.bas\Fixed_2D_Shell_to_Solid_for_before_step.bas
*include ..\include.src.bas\Fixed_1D_Beam_to_Solid_for_before_step.bas
*#include ..\include.src.bas\Fixed_1D_Beam_to_2D_Shell_for_before_step.bas

*include ..\include.src.bas\SelectionGlobalNodes.bas

*include ..\include.src.bas\Load_universally_for_before_step.bas

*#include ..\include.src.bas\SelectionNodes.bas 
*#// hloupy zapis selection nodes
*include ..\include.src.bas\SelectionNodes2.bas 
*#//chytry zapis selection nodes
*#include ..\include.src.bas\SelectionElements2.bas 
*#//chytry zapis selection elements
*# Initial temperature
*include ..\include.src.bas\Initial_Temp_for.bas
*# Initial humidity
*include ..\include.src.bas\Initial_Humi_for.bas


*Set elems(all)
*Set Var oldElemsMat=0
*Set Var EActivity=0
*#Set Var LastInteractMater=0
*Set Var ElemConstrActiv=1
*include ..\include.src.bas\ElementActivityDelete.bas
*include ..\include.src.bas\ElementActivity.bas
*include ..\include.src.bas\ElementActivityReinfInactivity.bas

*#include ..\include.src.bas\ElementActivityInterval.bas

*include ..\include.src.bas\Boundary_Reactions_for_Line.bas

*Set elems(Linear)
*Set Var nrods=nelem(Linear)
*If(nrods>0)
*Set Var oMaxReinfGroups=-1
*# // Vypis tycovych prvku primo Do inpu - neni automaticky zajisteno spojeni s konstrukci - experimentalni provoz
*#// pozor spojeni s konstrukci musi zajistit uzivatel(koncove uzly prutu musi byt soucasne uzly dalsi konstrukce) 
*include ..\include.src.bas\Write_Clasic_Bar_Element.bas
*#
*# // Vypis Embedded_Reinforcement generovanych prvku - spojeni s konstrukci zajisteno samo
*include ..\include.src.bas\Write_Trusses_and_Cables.bas

*include ..\include.src.bas\Write_Trusses_and_Cables_Reconnect.bas

// End block of Reinforcement
*EndIf

*If(strcmp(GenData(Calculation_Analysis),"Static")==0)
*include ..\include.src.bas\Write_digicon.bas
*EndIf 



*If(IntervalIndex<2)
// experimental write monitors here
*include ..\include.src.bas\MaxMonitor_for.bas
//	-> block of MaxMonitors  #*nMaxMonitor

*include ..\include.src.bas\Clasic_Monitor_for_nodes.bas

OUTPUT  MONITOR_2 NAME "% of load in interval" EACH STEP 
LOCATION OUTPUT_DATA 
DATA LIST "USER_LOAD_CASES_CONTRIBUTION" ITEM FROM 2 TO 2 END 
TRACK ;

OUTPUT  MONITOR_2 NAME "summation % of load in interval" SUMMATION EACH STEP  
LOCATION OUTPUT_DATA 
DATA LIST "USER_LOAD_CASES_CONTRIBUTION" ITEM FROM 2 TO 2 END 
TRACK ;

*#
*If(GenData(Write_IP_coordinates_to_output,Int)==1)
OUTPUT STANDARD RECORD LENGTH 1000 LOCATION ELEMENT_IPS DATA LIST "REFERENCE_IP_COORDINATES" END ;
*#Else
*#OUTPUT STANDARD RECORD LENGTH 1000 LOCATION OUTPUT_DATA DATA ALL ;
*EndIf
*#

*EndIf

*Set elems(all)
// begin of block For Load Case
*include ..\include.src.bas\WriteLoadCase_for.bas
*Set Var multip=Operation(IntvData(INTERVAL_Multiplier,Real)/IntvData(Number_of_LOAD_STEPs,Real))


*include ..\include.src.bas\LoadInitalGap.bas 

*If(IntvData(Add_SubInp_Before_Steps,Int)==1)
// begin of adding inp from file *IntvData(File_to_input)
*tcl(DejObsahSouboruMaterial *IntvData(File_to_input) "" "Template_for_lc.bas")
// end of adding inp from file *IntvData(File_to_input)
*EndIf

//----------------------------------------------------------------------------
//  DEFINITION and EXECUTION OF Interval *IntervalIndex Name *IntvData(LOAD_NAME)
//----------------------------------------------------------------------------
/** Total of steps in Interval# *IntervalIndex: *IntvData(Number_of_LOAD_STEPs,INT) **/

*include ..\include.src.bas\UserSolutionParameters.bas
*#include ..\include.src.bas\EigenSolutionParameters.bas
*#4.IntervalIndex = *IntervalIndex

*# uvnitr nasledujiciho include se zapisuje take cteni teplotnich poli...
*include ..\include.src.bas\WriteStaticStep.bas
*#5.IntervalIndex = *IntervalIndex

*# Vlastni cisla a vektory se pisi za celou sadu substepu
*include ..\include.src.bas\WriteEigenStep.bas
*#6.IntervalIndex = *IntervalIndex

*# Delete of current loadcase after Static and Eigen step
*include ..\include.src.bas\DeleteStaticLoadCase.bas
*#7.IntervalIndex = *IntervalIndex

*Else


// GiD Interval number *IntervalIndex2 is disabled
*If(IntervalIndex2==1)
*WarningBox  Warning: Interval 1 is disabled.. if you are using monitors or reinforcements, it is not used
*EndIf
*Set Var IntervalIndex=Operation(IntervalIndex+1)

*EndIf

*End Intervals

*include ..\include.src.bas\MonitorOutput.bas

*include ..\include.src.bas\StepInfo.bas

*# erase monitor data from .prb
*tcl(TK_InitSurfaceCriteria 0 0 0 0 0 0 0 0 0)

/** End of file **/
