*include ..\include.src.bas\Ver.bas
*tcl(TK_CleanMaterialNumberVSGroupID)
*tcl(TK_CleanMinMaxGroupIDVSMaterial)

*If(ndime==2)
*#WarningBox Info: For exporting Creep 2D & 2D Axisymetry & 3D and 3D Shell modeling.
*EndIf

*include ..\include.src.bas\RestoreFrom.bas

// ----------------------
//  This is a CREEP task 
// ----------------------
MODULE TYPE "CCStructuresCreep" CHECK
TASK name "*GenData(TaskName)"
*Set Var Axisym=0
*If(ndime==2 && GenData(Axi_symmetric_task,Int)==1)
*Set Var Axisym=1
*EndIf
     Title "*GenData(Title)"
*If(Axisym==1)
 space axisymmetric
*Else
 dimension  *ndime
*EndIf

*If(nmats(int)==0)
*MessageBox error: You don't have assigned Material
*EndIf
*Realformat "%16.6e"

*# // zapis jednotek
*include ..\include.src.bas\WriteUnits.bas

SET RETARD_TIMES_PER_DECADE *GenData(Retard_Times_Per_Decade,Int)
RETARDATION TIMES FOR EXECUTION TIMES FROM *GenData(RETARDATION_TIMES_FOR_EXECUTION_TIMES_FROM,Real) 
                                        TO *GenData(RETARDATION_TIMES_FOR_EXECUTION_TIMES_TO,Real)
SET SAMPLE_TIMES_PER_DECADE *GenData(Sample_Times_Per_Decade,Int)

*Set Var DefaultSpace=3
*include ..\include.src.bas\initialVariablesSetting.bas
*include ..\include.src.bas\Materials.bas

*include ..\include.src.bas\WriteJoints.bas

*#           1=Linear,2=Triangle,3=Quadrilateral,4=Tetrahedra,5=Hexahedra,6=Prism,7=OnlyPoints.
// Element group definition
*# Set Var oMaxIndexElemGroups=0
*Set Var nshells=0
*Set Var nbeam=0
*loop elems
*If(elemsmat==SignMinus || elemsmat==0)

ElemsNum    *ElemsNum *ElemsConec
ElemsMat    *ElemsMat
CurrentType *CurrentType
ElemsType *ElemsType
ElemsNnode *ElemsNnode

*tcl(TK_Signal *ElemsNum)
// ERROR: You don't have assigned Material *ElemsMat at Element *ElemsNum For first number of unassigned element
*tcl(TK_VypisMessageBox *ElemsMat *ElemsNum)
*EndIf
*If(strcmp(ElemsMatProp(Idealisation),"1D")!=0)
*#         ElemsType!=1 1=Linear, toto je samostatna podminka ze se nebudou Vypisovat Trussove prvky
*#
*include ..\include.src.bas\InLoopElementCheck.bas
*include ..\include.src.bas\CurrentElementGroupID.bas
*#
*If(CurrentType==SignMinus && groupID<=SignMinus)
*CurrentType *groupID *ElemsMat *ElemsNum *ElemsNnode ;
*If(ElemsType==3 || ElemsType==2)
*# MessageBox error: You can't use 2D elements(on Surfaces) in 3D. This problem solve: Meshing->Mesh criteria->No Mesh->Surfaces (please select all)
*WarningBox Info: You can experimentaly use 2D elements(on Surfaces) in 3D.
*Else

ElemsNum    *ElemsNum *ElemsConec
ElemsMat    *ElemsMat
CurrentType *CurrentType
ElemsType *ElemsType
ElemsNnode *ElemsNnode

*tcl(TK_Signal *ElemsNum)
// ERROR: You don't have assigned Material *ElemsMat at Element *ElemsNum For first number of unassigned element
*tcl(TK_VypisMessageBox *ElemsMat *ElemsNum)
*EndIf
*# *WarningBox Warning: You don't have assigned Material for Element ID ElemsNum(Int) *ElemsNum(Int)
*EndIf
*If((PreviousType!=CurrentType || PreviousIndex!=groupID))
*#
*# CurrentType= *CurrentType ElemsType= *ElemsType
*#
*#include ..\include.src.bas\ElementType3.bas
*tcl(TK_WriteElementType2Activity *ElemsMatProp(0) *ElemsType *ElemsNnode *AddTranspAnalysis *groupID)
*tcl(TK_ShellCheck *ElemsMatProp(0) *ElemsType *ElemsNnode *AddTranspAnalysis *groupID)
*#
 ELEMENT GROUP ID *groupID TYPE *groupID /** *ElemsMatProp(0)/*ElemsMatProp(1) - *CurrentType **/ MATERIAL *ElemsMat GEOMETRY  *ElemsMat
 ELEMENT INCIDENCES
// *ElemsMatProp(0) *ElemsMatProp(1)
*EndIf
*#
*include ..\include.src.bas\ElementConectivities.bas
*#
*EndIf
*End elems

*# pro deskove prvky je nyni nutne zapsat PREPARE_CALCULATION flag
*Set Var ElemConstrActiv=0
*# *nshells *nbeam
*If(nshells>0||nbeam>0)
*#tcl(TK_WriteShellPrepareCalculation *Cond(Assign_material) *ElemsType *ElemsNnode *AddTranspAnalysis *groupID)
*include ..\include.src.bas\ShellPrepareCalculation.bas
*EndIf

// begin block of Spring
*include ..\include.src.bas\Write_All_Springs.bas
// End block of Spring

*If(ndime==2 && GenData(Axi_symmetric_task,Int)==1)
// For Circular Reinforcement bar
*include ..\include.src.bas\CircularReinforcement.bas
*EndIf


*Set elems(All)
*#// Writing SELECTIONs
*#include ..\include.src.bas\LoadElementSelection.bas  // selection se odted zapisuji pred kazdym intervalem

*#Set Var ApplyInSubIncrement=0
*#// veskere Master nodes v jednom listu a veskere Slave nodes ve druhem listu
*#include ..\include.src.bas\MasterSlaveSelectionNodes.bas
*#// Master nodes a Slave nodes v samostatnych listech
*#include ..\include.src.bas\Contact_for_Surface.bas

*Set Var ApplyInSubIncrement=1
*#// veskere Master nodes v jednom listu a veskere Slave nodes ve druhem listu
*#include ..\include.src.bas\MasterSlaveSelectionNodes.bas
*#// Master nodes a Slave nodes v samostatnych listech
*#include ..\include.src.bas\Contact_for_Surface.bas  // selection se odted zapisuji pred kazdym intervalem

*# // Writing Load Cases With temerature areas from Transport analysis
*# include ..\include.src.bas\read_transport_temperature_backup01.bas
*#
*# writing information For Maximal Monitored values
*# begin block of Maximal Monitors
// to generate automatic selections of the generated reinforcement nodes
T3D_EXPAND_SELECTIONS PROP_GENERATION AUTOMATIC
*#include ..\include.src.bas\MaxMonitor_for.bas
*#//	-> block of Monitor  #*nMaxMonitor
*#
*# begin block of Clasic Monitors
*#include ..\include.src.bas\Clasic_Monitor_for_nodes.bas
*#//	-> block of Monitor  #*nMonitor
*#
*If(GenData(APPLY_IN_CREEP_MATERIALS,int)==1)
HISTORY IMPORT
                GEOMETRY "*GenData(IMPORT_FROM_GEOMETRY)"
                RESULTS  "*GenData(IMPORT_FROM_RESULTS)"
*If(GenData(NUMBER_OF_INTERVALS_FOR_HUMIDITY,int)>0)
                NUMBER OF INTERVALS FOR HUMIDITY *GenData(NUMBER_OF_INTERVALS_FOR_HUMIDITY,int)
*EndIf
*If(GenData(NUMBER_OF_INTERVALS_FOR_TEMPERATURE,int)>0)
                NUMBER OF INTERVALS FOR TEMPERATURE *GenData(NUMBER_OF_INTERVALS_FOR_TEMPERATURE,int)
*EndIf
                TIME_UNITS "*GenData(TIME_UNIT_IN_TRANSPORT)"
*EndIf
*#

*include ..\include.src.bas\WriteLayerSelection.bas

*Set Var Vypsanimacrojointu=Operation(0+0)
//----------------------------------------------------------------------------\\
//                           Default Setting of Method                        \\
//----------------------------------------------------------------------------\\
// Set analysis option/switch
SET *GenData(Method)
*If(strcmp(GenData(Method),"Arc-Length")==0)
 *GenData(Arc-Length_Method)
 *GenData(Arc-Length_Adjustment_Method)
 LOAD_DISPLACEMENT_RATIO *GenData(Arc-Length_Load-displacement_ratio,real)
 *GenData(Arc-Length_Load-displacement_adjustment_method)
 REFERENCE_NUMBER_OF_ITERATIONS *GenData(Arc-Length_Optimal_number_of_iterations)
SET ARC_LENGTH_RESET_STEP_LENGTH
*EndIf
SET relative DISPLACEMENT Error *GenData(Displacement_Error,Real)
SET relative RESIDUAL Error     *GenData(Residual_Error,Real)
SET absolute RESIDUAL Error *GenData(Absolute_Residual_Error,Real)
SET relative ENERGY Error       *GenData(Energy_Error,Real)

*If(GenData(Activate_Negligible_Size_Absolute,Int)==1)
SET absolute NEGLIGIBLE_SIZE *GenData(Negligible_Size_Absolute,Real)
*Else
SET relative NEGLIGIBLE_SIZE *GenData(Negligible_Size_Relative,Real)
*EndIf
SET Iteration limit    *GenData(Iteration_limit,Int)
SET Optimize width *GenData(Optimize_band_width)
SET *GenData(Stiffness_type)
*If(strcmp(GenData(Assemble_Stiffness_Matrix),"Each_Iteration")==0)
SET Full_NR
*Else
SET Modified_NR
*EndIf
*If(GenData(Line-Search_Method,int)==1)
SET Line-Search
SET *GenData(Line_Search_With_Iterations)
SET Unbalanced_Energy_Limit *GenData(Unbalanced_Energy_Limit,Real)
*If(strcmp(GenData(Line_Search_With_Iterations),"Line_Search_With_Iterations")==0)
SET Line_Search_Iteration_Limit *GenData(Line_Search_Iteration_Limit,Int)
*EndIf
SET Minimum_Eta *GenData(Minimum_Eta,Real)
SET Maximum_Eta *GenData(Maximum_Eta,Real)
*EndIf
Set SOLVER *GenData(Solver)
*If(strcmp(GenData(Solver),"PARDISO")==0 || strcmp(GenData(Solver),"ICCG")==0 || strcmp(GenData(Solver),"DCG")==0 || strcmp(GenData(Solver),"DCGN")==0 || strcmp(GenData(Solver),"LUCN")==0)
Set extend_accuracy_factor *GenData(Extend_Accuracy_Factor)
*EndIf
*If(strcmp(GenData(Solver),"PARDISO")==0)
SET PARDISO_REQUIRED_ACCURACY limit *GenData(Pardiso_Required_accuracy,real) 
*EndIf
*If(strcmp(GenData(Solver),"ICCG")==0 || strcmp(GenData(Solver),"DCG")==0 || strcmp(GenData(Solver),"DCGN")==0 || strcmp(GenData(Solver),"LUCN")==0)
Set SLAP_ITERATION LIMIT *GenData(Solver_Iter_limit)
*EndIf
*If(GenData(SOLVE_LHS_BCS_OFF,Int)==1)
Set SOLVE_LHS_BCS_OFF
*EndIf
Set MIN_LHS_BCS_MASTER_NODE_COEFF *GenData(MIN_LHS_BCS_MASTER_NODE_COEFF,Real)
*If(GenData(Trace_OFF,Real)==1)
OUTPUT LOCATION ELEMENTS TRACE OFF
*Endif

*If(GenData(Conditional_Break_Criteria,Int)==1)
*include ..\include.src.bas\Advanced_set_method.bas
*Else
*include ..\include.src.bas\Advanced_set_method_default.bas
*EndIf

*If(GenData(Use_Iteration_With_Lowest_Error,Int)==1)
SET  USE_BEST_ITERATION_FOR_CRITERION *GenData(USE_BEST_ITERATION_FOR_CRITERION)
SET BEST_ITERATION_MIN_ID *GenData(BEST_ITERATION_MIN_ID)
*Else
SET USE_BEST_ITERATION_FOR_CRITERION 0 
*EndIf

*If(GenData(Repeat_No_Converged_Step,Int)==1)
SET  STEP_LOAD_REDUCTION_ALLOWANCE *GenData(STEP_LOAD_REDUCTION_ALLOWANCE,int)
SET  REDUCE_STEP_LOAD_COEFF *GenData(REDUCE_STEP_LOAD_COEFF,real)
*EndIf
SET NEGLIGIBLE_TIME_FRACTION *GenData(Extend_NEGLIGIBLE_TIME_FRACTION,Int) 

//----------------------------------------------------------------------------\\
//                                 Load step definitions                      \\
//----------------------------------------------------------------------------\\
//------prestressing, body force "*Units(FORCE)" at day "*Units(TIME)"
Output Record Length 9000
// Apply load case 1 and etc. on the model

*Set Var IntervalNumber=0
*Set Var IntervalNumber2=0
*loop intervals
*Set Var IntervalNumber2=Operation(IntervalNumber2+1)
*Set Var krokVIntervalu=Operation(0+1)
*Set Var krokVIntervaluActivity=Operation(0+1)
*If(IntvData(Interval_Is_Active,real)==1)
*Set Var IntervalNumber=Operation(IntervalNumber+1)
// Interval *IntervalNumber2 is active
*Else
// Interval *IntervalNumber2 is disabled
*EndIf
*End intervals
// Number of active intervals *IntervalNumber
*#
//----------------------------------------------------------------------------\\
//                           DEFINITION OF INTERVALS                          \\
//----------------------------------------------------------------------------\\
*#Set elems(All)
*Set Var IntervalIndex=0
*Set Var IntervalIndex2=0
*Set Var StepIndex=0

*Set Var OneGroupID=-1
*If(oMinIndexElemGroups==oMaxIndexElemGroups)
*Set Var OneGroupID=oMinIndexElemGroups
*EndIf
*#
*loop intervals
*Set Var IntervalIndex2=Operation(IntervalIndex2+1)
*If(IntvData(Interval_Is_Active,real)==1)
*Set Var ElemConstrActiv=0
*Set Var IntervalIndex=Operation(IntervalIndex+1)
*#

*# selection se zapisuji pred kazdym intervalem
*include ..\include.src.bas\LoadElementSelection_beforeStep.bas
*include ..\include.src.bas\Contact_for_Surface_before_step.bas
*include ..\include.src.bas\Fixed_2D_Shell_to_Solid_for_before_step.bas
*include ..\include.src.bas\Fixed_1D_Beam_to_Solid_for_before_step.bas
*#include ..\include.src.bas\Fixed_1D_Beam_to_2D_Shell_for_before_step.bas

*include ..\include.src.bas\SelectionGlobalNodes.bas

*#include ..\include.src.bas\SelectionNodes.bas 
*#// hloupy zapis selection nodes
*include ..\include.src.bas\SelectionNodes2.bas 
*#//chytry zapis selection nodes
*#include ..\include.src.bas\SelectionElements2.bas 
*#//chytry zapis selection elements

*Set elems(all)
*Set Var oldElemsMat=0
*Set Var EActivity=0
*#Set Var LastInteractMater=0
*Set Var ElemConstrActiv=1
*include ..\include.src.bas\ElementActivityDelete.bas
*include ..\include.src.bas\ElementActivity.bas
*include ..\include.src.bas\ElementActivityReinfInactivity.bas

*#include ..\include.src.bas\ElementActivityInterval.bas

*include ..\include.src.bas\Boundary_Reactions_for_Line.bas

*Set elems(Linear)
*Set Var nrods=nelem(Linear)
*If(nrods>0)
*Set Var oMaxReinfGroups=-1
*# // Vypis tycovych prvku primo Do inpu - neni automaticky zajisteno spojeni s konstrukci - experimentalni provoz
*# // pozor spojeni s konstrukci musi zajistit uzivatel(koncove uzly prutu musi byt soucasne uzly dalsi konstrukce) 
*include ..\include.src.bas\Write_Clasic_Bar_Element.bas
*#
*# // Vypis Embedded_Reinforcement generovanych prvku - spojeni s konstrukci zajisteno samo
*include ..\include.src.bas\Write_Trusses_and_Cables.bas
// End block of Reinforcement
*EndIf
*Set elems(all)

*If(IntervalIndex<2)
// experimental write monitors here
*include ..\include.src.bas\MaxMonitor_for.bas
//	-> block of Monitor  #*nMaxMonitor
*include ..\include.src.bas\Clasic_Monitor_for_nodes.bas

OUTPUT  MONITOR_2 NAME "% of load in interval" EACH STEP 
LOCATION OUTPUT_DATA 
DATA LIST "USER_LOAD_CASES_CONTRIBUTION" ITEM FROM 2 TO 2 END 
TRACK ;

OUTPUT  MONITOR_2 NAME "summation % of load in interval" SUMMATION EACH STEP  
LOCATION OUTPUT_DATA 
DATA LIST "USER_LOAD_CASES_CONTRIBUTION" ITEM FROM 2 TO 2 END 
TRACK ;

*#
*If(GenData(Write_IP_coordinates_to_output,Int)==1)
OUTPUT STANDARD RECORD LENGTH 1000 LOCATION ELEMENT_IPS DATA LIST "REFERENCE_IP_COORDINATES" END ;
*#Else
*#OUTPUT STANDARD RECORD LENGTH 1000 LOCATION OUTPUT_DATA DATA ALL ;
*EndIf
*#
*EndIf


*Set Var ApplyInSubIncrement=1
// begin of block For Load Case
*include ..\include.src.bas\WriteLoadCase_for.bas
*#
*Set Var ApplyInSubIncrement=0
*include ..\include.src.bas\WriteLoadCase_for.bas
*#
*Set Var multipFIXED=Operation(IntvData(INTERVAL_Multiplier_for_FIXED,Real)/IntvData(Number_of_LOAD_STEPs,Real))
*Set Var multipINCREMENT=Operation(IntvData(INTERVAL_Multiplier_for_INCREMENT,Real)/IntvData(Number_of_LOAD_STEPs,Real))
*Set Var ATtime=IntvData(INTERVAL_STARTING_TIME,Real)
*Set Var oldElemsMat=0
*Set Var LastInteractMater=0
*Set Var EActivity=0
*Set Var ElemConstrActiv=1
*If(IntervalIndex==1)
*include ..\include.src.bas\Check_TimeParameter.bas
*EndIf
*Set Var stoptime=IntvData(INTERVAL_END_TIME,Real)
*Format "%10.5f"
SET STOP_TIME *stoptime // Redefinition of Stop Time by start of Next step definition

/** Total of steps in Interval# *IntervalIndex: *IntvData(Number_of_LOAD_STEPs,INT) **/

*include ..\include.src.bas\WriteCreepDefinitionStep.bas


*include ..\include.src.bas\LoadInitalGap.bas 

*Set Var multipFIXED=Operation(IntvData(INTERVAL_Multiplier_for_FIXED,Real)/IntvData(Number_of_LOAD_STEPs,Real))
*Set Var multipINCREMENT=Operation(IntvData(INTERVAL_Multiplier_for_INCREMENT,Real)/IntvData(Number_of_LOAD_STEPs,Real))
*Set Var ATtime=IntvData(INTERVAL_STARTING_TIME,Real)
/** Total of steps in Interval# *IntervalIndex: *IntvData(Number_of_LOAD_STEPs,INT) **/
*#
*include ..\include.src.bas\UserSolutionParameters.bas

*# uvnitr nasledujiciho include se zapisuje take cteni teplotnich poli...
*include ..\include.src.bas\WriteCreepExecuteStep.bas
*#
*# Vlastni cisla a vektory se pisi za celou sadu substepu
*include ..\include.src.bas\WriteEigenStep.bas
*#6.IntervalIndex = *IntervalIndex
*#
*# Delete of current loadcase after Static and Eigen step
*include ..\include.src.bas\DeleteStaticLoadCase.bas
*include ..\include.src.bas\DeleteCreepLoadCase.bas

*Else


// GiD Interval number *IntervalIndex2 is disabled
*If(IntervalIndex2==1)
*WarningBox  Warning: Interval 1 is disabled.. if you are using monitors or reinforcements, it is not used
*EndIf
*Set Var IntervalIndex=Operation(IntervalIndex+1)

*EndIf
*End Intervals

*include ..\include.src.bas\MonitorOutput.bas

*include ..\include.src.bas\StepInfo.bas

*# erase monitor data from .prb
*tcl(TK_InitSurfaceCriteria 0 0 0 0 0 0 0 0 0)

/** End of file **/
